/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.util.ArrayUtils;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ext.JavaLang;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ConvertBytes;
import org.jruby.util.Inspector;
import org.jruby.util.RubyStringBuilder;

public final class ArrayJavaProxy
extends JavaProxy {
    private final JavaUtil.JavaConverter converter;
    private static final byte[] END_BRACKET_COLON_SPACE = new byte[]{93, 58, 32};

    public ArrayJavaProxy(Ruby runtime2, RubyClass klazz, Object array2) {
        this(runtime2, klazz, array2, JavaUtil.getJavaConverter(array2.getClass().getComponentType()));
    }

    public ArrayJavaProxy(Ruby runtime2, RubyClass klazz, Object array2, JavaUtil.JavaConverter converter) {
        super(runtime2, klazz, array2);
        this.converter = converter;
    }

    public static RubyClass createArrayJavaProxy(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyClass arrayJavaProxy = runtime2.defineClass("ArrayJavaProxy", runtime2.getJavaSupport().getJavaProxyClass(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass singleton = arrayJavaProxy.getSingletonClass();
        singleton.addMethod("new", new ArrayNewMethod(singleton, Visibility.PUBLIC));
        arrayJavaProxy.defineAnnotatedMethods(ArrayJavaProxy.class);
        arrayJavaProxy.includeModule(runtime2.getEnumerable());
        return arrayJavaProxy;
    }

    public static ArrayJavaProxy newArray(Ruby runtime2, Class<?> elementType, int ... dimensions2) {
        Object array2;
        try {
            array2 = Array.newInstance(elementType, dimensions2);
        }
        catch (IllegalArgumentException e) {
            throw runtime2.newArgumentError("can not create " + dimensions2.length + " dimensional array");
        }
        return new ArrayJavaProxy(runtime2, Java.getProxyClassForObject(runtime2, array2), array2);
    }

    @Override
    protected JavaArray asJavaObject(Object array2) {
        return new JavaArray(this.getRuntime(), array2);
    }

    public final JavaArray getJavaArray() {
        return (JavaArray)this.dataGetStruct();
    }

    public Object get(int index2) {
        return Array.get(this.getObject(), index2);
    }

    public void set(int index2, Object value2) {
        Array.set(this.getObject(), index2, value2);
    }

    public IRubyObject setValue(Ruby runtime2, int index2, IRubyObject value2) {
        return ArrayUtils.asetDirect(runtime2, this.getObject(), this.converter, index2, value2);
    }

    public final int length() {
        return Array.getLength(this.getObject());
    }

    @JRubyMethod(name={"length", "size"})
    public RubyFixnum length(ThreadContext context) {
        return context.runtime.newFixnum(this.length());
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.length() == 0);
    }

    @JRubyMethod(name={"[]"})
    public final IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof RubyRange) {
            return this.arrayRange(context, (RubyRange)arg2);
        }
        int i2 = ArrayJavaProxy.convertArrayIndex(arg2);
        return ArrayUtils.arefDirect(context.runtime, this.getObject(), this.converter, i2);
    }

    @JRubyMethod(name={"[]"}, required=1, rest=true)
    public final IRubyObject op_aref(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 1) {
            return this.op_aref(context, args2[0]);
        }
        return this.getRange(context, args2);
    }

    @JRubyMethod(name={"[]="})
    public final IRubyObject op_aset(ThreadContext context, IRubyObject index2, IRubyObject value2) {
        return this.setValue(context.runtime, ArrayJavaProxy.convertArrayIndex(index2), value2);
    }

    @JRubyMethod(name={"include?", "member?"})
    public IRubyObject include_p(ThreadContext context, IRubyObject obj) {
        Object array2 = this.getObject();
        Class<?> componentClass = array2.getClass().getComponentType();
        if (componentClass.isPrimitive()) {
            switch (componentClass.getName().charAt(0)) {
                case 'b': {
                    if (componentClass == Byte.TYPE) {
                        return RubyBoolean.newBoolean(context, this.includes(context, (byte[])array2, obj));
                    }
                    return RubyBoolean.newBoolean(context, this.includes(context, (boolean[])array2, obj));
                }
                case 's': {
                    return RubyBoolean.newBoolean(context, this.includes(context, (short[])array2, obj));
                }
                case 'c': {
                    return RubyBoolean.newBoolean(context, this.includes(context, (char[])array2, obj));
                }
                case 'i': {
                    return RubyBoolean.newBoolean(context, this.includes(context, (int[])array2, obj));
                }
                case 'l': {
                    return RubyBoolean.newBoolean(context, this.includes(context, (long[])array2, obj));
                }
                case 'f': {
                    return RubyBoolean.newBoolean(context, this.includes(context, (float[])array2, obj));
                }
                case 'd': {
                    return RubyBoolean.newBoolean(context, this.includes(context, (double[])array2, obj));
                }
            }
        }
        return RubyBoolean.newBoolean(context, this.includes(context, (Object[])array2, obj));
    }

    private boolean includes(ThreadContext context, Object[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        Ruby runtime2 = context.runtime;
        for (int i2 = 0; i2 < len; ++i2) {
            IRubyObject value2 = JavaUtil.convertJavaArrayElementToRuby(runtime2, this.converter, array2, i2);
            if (!ArrayJavaProxy.equalInternal(context, value2, obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, byte[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        Ruby runtime2 = context.runtime;
        if (obj instanceof RubyFixnum) {
            long objVal = ((RubyInteger)obj).getLongValue();
            if (objVal < -128L || objVal > 127L) {
                return false;
            }
            for (int i2 = 0; i2 < len; ++i2) {
                if ((byte)objVal != array2[i2]) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < len; ++i3) {
            RubyFixnum value2 = RubyFixnum.newFixnum(runtime2, array2[i3]);
            if (!ArrayJavaProxy.equalInternal(context, value2, obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, short[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        Ruby runtime2 = context.runtime;
        if (obj instanceof RubyFixnum) {
            long objVal = ((RubyInteger)obj).getLongValue();
            if (objVal < -32768L || objVal > 32767L) {
                return false;
            }
            for (int i2 = 0; i2 < len; ++i2) {
                if ((short)objVal != array2[i2]) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < len; ++i3) {
            RubyFixnum value2 = RubyFixnum.newFixnum(runtime2, array2[i3]);
            if (!ArrayJavaProxy.equalInternal(context, value2, obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, int[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        Ruby runtime2 = context.runtime;
        if (obj instanceof RubyFixnum) {
            long objVal = ((RubyInteger)obj).getLongValue();
            if (objVal < Integer.MIN_VALUE || objVal > Integer.MAX_VALUE) {
                return false;
            }
            for (int i2 = 0; i2 < len; ++i2) {
                if ((int)objVal != array2[i2]) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < len; ++i3) {
            RubyFixnum value2 = RubyFixnum.newFixnum(runtime2, array2[i3]);
            if (!ArrayJavaProxy.equalInternal(context, value2, obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, long[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        Ruby runtime2 = context.runtime;
        if (obj instanceof RubyFixnum) {
            long objVal = ((RubyInteger)obj).getLongValue();
            for (int i2 = 0; i2 < len; ++i2) {
                if (objVal != array2[i2]) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < len; ++i3) {
            RubyFixnum value2 = RubyFixnum.newFixnum(runtime2, array2[i3]);
            if (!ArrayJavaProxy.equalInternal(context, value2, obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, char[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        Ruby runtime2 = context.runtime;
        if (obj instanceof RubyFixnum) {
            long objVal = ((RubyInteger)obj).getLongValue();
            if (objVal < 0L || objVal > 65535L) {
                return false;
            }
            for (int i2 = 0; i2 < len; ++i2) {
                if ((int)objVal != array2[i2]) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < len; ++i3) {
            RubyFixnum value2 = RubyFixnum.newFixnum(runtime2, array2[i3]);
            if (!ArrayJavaProxy.equalInternal(context, value2, obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, boolean[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        Ruby runtime2 = context.runtime;
        if (obj instanceof RubyBoolean) {
            boolean objVal = ((RubyBoolean)obj).isTrue();
            for (int i2 = 0; i2 < len; ++i2) {
                if (objVal != array2[i2]) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < len; ++i3) {
            RubyBoolean value2 = RubyBoolean.newBoolean(runtime2, array2[i3]);
            if (!ArrayJavaProxy.equalInternal(context, value2, obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, float[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        Ruby runtime2 = context.runtime;
        if (obj instanceof RubyFloat) {
            double objVal = ((RubyFloat)obj).getDoubleValue();
            for (int i2 = 0; i2 < len; ++i2) {
                if ((float)objVal != array2[i2]) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < len; ++i3) {
            RubyFloat value2 = RubyFloat.newFloat(runtime2, array2[i3]);
            if (!ArrayJavaProxy.equalInternal(context, value2, obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, double[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        Ruby runtime2 = context.runtime;
        if (obj instanceof RubyFloat) {
            double objVal = ((RubyFloat)obj).getDoubleValue();
            for (int i2 = 0; i2 < len; ++i2) {
                if (objVal != array2[i2]) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < len; ++i3) {
            RubyFloat value2 = RubyFloat.newFloat(runtime2, array2[i3]);
            if (!ArrayJavaProxy.equalInternal(context, value2, obj)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"first"})
    public IRubyObject first(ThreadContext context) {
        Object array2 = this.getObject();
        if (Array.getLength(array2) == 0) {
            return context.nil;
        }
        return JavaUtil.convertJavaArrayElementToRuby(context.runtime, this.converter, array2, 0);
    }

    @JRubyMethod(name={"first"})
    public IRubyObject first(ThreadContext context, IRubyObject count2) {
        int size2;
        Object array2 = this.getObject();
        int len = count2.convertToInteger().getIntValue();
        if (len > (size2 = Array.getLength(array2))) {
            len = size2;
        }
        Ruby runtime2 = context.runtime;
        if (len == 0) {
            return RubyArray.newEmptyArray(runtime2);
        }
        IRubyObject[] ary = new IRubyObject[len];
        for (int i2 = 0; i2 < len; ++i2) {
            ary[i2] = JavaUtil.convertJavaArrayElementToRuby(runtime2, this.converter, array2, i2);
        }
        return RubyArray.newArrayNoCopy(runtime2, ary);
    }

    @JRubyMethod(name={"last"})
    public IRubyObject last(ThreadContext context) {
        Object array2 = this.getObject();
        int len = Array.getLength(array2);
        if (len == 0) {
            return context.nil;
        }
        return JavaUtil.convertJavaArrayElementToRuby(context.runtime, this.converter, array2, len - 1);
    }

    @JRubyMethod(name={"last"})
    public IRubyObject last(ThreadContext context, IRubyObject count2) {
        int end2;
        Object array2 = this.getObject();
        int len = RubyFixnum.fix2int(count2);
        int size2 = Array.getLength(array2);
        int start2 = size2 - len;
        if (start2 < 0) {
            start2 = 0;
        }
        if ((end2 = start2 + len) > size2) {
            end2 = size2;
        }
        len = end2 - start2;
        Ruby runtime2 = context.runtime;
        if (len == 0) {
            return RubyArray.newEmptyArray(runtime2);
        }
        IRubyObject[] ary = new IRubyObject[len];
        for (int i2 = 0; i2 < len; ++i2) {
            ary[i2] = JavaUtil.convertJavaArrayElementToRuby(runtime2, this.converter, array2, i2 + start2);
        }
        return RubyArray.newArrayNoCopy(runtime2, ary);
    }

    @JRubyMethod(name={"count"})
    public IRubyObject count(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        if (block.isGiven()) {
            Object array2 = this.getObject();
            int count2 = 0;
            for (int i2 = 0; i2 < Array.getLength(array2); ++i2) {
                IRubyObject next2 = JavaUtil.convertJavaArrayElementToRuby(runtime2, this.converter, array2, i2);
                if (!block.yield(context, next2).isTrue()) continue;
                ++count2;
            }
            return RubyFixnum.newFixnum(runtime2, count2);
        }
        return RubyFixnum.newFixnum(runtime2, this.length());
    }

    @JRubyMethod(name={"count"})
    public IRubyObject count(ThreadContext context, IRubyObject obj, Block unused2) {
        Ruby runtime2 = context.runtime;
        Object array2 = this.getObject();
        int count2 = 0;
        for (int i2 = 0; i2 < Array.getLength(array2); ++i2) {
            IRubyObject next2 = JavaUtil.convertJavaArrayElementToRuby(runtime2, this.converter, array2, i2);
            if (!RubyObject.equalInternal(context, next2, obj)) continue;
            ++count2;
        }
        return RubyFixnum.newFixnum(runtime2, count2);
    }

    @JRubyMethod(name={"dig"}, required=1, rest=true)
    public final IRubyObject dig(ThreadContext context, IRubyObject[] args2) {
        return this.dig(context, args2, 0);
    }

    final IRubyObject dig(ThreadContext context, IRubyObject[] args2, int idx) {
        IRubyObject val = this.at(context, args2[idx++]);
        return idx == args2.length ? val : RubyObject.dig(context, val, args2, idx);
    }

    private static int convertArrayIndex(IRubyObject index2) {
        if (index2 instanceof JavaProxy) {
            return index2.toJava(Integer.class);
        }
        return RubyNumeric.num2int(index2);
    }

    @JRubyMethod
    public IRubyObject at(ThreadContext context, IRubyObject index2) {
        return this.at(context, ArrayJavaProxy.convertArrayIndex(index2));
    }

    private final IRubyObject at(ThreadContext context, int i2) {
        Ruby runtime2 = context.runtime;
        Object array2 = this.getObject();
        int length2 = Array.getLength(array2);
        if (i2 < 0) {
            i2 += length2;
        }
        if (i2 >= 0 && i2 < length2) {
            return ArrayUtils.arefDirect(runtime2, array2, this.converter, i2);
        }
        return context.nil;
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        Object array2 = this.getObject();
        if (other instanceof ArrayJavaProxy) {
            Object otherArray = ((ArrayJavaProxy)other).getObject();
            Class<?> componentType = array2.getClass().getComponentType();
            if (componentType.isAssignableFrom(otherArray.getClass().getComponentType())) {
                return ArrayUtils.concatArraysDirect(context, array2, otherArray);
            }
        }
        return ArrayUtils.concatArraysDirect(context, array2, other);
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            return runtime2.getEnumerator().callMethod("new", this, runtime2.newSymbol("each"));
        }
        Object array2 = this.getObject();
        int length2 = Array.getLength(array2);
        for (int i2 = 0; i2 < length2; ++i2) {
            IRubyObject element = ArrayUtils.arefDirect(runtime2, array2, this.converter, i2);
            block.yield(context, element);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_with_index(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            return runtime2.getEnumerator().callMethod("new", this, runtime2.newSymbol("each_with_index"));
        }
        boolean twoArguments = block.getSignature().isTwoArguments();
        Object array2 = this.getObject();
        int length2 = Array.getLength(array2);
        for (int i2 = 0; i2 < length2; ++i2) {
            IRubyObject element = ArrayUtils.arefDirect(runtime2, array2, this.converter, i2);
            RubyFixnum index2 = RubyFixnum.newFixnum(runtime2, i2);
            if (twoArguments) {
                block.yieldSpecific(context, element, index2);
                continue;
            }
            block.yield(context, RubyArray.newArray(runtime2, element, index2));
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"to_a", "entries"}, alias={"to_ary"})
    public RubyArray to_a(ThreadContext context) {
        Object array2 = this.getObject();
        return JavaUtil.convertJavaArrayToRubyWithNesting(context, array2);
    }

    @JRubyMethod(name={"component_type"})
    public IRubyObject component_type(ThreadContext context) {
        Class<?> componentType = this.getObject().getClass().getComponentType();
        return Java.getProxyClass(context.runtime, componentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public RubyString inspect(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        Class<?> componentClass = this.getObject().getClass().getComponentType();
        if (componentClass.isPrimitive()) {
            return this.inspectPrimitiveArray(runtime2, componentClass);
        }
        Object[] ary = (Object[])this.getObject();
        RubyModule type2 = Java.getProxyClass(runtime2, componentClass);
        RubyString buf = Inspector.inspectPrefixTypeOnly(context, type2);
        RubyStringBuilder.cat(runtime2, buf, Inspector.BEG_BRACKET);
        RubyStringBuilder.cat(runtime2, buf, ConvertBytes.intToCharBytes(ary.length));
        RubyStringBuilder.cat(runtime2, buf, END_BRACKET_COLON_SPACE);
        if (ary.length == 0) {
            RubyStringBuilder.cat(runtime2, buf, Inspector.EMPTY_ARRAY_BL);
        } else if (runtime2.isInspecting(ary)) {
            RubyStringBuilder.cat(runtime2, buf, Inspector.RECURSIVE_ARRAY_BL);
        } else {
            try {
                runtime2.registerInspecting(ary);
                RubyStringBuilder.cat(runtime2, buf, Inspector.BEG_BRACKET);
                for (int i2 = 0; i2 < ary.length; ++i2) {
                    RubyString s2 = JavaUtil.inspectObject(context, ary[i2]);
                    if (i2 > 0) {
                        RubyStringBuilder.cat(runtime2, buf, Inspector.COMMA_SPACE);
                    } else {
                        buf.setEncoding(s2.getEncoding());
                    }
                    buf.cat19(s2);
                }
                RubyStringBuilder.cat(runtime2, buf, Inspector.END_BRACKET);
            }
            finally {
                runtime2.unregisterInspecting(ary);
            }
        }
        RubyStringBuilder.cat(runtime2, buf, Inspector.GT);
        return buf;
    }

    private RubyString inspectPrimitiveArray(Ruby runtime2, Class<?> componentClass) {
        int len = Array.getLength(this.getObject());
        StringBuilder buffer = new StringBuilder(24);
        String name2 = componentClass.getName();
        buffer.append("#<Java::").append(name2).append('[').append(len).append("]: ");
        switch (name2.charAt(0)) {
            case 'b': {
                if (componentClass == Byte.TYPE) {
                    buffer.append(Arrays.toString((byte[])this.getObject()));
                    break;
                }
                buffer.append(Arrays.toString((boolean[])this.getObject()));
                break;
            }
            case 's': {
                buffer.append(Arrays.toString((short[])this.getObject()));
                break;
            }
            case 'c': {
                return ArrayJavaProxy.inspectCharArrayPart(runtime2, buffer, (char[])this.getObject(), len);
            }
            case 'i': {
                buffer.append(Arrays.toString((int[])this.getObject()));
                break;
            }
            case 'l': {
                buffer.append(Arrays.toString((long[])this.getObject()));
                break;
            }
            case 'f': {
                buffer.append(Arrays.toString((float[])this.getObject()));
                break;
            }
            case 'd': {
                buffer.append(Arrays.toString((double[])this.getObject()));
            }
        }
        return RubyString.newUSASCIIString(runtime2, buffer.append('>').toString());
    }

    private static RubyString inspectCharArrayPart(Ruby runtime2, StringBuilder buffer, char[] ary, int len) {
        buffer.append('[');
        int i2 = 0;
        while (true) {
            JavaLang.Character.inspectCharValue(buffer, ary[i2]);
            if (i2 == len - 1) break;
            buffer.append(", ");
            ++i2;
        }
        buffer.append(']');
        return RubyString.newString(runtime2, buffer.append('>'));
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(24);
        Class<?> componentClass = this.getObject().getClass().getComponentType();
        String name2 = componentClass.getName();
        buffer.append(name2);
        if (componentClass.isPrimitive()) {
            switch (name2.charAt(0)) {
                case 'b': {
                    if (componentClass == Byte.TYPE) {
                        buffer.append(Arrays.toString((byte[])this.getObject()));
                        break;
                    }
                    buffer.append(Arrays.toString((boolean[])this.getObject()));
                    break;
                }
                case 's': {
                    buffer.append(Arrays.toString((short[])this.getObject()));
                    break;
                }
                case 'c': {
                    buffer.append(Arrays.toString((char[])this.getObject()));
                    break;
                }
                case 'i': {
                    buffer.append(Arrays.toString((int[])this.getObject()));
                    break;
                }
                case 'l': {
                    buffer.append(Arrays.toString((long[])this.getObject()));
                    break;
                }
                case 'f': {
                    buffer.append(Arrays.toString((float[])this.getObject()));
                    break;
                }
                case 'd': {
                    buffer.append(Arrays.toString((double[])this.getObject()));
                }
            }
        } else {
            buffer.append(Arrays.toString((Object[])this.getObject()));
        }
        return buffer.toString();
    }

    @Override
    @JRubyMethod(name={"=="})
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyArray) {
            return RubyBoolean.newBoolean(context, this.equalsRubyArray((RubyArray)other));
        }
        return this.eql_p(context, other);
    }

    private boolean equalsRubyArray(RubyArray rubyArray) {
        Object thisArray = this.getObject();
        int len = rubyArray.size();
        if (len != Array.getLength(thisArray)) {
            return false;
        }
        Class<?> componentType = thisArray.getClass().getComponentType();
        for (int i2 = 0; i2 < len; ++i2) {
            Object ruby = rubyArray.eltInternal(i2).toJava(componentType);
            Object elem = Array.get(thisArray, i2);
            if (ruby == null) {
                return elem == null;
            }
            if (ruby.equals(elem)) continue;
            return false;
        }
        return true;
    }

    @JRubyMethod(name={"eql?"})
    public RubyBoolean eql_p(ThreadContext context, IRubyObject obj) {
        boolean equals = false;
        if (obj instanceof ArrayJavaProxy) {
            ArrayJavaProxy that = (ArrayJavaProxy)obj;
            equals = ArrayJavaProxy.arraysEquals(this.getObject(), that.getObject());
        } else if (obj.getClass().isArray()) {
            equals = ArrayJavaProxy.arraysEquals(this.getObject(), obj);
        }
        return RubyBoolean.newBoolean(context, equals);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ArrayJavaProxy) {
            ArrayJavaProxy that = (ArrayJavaProxy)obj;
            Object thisArray = this.getObject();
            Object thatArray = that.getObject();
            return ArrayJavaProxy.arraysEquals(thisArray, thatArray);
        }
        return false;
    }

    private static boolean arraysEquals(Object thisArray, Object thatArray) {
        Class<?> componentType = thisArray.getClass().getComponentType();
        if (!componentType.equals(thatArray.getClass().getComponentType())) {
            return false;
        }
        if (componentType.isPrimitive()) {
            switch (componentType.getName().charAt(0)) {
                case 'b': {
                    if (componentType == Byte.TYPE) {
                        return Arrays.equals((byte[])thisArray, (byte[])thatArray);
                    }
                    return Arrays.equals((boolean[])thisArray, (boolean[])thatArray);
                }
                case 's': {
                    return Arrays.equals((short[])thisArray, (short[])thatArray);
                }
                case 'c': {
                    return Arrays.equals((char[])thisArray, (char[])thatArray);
                }
                case 'i': {
                    return Arrays.equals((int[])thisArray, (int[])thatArray);
                }
                case 'l': {
                    return Arrays.equals((long[])thisArray, (long[])thatArray);
                }
                case 'f': {
                    return Arrays.equals((float[])thisArray, (float[])thatArray);
                }
                case 'd': {
                    return Arrays.equals((double[])thisArray, (double[])thatArray);
                }
            }
        }
        return Arrays.equals((Object[])thisArray, (Object[])thatArray);
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    public int hashCode() {
        Object array2 = this.getObject();
        Class<?> componentType = array2.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            switch (componentType.getName().charAt(0)) {
                case 'b': {
                    if (componentType == Byte.TYPE) {
                        return 11 * Arrays.hashCode((byte[])array2);
                    }
                    return 11 * Arrays.hashCode((boolean[])array2);
                }
                case 's': {
                    return 11 * Arrays.hashCode((short[])array2);
                }
                case 'c': {
                    return 11 * Arrays.hashCode((char[])array2);
                }
                case 'i': {
                    return 11 * Arrays.hashCode((int[])array2);
                }
                case 'l': {
                    return 11 * Arrays.hashCode((long[])array2);
                }
                case 'f': {
                    return 11 * Arrays.hashCode((float[])array2);
                }
                case 'd': {
                    return 11 * Arrays.hashCode((double[])array2);
                }
            }
        }
        return 11 * Arrays.hashCode((Object[])array2);
    }

    @Override
    public IRubyObject dup() {
        Ruby runtime2 = this.getRuntime();
        ArrayJavaProxy dup2 = new ArrayJavaProxy(runtime2, this.getMetaClass(), this.cloneObject(), this.converter);
        if (this.isTaint()) {
            dup2.setTaint(true);
        }
        ArrayJavaProxy.initCopy(dup2, this, "initialize_dup");
        return dup2;
    }

    private static void initCopy(IRubyObject clone2, IRubyObject original, String method2) {
        original.copySpecialInstanceVariables(clone2);
        if (original.hasVariables()) {
            clone2.syncVariables(original);
        }
    }

    @Override
    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone() {
        Ruby runtime2 = this.getRuntime();
        ArrayJavaProxy clone2 = new ArrayJavaProxy(runtime2, this.getMetaClass(), this.cloneObject(), this.converter);
        clone2.setMetaClass(this.getSingletonClassClone());
        if (this.isTaint()) {
            clone2.setTaint(true);
        }
        ArrayJavaProxy.initCopy(clone2, this, "initialize_clone");
        if (this.isFrozen()) {
            clone2.setFrozen(true);
        }
        return clone2;
    }

    @Override
    protected Object cloneObject() {
        Object array2 = this.getObject();
        Class<?> componentType = array2.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            switch (componentType.getName().charAt(0)) {
                case 'b': {
                    if (componentType == Byte.TYPE) {
                        return ((byte[])array2).clone();
                    }
                    return ((boolean[])array2).clone();
                }
                case 's': {
                    return ((short[])array2).clone();
                }
                case 'c': {
                    return ((char[])array2).clone();
                }
                case 'i': {
                    return ((int[])array2).clone();
                }
                case 'l': {
                    return ((long[])array2).clone();
                }
                case 'f': {
                    return ((float[])array2).clone();
                }
                case 'd': {
                    return ((double[])array2).clone();
                }
            }
        }
        return ((Object[])array2).clone();
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 1) {
            return this.getRange(context, args2[0]);
        }
        if (args2.length == 2) {
            return this.getRange(context, args2[0], args2[1]);
        }
        throw context.runtime.newArgumentError(args2.length, 1);
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject arg0) {
        if (arg0 instanceof RubyRange) {
            return this.arrayRange(context, (RubyRange)arg0);
        }
        throw context.runtime.newTypeError(arg0, context.runtime.getRange());
    }

    private IRubyObject arrayRange(ThreadContext context, RubyRange range) {
        Object array2 = this.getObject();
        int arrayLength = Array.getLength(array2);
        IRubyObject rFirst = range.first(context);
        IRubyObject rLast = range.last(context);
        if (rFirst instanceof RubyFixnum && rLast instanceof RubyFixnum) {
            int first2 = RubyFixnum.fix2int((RubyFixnum)rFirst);
            int last2 = RubyFixnum.fix2int((RubyFixnum)rLast);
            int n = first2 = first2 >= 0 ? first2 : arrayLength + first2;
            if (first2 < 0 || first2 >= arrayLength) {
                return context.nil;
            }
            last2 = last2 >= 0 ? last2 : arrayLength + last2;
            int newLength = last2 - first2;
            if (!range.isExcludeEnd()) {
                ++newLength;
            }
            if (newLength <= 0) {
                return ArrayUtils.emptyJavaArrayDirect(context, array2.getClass().getComponentType());
            }
            return this.subarrayProxy(context, array2, arrayLength, first2, newLength);
        }
        throw context.runtime.newTypeError("only Integer ranges supported");
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject first2, IRubyObject length2) {
        return this.arrayRange(context, first2, length2);
    }

    private IRubyObject arrayRange(ThreadContext context, IRubyObject rFirst, IRubyObject rLength) {
        Object array2 = this.getObject();
        int arrayLength = Array.getLength(array2);
        if (rFirst instanceof RubyFixnum && rLength instanceof RubyFixnum) {
            int first2 = RubyFixnum.fix2int((RubyFixnum)rFirst);
            int length2 = RubyFixnum.fix2int((RubyFixnum)rLength);
            if (length2 > arrayLength) {
                throw context.runtime.newIndexError("length specified is longer than array");
            }
            if (length2 < 0) {
                return context.nil;
            }
            int n = first2 = first2 >= 0 ? first2 : arrayLength + first2;
            if (first2 >= arrayLength) {
                return context.nil;
            }
            return this.subarrayProxy(context, array2, arrayLength, first2, length2);
        }
        throw context.runtime.newTypeError("only Integer ranges supported");
    }

    private IRubyObject subarrayProxy(ThreadContext context, Object ary, int aryLength, int index2, int size2) {
        if (index2 + size2 > aryLength) {
            size2 = aryLength - index2;
        }
        ArrayJavaProxy proxy2 = ArrayUtils.newProxiedArray(context.runtime, ary.getClass().getComponentType(), this.converter, size2);
        System.arraycopy(ary, index2, proxy2.getObject(), 0, size2);
        return proxy2;
    }

    private static final class ArrayNewMethod
    extends JavaMethod.JavaMethodOne {
        private final DynamicMethod newMethod;

        ArrayNewMethod(RubyModule implClass, Visibility visibility) {
            this(implClass, visibility, implClass.searchMethod("new"));
        }

        public ArrayNewMethod(RubyModule implClass, Visibility visibility, DynamicMethod oldNew) {
            super(implClass, visibility, "new");
            this.newMethod = oldNew;
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0) {
            Ruby runtime2 = context.runtime;
            if (!(arg0 instanceof JavaArray)) {
                throw runtime2.newTypeError(arg0, runtime2.getJavaSupport().getJavaArrayClass());
            }
            IRubyObject proxy2 = this.newMethod.call(context, self2, clazz, "new_proxy");
            proxy2.dataWrapStruct(arg0);
            return proxy2;
        }
    }
}

