/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import org.asciidoctor.jruby.ast.impl.ContentNodeImpl;
import org.asciidoctor.jruby.ast.impl.NodeConverter;
import org.jruby.RubyArray;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyBlockListDecorator<T>
extends AbstractList<T> {
    private final RubyArray rubyBlockList;

    public RubyBlockListDecorator(RubyArray rubyBlockList) {
        this.rubyBlockList = rubyBlockList;
    }

    @Override
    public int size() {
        return this.rubyBlockList.size();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof ContentNodeImpl)) {
            return false;
        }
        return this.rubyBlockList.contains((Object)((ContentNodeImpl)o).getRubyObject());
    }

    @Override
    public boolean add(T abstractBlock) {
        return this.rubyBlockList.add((Object)((ContentNodeImpl)abstractBlock).getRubyObject());
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof IRubyObject) {
            return this.rubyBlockList.remove(o);
        }
        if (!(o instanceof ContentNodeImpl)) {
            return false;
        }
        return this.rubyBlockList.remove((Object)((ContentNodeImpl)o).getRubyObject());
    }

    private Collection<Object> getDelegateCollection(Collection<?> c) {
        ArrayList<Object> delegateList = new ArrayList<Object>(c.size());
        for (Object o : c) {
            if (o instanceof ContentNodeImpl) {
                delegateList.add(((ContentNodeImpl)o).getRubyObject());
                continue;
            }
            delegateList.add(o);
        }
        return delegateList;
    }

    @Override
    public void clear() {
        this.rubyBlockList.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof RubyBlockListDecorator) {
            return this.rubyBlockList.equals((Object)((RubyBlockListDecorator)o).rubyBlockList);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.rubyBlockList.hashCode();
    }

    @Override
    public T get(int index) {
        return (T)NodeConverter.createASTNode(this.rubyBlockList.get(index));
    }

    @Override
    public T set(int index, T element) {
        Object oldObject = element instanceof IRubyObject ? this.rubyBlockList.set(index, element) : this.rubyBlockList.set(index, (Object)((ContentNodeImpl)element).getRubyObject());
        return (T)NodeConverter.createASTNode(oldObject);
    }

    @Override
    public void add(int index, T element) {
        if (element instanceof IRubyObject) {
            this.rubyBlockList.set(index, element);
        } else {
            this.rubyBlockList.add(index, (Object)((ContentNodeImpl)element).getRubyObject());
        }
    }

    @Override
    public T remove(int index) {
        Object oldObject = this.rubyBlockList.remove(index);
        if (oldObject == null) {
            return null;
        }
        return (T)NodeConverter.createASTNode(oldObject);
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof IRubyObject) {
            return this.rubyBlockList.indexOf(o);
        }
        if (o instanceof ContentNodeImpl) {
            return this.rubyBlockList.indexOf((Object)((ContentNodeImpl)o).getRubyObject());
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof IRubyObject) {
            return this.rubyBlockList.lastIndexOf(o);
        }
        if (o instanceof ContentNodeImpl) {
            return this.rubyBlockList.lastIndexOf((Object)((ContentNodeImpl)o).getRubyObject());
        }
        return -1;
    }
}

