/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.client.CompletionAwareCacheRequest;
import com.hazelcast.client.impl.client.KeyBasedClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;
import java.security.Permission;

public abstract class AbstractCacheRequest
extends KeyBasedClientRequest
implements RetryableRequest,
CompletionAwareCacheRequest {
    protected String name;
    protected InMemoryFormat inMemoryFormat;

    public AbstractCacheRequest() {
    }

    public AbstractCacheRequest(String name, InMemoryFormat inMemoryFormat) {
        this.name = name;
        this.inMemoryFormat = inMemoryFormat;
    }

    @Override
    public final int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public void setCompletionId(Integer completionId) {
    }

    protected CacheOperationProvider getOperationProvider() {
        ICacheService service = (ICacheService)this.getService();
        return service.getCacheOperationProvider(this.name, this.inMemoryFormat);
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("i", this.inMemoryFormat.name());
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.inMemoryFormat = InMemoryFormat.valueOf(reader.readUTF("i"));
    }
}

