/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache;

import com.hazelcast.map.impl.nearcache.Invalidation;
import com.hazelcast.map.impl.nearcache.SingleNearCacheInvalidation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BatchNearCacheInvalidation
extends Invalidation {
    private List<SingleNearCacheInvalidation> invalidations;

    public BatchNearCacheInvalidation() {
    }

    public BatchNearCacheInvalidation(String mapName, int size) {
        this(mapName, new ArrayList<SingleNearCacheInvalidation>(size));
    }

    public BatchNearCacheInvalidation(String mapName, List<SingleNearCacheInvalidation> invalidations) {
        super(mapName, null);
        this.invalidations = invalidations;
    }

    public void add(SingleNearCacheInvalidation invalidation) {
        this.invalidations.add(invalidation);
    }

    public List<SingleNearCacheInvalidation> getInvalidations() {
        return this.invalidations;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.invalidations.size());
        for (SingleNearCacheInvalidation singleNearCacheInvalidation : this.invalidations) {
            singleNearCacheInvalidation.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        int size = in.readInt();
        if (size != 0) {
            ArrayList<SingleNearCacheInvalidation> invalidations = new ArrayList<SingleNearCacheInvalidation>(size);
            for (int i = 0; i < size; ++i) {
                SingleNearCacheInvalidation invalidation = new SingleNearCacheInvalidation();
                invalidation.readData(in);
                invalidations.add(invalidation);
            }
            this.invalidations = invalidations;
        }
    }
}

