/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.map.impl.record.RecordStatistics;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.util.Clock;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class RecordStatisticsImpl
implements RecordStatistics {
    protected volatile int hits;
    protected long lastStoredTime;
    protected long expirationTime;

    @Override
    public int getHits() {
        return this.hits;
    }

    @Override
    public void setHits(int hits) {
        this.hits = hits;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="We have the guarantee that only the partition thread will call this method")
    public void access() {
        ++this.hits;
    }

    @Override
    public void store() {
        this.lastStoredTime = Clock.currentTimeMillis();
    }

    @Override
    public long getLastStoredTime() {
        return this.lastStoredTime;
    }

    @Override
    public void setLastStoredTime(long lastStoredTime) {
        this.lastStoredTime = lastStoredTime;
    }

    @Override
    public long getMemoryCost() {
        int numberOfLongVariables = 3;
        return 28L;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.hits);
        out.writeLong(this.lastStoredTime);
        out.writeLong(this.expirationTime);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.hits = in.readInt();
        this.lastStoredTime = in.readLong();
        this.expirationTime = in.readLong();
    }
}

