/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.spinning;

import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.ascii.TextReadHandler;
import com.hazelcast.nio.tcp.NewClientReadHandler;
import com.hazelcast.nio.tcp.OldClientReadHandler;
import com.hazelcast.nio.tcp.ReadHandler;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.SocketReader;
import com.hazelcast.nio.tcp.SocketWriter;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.spinning.AbstractHandler;
import com.hazelcast.util.StringUtil;
import com.hazelcast.util.counters.Counter;
import com.hazelcast.util.counters.SwCounter;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;

public class SpinningSocketReader
extends AbstractHandler
implements SocketReader {
    @Probe(name="in.bytesRead")
    private final SwCounter bytesRead = SwCounter.newSwCounter();
    @Probe(name="in.normalFramesRead")
    private final SwCounter normalFramesRead = SwCounter.newSwCounter();
    @Probe(name="in.priorityFramesRead")
    private final SwCounter priorityFramesRead = SwCounter.newSwCounter();
    private final MetricsRegistry metricRegistry;
    private final SocketChannelWrapper socketChannel;
    private volatile long lastReadTime;
    private ReadHandler readHandler;
    private ByteBuffer inputBuffer;
    private ByteBuffer protocolBuffer = ByteBuffer.allocate(3);

    public SpinningSocketReader(TcpIpConnection connection, MetricsRegistry metricsRegistry, ILogger logger) {
        super(connection, logger);
        this.metricRegistry = metricsRegistry;
        this.socketChannel = connection.getSocketChannelWrapper();
        this.metricRegistry.scanAndRegister(this, "tcp.connection[" + connection.getMetricsId() + "]");
    }

    @Override
    public long getLastReadTimeMillis() {
        return this.lastReadTime;
    }

    @Probe(name="in.idleTimeMs")
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastReadTime, 0L);
    }

    @Override
    public Counter getNormalFramesReadCounter() {
        return this.normalFramesRead;
    }

    @Override
    public Counter getPriorityFramesReadCounter() {
        return this.priorityFramesRead;
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
        this.metricRegistry.deregister(this);
    }

    public void read() throws Exception {
        int readBytes;
        if (!this.connection.isAlive()) {
            this.socketChannel.closeInbound();
            return;
        }
        if (this.readHandler == null) {
            this.initializeSocketReader();
            if (this.readHandler == null) {
                return;
            }
        }
        if ((readBytes = this.socketChannel.read(this.inputBuffer)) <= 0) {
            if (readBytes == -1) {
                throw new EOFException("Remote socket closed!");
            }
            return;
        }
        this.lastReadTime = System.currentTimeMillis();
        this.bytesRead.inc(readBytes);
        this.inputBuffer.flip();
        this.readHandler.onRead(this.inputBuffer);
        if (this.inputBuffer.hasRemaining()) {
            this.inputBuffer.compact();
        } else {
            this.inputBuffer.clear();
        }
    }

    private void initializeSocketReader() throws IOException {
        if (this.readHandler != null) {
            return;
        }
        int readBytes = this.socketChannel.read(this.protocolBuffer);
        if (readBytes == -1) {
            throw new EOFException("Could not read protocol type!");
        }
        if (readBytes == 0 && this.connectionManager.isSSLEnabled()) {
            return;
        }
        if (this.protocolBuffer.hasRemaining()) {
            return;
        }
        String protocol = StringUtil.bytesToString(this.protocolBuffer.array());
        SocketWriter socketWriter = this.connection.getSocketWriter();
        if ("HZC".equals(protocol)) {
            this.configureBuffers(this.ioService.getSocketReceiveBufferSize() * 1024);
            this.connection.setType(ConnectionType.MEMBER);
            socketWriter.setProtocol("HZC");
            this.readHandler = this.ioService.createReadHandler(this.connection);
        } else if ("CB1".equals(protocol)) {
            this.configureBuffers(this.ioService.getSocketClientReceiveBufferSize() * 1024);
            socketWriter.setProtocol("CB1");
            this.readHandler = new OldClientReadHandler(this.connection, this.ioService);
        } else if ("CB2".equals(protocol)) {
            this.configureBuffers(this.ioService.getSocketClientReceiveBufferSize() * 1024);
            socketWriter.setProtocol("CB2");
            this.readHandler = new NewClientReadHandler(this.connection, this.ioService);
        } else {
            this.configureBuffers(this.ioService.getSocketReceiveBufferSize() * 1024);
            socketWriter.setProtocol("TXT");
            this.inputBuffer.put(this.protocolBuffer.array());
            this.readHandler = new TextReadHandler(this.connection);
            this.connection.getConnectionManager().incrementTextConnections();
        }
    }

    private void configureBuffers(int size) {
        this.inputBuffer = ByteBuffer.allocate(size);
        try {
            this.connection.setReceiveBufferSize(size);
        }
        catch (SocketException e) {
            this.logger.finest("Failed to adjust TCP receive buffer of " + this.connection + " to " + size + " B.", e);
        }
    }
}

