/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Compressor;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.inprocess.InProcessServer;
import io.grpc.inprocess.InProcessSocketAddress;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.LogId;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.NoopClientStream;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.StreamListener;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class InProcessTransport
implements ServerTransport,
ConnectionClientTransport {
    private static final Logger log = Logger.getLogger(InProcessTransport.class.getName());
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private final String name;
    private final String authority;
    private ObjectPool<ScheduledExecutorService> serverSchedulerPool;
    private ScheduledExecutorService serverScheduler;
    private ServerTransportListener serverTransportListener;
    private Attributes serverStreamAttributes;
    private ManagedClientTransport.Listener clientTransportListener;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private boolean terminated;
    @GuardedBy(value="this")
    private Status shutdownStatus;
    @GuardedBy(value="this")
    private Set<InProcessStream> streams = new HashSet<InProcessStream>();

    public InProcessTransport(String name, String authority) {
        this.name = name;
        this.authority = authority;
    }

    @Override
    @CheckReturnValue
    public synchronized Runnable start(ManagedClientTransport.Listener listener) {
        this.clientTransportListener = listener;
        InProcessServer server = InProcessServer.findServer(this.name);
        if (server != null) {
            this.serverSchedulerPool = server.getScheduledExecutorServicePool();
            this.serverScheduler = this.serverSchedulerPool.getObject();
            this.serverTransportListener = server.register(this);
        }
        if (this.serverTransportListener == null) {
            final Status localShutdownStatus = this.shutdownStatus = Status.UNAVAILABLE.withDescription("Could not find server: " + this.name);
            return new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InProcessTransport inProcessTransport = InProcessTransport.this;
                    synchronized (inProcessTransport) {
                        InProcessTransport.this.notifyShutdown(localShutdownStatus);
                        InProcessTransport.this.notifyTerminated();
                    }
                }
            };
        }
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InProcessTransport inProcessTransport = InProcessTransport.this;
                synchronized (inProcessTransport) {
                    Attributes serverTransportAttrs = Attributes.newBuilder().set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, new InProcessSocketAddress(InProcessTransport.this.name)).build();
                    InProcessTransport.this.serverStreamAttributes = InProcessTransport.this.serverTransportListener.transportReady(serverTransportAttrs);
                    InProcessTransport.this.clientTransportListener.transportReady();
                }
            }
        };
    }

    @Override
    public synchronized ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions) {
        if (this.shutdownStatus != null) {
            final Status capturedStatus = this.shutdownStatus;
            return new NoopClientStream(){

                @Override
                public void start(ClientStreamListener listener) {
                    listener.closed(capturedStatus, new Metadata());
                }
            };
        }
        return new InProcessStream(method, headers, this.authority).clientStream;
    }

    @Override
    public synchronized void ping(final ClientTransport.PingCallback callback, Executor executor) {
        if (this.terminated) {
            final Status shutdownStatus = this.shutdownStatus;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(shutdownStatus.asRuntimeException());
                }
            });
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess(0L);
                }
            });
        }
    }

    @Override
    public synchronized void shutdown(Status reason) {
        if (this.shutdown) {
            return;
        }
        this.shutdownStatus = reason;
        this.notifyShutdown(reason);
        if (this.streams.isEmpty()) {
            this.notifyTerminated();
        }
    }

    @Override
    public synchronized void shutdown() {
        this.shutdown(Status.UNAVAILABLE.withDescription("InProcessTransport shutdown by the server-side"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNow(Status reason) {
        ArrayList<InProcessStream> streamsCopy;
        Preconditions.checkNotNull((Object)reason, (Object)"reason");
        InProcessTransport inProcessTransport = this;
        synchronized (inProcessTransport) {
            this.shutdown(reason);
            if (this.terminated) {
                return;
            }
            streamsCopy = new ArrayList<InProcessStream>(this.streams);
        }
        for (InProcessStream stream : streamsCopy) {
            stream.clientStream.cancel(reason);
        }
    }

    public String toString() {
        return this.getLogId() + "(" + this.name + ")";
    }

    @Override
    public LogId getLogId() {
        return this.logId;
    }

    @Override
    public Attributes getAttributes() {
        return Attributes.EMPTY;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.serverScheduler;
    }

    private synchronized void notifyShutdown(Status s) {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.clientTransportListener.transportShutdown(s);
    }

    private synchronized void notifyTerminated() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        if (this.serverScheduler != null) {
            this.serverScheduler = this.serverSchedulerPool.returnObject(this.serverScheduler);
        }
        this.clientTransportListener.transportTerminated();
        if (this.serverTransportListener != null) {
            this.serverTransportListener.transportTerminated();
        }
    }

    private static Status stripCause(Status status) {
        if (status == null) {
            return null;
        }
        return Status.fromCodeValue(status.getCode().value()).withDescription(status.getDescription());
    }

    private static class SingleMessageProducer
    implements StreamListener.MessageProducer {
        private InputStream message;

        private SingleMessageProducer(InputStream message) {
            this.message = message;
        }

        @Override
        @Nullable
        public InputStream next() {
            InputStream messageToReturn = this.message;
            this.message = null;
            return messageToReturn;
        }
    }

    private class InProcessStream {
        private final InProcessServerStream serverStream = new InProcessServerStream();
        private final InProcessClientStream clientStream = new InProcessClientStream();
        private final Metadata headers;
        private final MethodDescriptor<?, ?> method;
        private volatile String authority;

        private InProcessStream(MethodDescriptor<?, ?> method, Metadata headers, String authority) {
            this.method = (MethodDescriptor)Preconditions.checkNotNull(method, (Object)"method");
            this.headers = (Metadata)Preconditions.checkNotNull((Object)headers, (Object)"headers");
            this.authority = authority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void streamClosed() {
            InProcessTransport inProcessTransport = InProcessTransport.this;
            synchronized (inProcessTransport) {
                boolean justRemovedAnElement = InProcessTransport.this.streams.remove(this);
                if (InProcessTransport.this.streams.isEmpty() && justRemovedAnElement) {
                    InProcessTransport.this.clientTransportListener.transportInUse(false);
                    if (InProcessTransport.this.shutdown) {
                        InProcessTransport.this.notifyTerminated();
                    }
                }
            }
        }

        private class InProcessClientStream
        implements ClientStream {
            @GuardedBy(value="this")
            private ServerStreamListener serverStreamListener;
            @GuardedBy(value="this")
            private int serverRequested;
            @GuardedBy(value="this")
            private ArrayDeque<StreamListener.MessageProducer> serverReceiveQueue = new ArrayDeque();
            @GuardedBy(value="this")
            private boolean serverNotifyHalfClose;
            @GuardedBy(value="this")
            private boolean closed;

            private InProcessClientStream() {
            }

            private synchronized void setListener(ServerStreamListener listener) {
                this.serverStreamListener = listener;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void request(int numMessages) {
                boolean onReady = InProcessStream.this.serverStream.clientRequested(numMessages);
                if (onReady) {
                    InProcessClientStream inProcessClientStream = this;
                    synchronized (inProcessClientStream) {
                        if (!this.closed) {
                            this.serverStreamListener.onReady();
                        }
                    }
                }
            }

            private synchronized boolean serverRequested(int numMessages) {
                if (this.closed) {
                    return false;
                }
                boolean previouslyReady = this.serverRequested > 0;
                this.serverRequested += numMessages;
                while (this.serverRequested > 0 && !this.serverReceiveQueue.isEmpty()) {
                    --this.serverRequested;
                    this.serverStreamListener.messagesAvailable(this.serverReceiveQueue.poll());
                }
                if (this.serverReceiveQueue.isEmpty() && this.serverNotifyHalfClose) {
                    this.serverNotifyHalfClose = false;
                    this.serverStreamListener.halfClosed();
                }
                boolean nowReady = this.serverRequested > 0;
                return !previouslyReady && nowReady;
            }

            private void serverClosed(Status status) {
                this.internalCancel(status);
            }

            @Override
            public synchronized void writeMessage(InputStream message) {
                if (this.closed) {
                    return;
                }
                SingleMessageProducer producer = new SingleMessageProducer(message);
                if (this.serverRequested > 0) {
                    --this.serverRequested;
                    this.serverStreamListener.messagesAvailable(producer);
                } else {
                    this.serverReceiveQueue.add(producer);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public synchronized boolean isReady() {
                if (this.closed) {
                    return false;
                }
                return this.serverRequested > 0;
            }

            @Override
            public void cancel(Status reason) {
                if (!this.internalCancel(InProcessTransport.stripCause(reason))) {
                    return;
                }
                InProcessStream.this.serverStream.clientCancelled(reason);
                InProcessStream.this.streamClosed();
            }

            private synchronized boolean internalCancel(Status reason) {
                StreamListener.MessageProducer producer;
                if (this.closed) {
                    return false;
                }
                this.closed = true;
                while ((producer = this.serverReceiveQueue.poll()) != null) {
                    InputStream message;
                    while ((message = producer.next()) != null) {
                        try {
                            message.close();
                        }
                        catch (Throwable t) {
                            log.log(Level.WARNING, "Exception closing stream", t);
                        }
                    }
                }
                this.serverStreamListener.closed(reason);
                return true;
            }

            @Override
            public synchronized void halfClose() {
                if (this.closed) {
                    return;
                }
                if (this.serverReceiveQueue.isEmpty()) {
                    this.serverStreamListener.halfClosed();
                } else {
                    this.serverNotifyHalfClose = true;
                }
            }

            @Override
            public void setMessageCompression(boolean enable) {
            }

            @Override
            public void setAuthority(String string) {
                InProcessStream.this.authority = string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void start(ClientStreamListener listener) {
                InProcessStream.this.serverStream.setListener(listener);
                InProcessTransport inProcessTransport = InProcessTransport.this;
                synchronized (inProcessTransport) {
                    InProcessTransport.this.streams.add(InProcessStream.this);
                    if (InProcessTransport.this.streams.size() == 1) {
                        InProcessTransport.this.clientTransportListener.transportInUse(true);
                    }
                    InProcessTransport.this.serverTransportListener.streamCreated(InProcessStream.this.serverStream, InProcessStream.this.method.getFullMethodName(), InProcessStream.this.headers);
                }
            }

            @Override
            public Attributes getAttributes() {
                return Attributes.EMPTY;
            }

            @Override
            public void setCompressor(Compressor compressor) {
            }

            @Override
            public void setFullStreamDecompression(boolean fullStreamDecompression) {
            }

            @Override
            public void setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
            }

            @Override
            public void setMaxInboundMessageSize(int maxSize) {
            }

            @Override
            public void setMaxOutboundMessageSize(int maxSize) {
            }
        }

        private class InProcessServerStream
        implements ServerStream {
            @GuardedBy(value="this")
            private ClientStreamListener clientStreamListener;
            @GuardedBy(value="this")
            private int clientRequested;
            @GuardedBy(value="this")
            private ArrayDeque<StreamListener.MessageProducer> clientReceiveQueue = new ArrayDeque();
            @GuardedBy(value="this")
            private Status clientNotifyStatus;
            @GuardedBy(value="this")
            private Metadata clientNotifyTrailers;
            @GuardedBy(value="this")
            private boolean closed;

            private InProcessServerStream() {
            }

            private synchronized void setListener(ClientStreamListener listener) {
                this.clientStreamListener = listener;
            }

            @Override
            public void setListener(ServerStreamListener serverStreamListener) {
                InProcessStream.this.clientStream.setListener(serverStreamListener);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void request(int numMessages) {
                boolean onReady = InProcessStream.this.clientStream.serverRequested(numMessages);
                if (onReady) {
                    InProcessServerStream inProcessServerStream = this;
                    synchronized (inProcessServerStream) {
                        if (!this.closed) {
                            this.clientStreamListener.onReady();
                        }
                    }
                }
            }

            private synchronized boolean clientRequested(int numMessages) {
                if (this.closed) {
                    return false;
                }
                boolean previouslyReady = this.clientRequested > 0;
                this.clientRequested += numMessages;
                while (this.clientRequested > 0 && !this.clientReceiveQueue.isEmpty()) {
                    --this.clientRequested;
                    this.clientStreamListener.messagesAvailable(this.clientReceiveQueue.poll());
                }
                if (this.closed) {
                    return false;
                }
                if (this.clientReceiveQueue.isEmpty() && this.clientNotifyStatus != null) {
                    this.closed = true;
                    this.clientStreamListener.closed(this.clientNotifyStatus, this.clientNotifyTrailers);
                }
                boolean nowReady = this.clientRequested > 0;
                return !previouslyReady && nowReady;
            }

            private void clientCancelled(Status status) {
                this.internalCancel(status);
            }

            @Override
            public synchronized void writeMessage(InputStream message) {
                if (this.closed) {
                    return;
                }
                SingleMessageProducer producer = new SingleMessageProducer(message);
                if (this.clientRequested > 0) {
                    --this.clientRequested;
                    this.clientStreamListener.messagesAvailable(producer);
                } else {
                    this.clientReceiveQueue.add(producer);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public synchronized boolean isReady() {
                if (this.closed) {
                    return false;
                }
                return this.clientRequested > 0;
            }

            @Override
            public synchronized void writeHeaders(Metadata headers) {
                if (this.closed) {
                    return;
                }
                this.clientStreamListener.headersRead(headers);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close(Status status, Metadata trailers) {
                status = InProcessTransport.stripCause(status);
                InProcessServerStream inProcessServerStream = this;
                synchronized (inProcessServerStream) {
                    if (this.closed) {
                        return;
                    }
                    if (this.clientReceiveQueue.isEmpty()) {
                        this.closed = true;
                        this.clientStreamListener.closed(status, trailers);
                    } else {
                        this.clientNotifyStatus = status;
                        this.clientNotifyTrailers = trailers;
                    }
                }
                InProcessStream.this.clientStream.serverClosed(Status.OK);
                InProcessStream.this.streamClosed();
            }

            @Override
            public void cancel(Status status) {
                if (!this.internalCancel(Status.CANCELLED.withDescription("server cancelled stream"))) {
                    return;
                }
                InProcessStream.this.clientStream.serverClosed(status);
                InProcessStream.this.streamClosed();
            }

            private synchronized boolean internalCancel(Status status) {
                StreamListener.MessageProducer producer;
                if (this.closed) {
                    return false;
                }
                this.closed = true;
                while ((producer = this.clientReceiveQueue.poll()) != null) {
                    InputStream message;
                    while ((message = producer.next()) != null) {
                        try {
                            message.close();
                        }
                        catch (Throwable t) {
                            log.log(Level.WARNING, "Exception closing stream", t);
                        }
                    }
                }
                this.clientStreamListener.closed(status, new Metadata());
                return true;
            }

            @Override
            public void setMessageCompression(boolean enable) {
            }

            @Override
            public void setCompressor(Compressor compressor) {
            }

            @Override
            public void setDecompressor(Decompressor decompressor) {
            }

            @Override
            public Attributes getAttributes() {
                return InProcessTransport.this.serverStreamAttributes;
            }

            @Override
            public String getAuthority() {
                return InProcessStream.this.authority;
            }

            @Override
            public StatsTraceContext statsTraceContext() {
                return StatsTraceContext.NOOP;
            }
        }
    }
}

