/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.field;

import java.lang.reflect.Field;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

public interface FieldDescription
extends ByteCodeElement,
NamedElement.WithGenericName,
ByteCodeElement.TypeDependant<InDefinedShape, Token> {
    public static final Object NO_DEFAULT_VALUE = null;

    public GenericTypeDescription getType();

    public static class Token
    implements ByteCodeElement.Token<Token> {
        private final String name;
        private final int modifiers;
        private final GenericTypeDescription type;
        private final List<? extends AnnotationDescription> annotations;

        public Token(String name, int modifiers, GenericTypeDescription type) {
            this(name, modifiers, type, Collections.emptyList());
        }

        public Token(String name, int modifiers, GenericTypeDescription type, List<? extends AnnotationDescription> annotations) {
            this.name = name;
            this.modifiers = modifiers;
            this.type = type;
            this.annotations = annotations;
        }

        public String getName() {
            return this.name;
        }

        public GenericTypeDescription getType() {
            return this.type;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public AnnotationList getAnnotations() {
            return new AnnotationList.Explicit(this.annotations);
        }

        @Override
        public Token accept(GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor) {
            return new Token(this.getName(), this.getModifiers(), this.getType().accept(visitor), this.getAnnotations());
        }

        @Override
        public boolean isIdenticalTo(Token token) {
            return this.getName().equals(token.getName()) && this.getModifiers() == token.getModifiers() && this.getType().equals(token.getType()) && this.getAnnotations().equals(token.getAnnotations());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            return this.getName().equals(token.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            return "FieldDescription.Token{name='" + this.name + '\'' + ", modifiers=" + this.modifiers + ", type=" + this.type + ", annotations=" + this.annotations + '}';
        }
    }

    public static class TypeSubstituting
    extends AbstractBase {
        private final GenericTypeDescription declaringType;
        private final FieldDescription fieldDescription;
        private final GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor;

        public TypeSubstituting(GenericTypeDescription declaringType, FieldDescription fieldDescription, GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor) {
            this.declaringType = declaringType;
            this.fieldDescription = fieldDescription;
            this.visitor = visitor;
        }

        @Override
        public GenericTypeDescription getType() {
            return this.fieldDescription.getType().accept(this.visitor);
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.fieldDescription.getDeclaredAnnotations();
        }

        @Override
        public GenericTypeDescription getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public int getModifiers() {
            return this.fieldDescription.getModifiers();
        }

        @Override
        public String getName() {
            return this.fieldDescription.getName();
        }

        @Override
        public InDefinedShape asDefined() {
            return (InDefinedShape)this.fieldDescription.asDefined();
        }
    }

    public static class Latent
    extends InDefinedShape.AbstractBase {
        private final TypeDescription declaringType;
        private final String fieldName;
        private final int modifiers;
        private final GenericTypeDescription fieldType;
        private final List<? extends AnnotationDescription> declaredAnnotations;

        public Latent(TypeDescription declaringType, Token token) {
            this(declaringType, token.getName(), token.getModifiers(), token.getType(), token.getAnnotations());
        }

        public Latent(TypeDescription declaringType, String fieldName, int modifiers, GenericTypeDescription fieldType, List<? extends AnnotationDescription> declaredAnnotations) {
            this.declaringType = declaringType;
            this.fieldName = fieldName;
            this.modifiers = modifiers;
            this.fieldType = fieldType;
            this.declaredAnnotations = declaredAnnotations;
        }

        @Override
        public GenericTypeDescription getType() {
            return this.fieldType.accept(GenericTypeDescription.Visitor.Substitutor.ForAttachment.of(this));
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.declaredAnnotations);
        }

        @Override
        public String getName() {
            return this.fieldName;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }
    }

    public static class ForLoadedField
    extends InDefinedShape.AbstractBase {
        private final Field field;

        public ForLoadedField(Field field) {
            this.field = field;
        }

        @Override
        public GenericTypeDescription getType() {
            return new GenericTypeDescription.LazyProjection.OfLoadedFieldType(this.field);
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotation(this.field.getDeclaredAnnotations());
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public TypeDescription getDeclaringType() {
            return new TypeDescription.ForLoadedType(this.field.getDeclaringClass());
        }

        @Override
        public int getModifiers() {
            return this.field.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.field.isSynthetic();
        }
    }

    public static abstract class AbstractBase
    extends ModifierReviewable.AbstractBase
    implements FieldDescription {
        @Override
        public String getInternalName() {
            return this.getName();
        }

        @Override
        public String getSourceCodeName() {
            return this.getName();
        }

        @Override
        public String getDescriptor() {
            return this.getType().asErasure().getDescriptor();
        }

        @Override
        public String getGenericSignature() {
            GenericTypeDescription fieldType = this.getType();
            try {
                return fieldType.getSort().isNonGeneric() ? NON_GENERIC_SIGNATURE : fieldType.accept(new GenericTypeDescription.Visitor.ForSignatureVisitor((SignatureVisitor)new SignatureWriter())).toString();
            }
            catch (GenericSignatureFormatError ignored) {
                return NON_GENERIC_SIGNATURE;
            }
        }

        @Override
        public boolean isVisibleTo(TypeDescription typeDescription) {
            return this.getDeclaringType().asErasure().isVisibleTo(typeDescription) && (this.isPublic() || typeDescription.equals(this.getDeclaringType()) || this.isProtected() && this.getDeclaringType().asErasure().isAssignableFrom(typeDescription) || !this.isPrivate() && typeDescription.isSamePackage(this.getDeclaringType().asErasure()));
        }

        @Override
        public Token asToken() {
            return this.asToken((ElementMatcher)ElementMatchers.none());
        }

        @Override
        public Token asToken(ElementMatcher<? super GenericTypeDescription> targetTypeMatcher) {
            return new Token(this.getName(), this.getModifiers(), this.getType().accept(new GenericTypeDescription.Visitor.Substitutor.ForDetachment(targetTypeMatcher)), this.getDeclaredAnnotations());
        }

        public boolean equals(Object other) {
            return other == this || other instanceof FieldDescription && this.getName().equals(((FieldDescription)other).getName()) && this.getDeclaringType().equals(((FieldDescription)other).getDeclaringType());
        }

        public int hashCode() {
            return this.getDeclaringType().hashCode() + 31 * this.getName().hashCode();
        }

        @Override
        public String toGenericString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getModifiers() != 0) {
                stringBuilder.append(Modifier.toString(this.getModifiers())).append(" ");
            }
            stringBuilder.append(this.getType().getSourceCodeName()).append(" ");
            stringBuilder.append(this.getDeclaringType().asErasure().getSourceCodeName()).append(".");
            return stringBuilder.append(this.getName()).toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getModifiers() != 0) {
                stringBuilder.append(Modifier.toString(this.getModifiers())).append(" ");
            }
            stringBuilder.append(this.getType().asErasure().getSourceCodeName()).append(" ");
            stringBuilder.append(this.getDeclaringType().asErasure().getSourceCodeName()).append(".");
            return stringBuilder.append(this.getName()).toString();
        }
    }

    public static interface InDefinedShape
    extends FieldDescription,
    ByteCodeElement.Accessible {
        @Override
        public TypeDescription getDeclaringType();

        public static abstract class AbstractBase
        extends net.bytebuddy.description.field.FieldDescription$AbstractBase
        implements InDefinedShape {
            @Override
            public InDefinedShape asDefined() {
                return this;
            }

            @Override
            public boolean isAccessibleTo(TypeDescription typeDescription) {
                return this.isVisibleTo(typeDescription) && this.getDeclaringType().isVisibleTo(typeDescription);
            }
        }
    }
}

