/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.TypeWriter;
import net.bytebuddy.implementation.attribute.FieldAttributeAppender;

public interface FieldRegistry {
    public FieldRegistry include(FieldDescription.Token var1, FieldAttributeAppender.Factory var2, Object var3);

    public Compiled compile(TypeDescription var1);

    public static class Default
    implements FieldRegistry {
        private final Map<FieldDescription.Token, Entry> entries;

        public Default() {
            this.entries = Collections.emptyMap();
        }

        private Default(Map<FieldDescription.Token, Entry> entries) {
            this.entries = entries;
        }

        @Override
        public FieldRegistry include(FieldDescription.Token fieldToken, FieldAttributeAppender.Factory attributeAppenderFactory, Object defaultValue) {
            HashMap<FieldDescription.Token, Entry> entries = new HashMap<FieldDescription.Token, Entry>(this.entries);
            if (entries.put(fieldToken, new Entry(attributeAppenderFactory, defaultValue)) != null) {
                throw new IllegalArgumentException(fieldToken + " is already registered");
            }
            return new Default(entries);
        }

        @Override
        public net.bytebuddy.dynamic.scaffold.FieldRegistry$Compiled compile(TypeDescription instrumentedType) {
            HashMap<FieldDescription.Token, Compiled.Entry> entries = new HashMap<FieldDescription.Token, Compiled.Entry>(this.entries.size());
            HashMap<FieldAttributeAppender.Factory, FieldAttributeAppender> attributeAppenders = new HashMap<FieldAttributeAppender.Factory, FieldAttributeAppender>(this.entries.size());
            for (Map.Entry<FieldDescription.Token, Entry> entry : this.entries.entrySet()) {
                FieldAttributeAppender attributeAppender = (FieldAttributeAppender)attributeAppenders.get(entry.getValue().getAttributeAppenderFactory());
                if (attributeAppender == null) {
                    attributeAppender = entry.getValue().getAttributeAppenderFactory().make(instrumentedType);
                    attributeAppenders.put(entry.getValue().getAttributeAppenderFactory(), attributeAppender);
                }
                entries.put(entry.getKey(), new Compiled.Entry(attributeAppender, entry.getValue().getDefaultValue()));
            }
            return new Compiled(entries);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Default)other).entries);
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public String toString() {
            return "FieldRegistry.Default{entries=" + this.entries + '}';
        }

        protected static class Compiled
        implements net.bytebuddy.dynamic.scaffold.FieldRegistry$Compiled {
            private final Map<FieldDescription.Token, Entry> entries;

            public Compiled(Map<FieldDescription.Token, Entry> entries) {
                this.entries = entries;
            }

            @Override
            public TypeWriter.FieldPool.Record target(FieldDescription fieldDescription) {
                Entry entry = this.entries.get(fieldDescription.asToken());
                return entry == null ? new TypeWriter.FieldPool.Record.ForSimpleField(fieldDescription) : entry.bind(fieldDescription);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Compiled)other).entries);
            }

            public int hashCode() {
                return 31 * this.entries.hashCode();
            }

            public String toString() {
                return "FieldRegistry.Default.Compiled{entries=" + this.entries + '}';
            }

            protected static class Entry {
                private final FieldAttributeAppender attributeAppender;
                private final Object defaultValue;

                protected Entry(FieldAttributeAppender attributeAppender, Object defaultValue) {
                    this.attributeAppender = attributeAppender;
                    this.defaultValue = defaultValue;
                }

                protected TypeWriter.FieldPool.Record bind(FieldDescription fieldDescription) {
                    return new TypeWriter.FieldPool.Record.ForRichField(this.attributeAppender, this.defaultValue, fieldDescription);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Entry entry = (Entry)other;
                    return this.attributeAppender.equals(entry.attributeAppender) && !(this.defaultValue == null ? entry.defaultValue != null : !this.defaultValue.equals(entry.defaultValue));
                }

                public int hashCode() {
                    int result = this.attributeAppender.hashCode();
                    result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                    return result;
                }

                public String toString() {
                    return "FieldRegistry.Default.Compiled.Entry{attributeAppender=" + this.attributeAppender + ", defaultValue=" + this.defaultValue + '}';
                }
            }
        }

        protected static class Entry {
            private final FieldAttributeAppender.Factory attributeAppenderFactory;
            private final Object defaultValue;

            protected Entry(FieldAttributeAppender.Factory attributeAppenderFactory, Object defaultValue) {
                this.attributeAppenderFactory = attributeAppenderFactory;
                this.defaultValue = defaultValue;
            }

            public FieldAttributeAppender.Factory getAttributeAppenderFactory() {
                return this.attributeAppenderFactory;
            }

            public Object getDefaultValue() {
                return this.defaultValue;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Entry entry = (Entry)other;
                return this.attributeAppenderFactory.equals(entry.attributeAppenderFactory) && !(this.defaultValue == null ? entry.defaultValue != null : !this.defaultValue.equals(entry.defaultValue));
            }

            public int hashCode() {
                int result = this.attributeAppenderFactory.hashCode();
                result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                return result;
            }

            public String toString() {
                return "FieldRegistry.Default.Entry{attributeAppenderFactory=" + this.attributeAppenderFactory + ", defaultValue=" + this.defaultValue + '}';
            }
        }
    }

    public static interface Compiled
    extends TypeWriter.FieldPool {

        public static enum NoOp implements Compiled
        {
            INSTANCE;


            @Override
            public TypeWriter.FieldPool.Record target(FieldDescription fieldDescription) {
                return new TypeWriter.FieldPool.Record.ForSimpleField(fieldDescription);
            }

            public String toString() {
                return "FieldRegistry.Compiled.NoOp." + this.name();
            }
        }
    }
}

