/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.subclass;

import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatchers;

public class SubclassImplementationTarget
extends Implementation.Target.AbstractBase {
    protected final Map<MethodDescription.Token, MethodDescription> superConstructors;
    protected final OriginTypeResolver originTypeResolver;

    protected SubclassImplementationTarget(TypeDescription instrumentedType, MethodGraph.Linked methodGraph, OriginTypeResolver originTypeResolver) {
        super(instrumentedType, methodGraph);
        GenericTypeDescription superType = instrumentedType.getSuperType();
        MethodList.Empty superConstructors = superType == null ? new MethodList.Empty() : (MethodList)superType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.isVisibleTo(instrumentedType)));
        this.superConstructors = new HashMap<MethodDescription.Token, MethodDescription>(superConstructors.size());
        for (MethodDescription superConstructor : superConstructors) {
            this.superConstructors.put((MethodDescription.Token)superConstructor.asToken(), superConstructor);
        }
        this.originTypeResolver = originTypeResolver;
    }

    @Override
    public Implementation.SpecialMethodInvocation invokeSuper(MethodDescription.Token methodToken) {
        return methodToken.getInternalName().equals("<init>") ? this.invokeConstructor(methodToken) : this.invokeMethod(methodToken);
    }

    private Implementation.SpecialMethodInvocation invokeConstructor(MethodDescription.Token methodToken) {
        MethodDescription methodDescription = this.superConstructors.get(methodToken);
        return methodDescription == null ? Implementation.SpecialMethodInvocation.Illegal.INSTANCE : Implementation.SpecialMethodInvocation.Simple.of(methodDescription, this.instrumentedType.getSuperType().asErasure());
    }

    private Implementation.SpecialMethodInvocation invokeMethod(MethodDescription.Token methodToken) {
        MethodGraph.Node methodNode = this.methodGraph.getSuperGraph().locate(methodToken);
        return methodNode.getSort().isUnique() ? Implementation.SpecialMethodInvocation.Simple.of(methodNode.getRepresentative(), this.instrumentedType.getSuperType().asErasure()) : Implementation.SpecialMethodInvocation.Illegal.INSTANCE;
    }

    @Override
    public TypeDescription getOriginType() {
        return this.originTypeResolver.identify(this.instrumentedType);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.superConstructors.equals(((SubclassImplementationTarget)other).superConstructors) && this.originTypeResolver == ((SubclassImplementationTarget)other).originTypeResolver;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.superConstructors.hashCode();
        result = 31 * result + this.originTypeResolver.hashCode();
        return result;
    }

    public String toString() {
        return "SubclassImplementationTarget{superConstructors=" + this.superConstructors + ", originTypeResolver=" + (Object)((Object)this.originTypeResolver) + ", instrumentedType=" + this.instrumentedType + ", methodGraph=" + this.methodGraph + '}';
    }

    public static class Factory
    implements Implementation.Target.Factory {
        private final OriginTypeResolver originTypeResolver;

        public Factory(OriginTypeResolver originTypeResolver) {
            this.originTypeResolver = originTypeResolver;
        }

        @Override
        public Implementation.Target make(TypeDescription instrumentedType, MethodGraph.Linked methodGraph) {
            return new SubclassImplementationTarget(instrumentedType, methodGraph, this.originTypeResolver);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.originTypeResolver == ((Factory)other).originTypeResolver;
        }

        public int hashCode() {
            return this.originTypeResolver.hashCode();
        }

        public String toString() {
            return "SubclassImplementationTarget.Factory{originTypeResolver=" + (Object)((Object)this.originTypeResolver) + '}';
        }
    }

    public static enum OriginTypeResolver {
        SUPER_TYPE{

            @Override
            protected TypeDescription identify(TypeDescription typeDescription) {
                return typeDescription.getSuperType().asErasure();
            }
        }
        ,
        LEVEL_TYPE{

            @Override
            protected TypeDescription identify(TypeDescription typeDescription) {
                return typeDescription;
            }
        };


        protected abstract TypeDescription identify(TypeDescription var1);

        public String toString() {
            return "SubclassImplementationTarget.OriginTypeResolver." + this.name();
        }
    }
}

