/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.AbstractFailureStrategy;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.StringUtil;
import org.junit.internal.AssumptionViolatedException;

@GwtIncompatible(value="JUnit4")
public final class TruthJUnit {
    private static final FailureStrategy THROW_ASSUMPTION_ERROR = new AbstractFailureStrategy(){

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual, Throwable cause) {
            this.fail(StringUtil.messageFor(message, expected, actual), cause);
        }

        @Override
        public void fail(String message, Throwable cause) {
            throw new ThrowableAssumptionViolatedException(message, cause);
        }
    };
    private static final StandardSubjectBuilder ASSUME = StandardSubjectBuilder.forCustomFailureStrategy(THROW_ASSUMPTION_ERROR);

    @Deprecated
    public static final FailureStrategy throwAssumptionError() {
        return THROW_ASSUMPTION_ERROR;
    }

    public static final StandardSubjectBuilder assume() {
        return ASSUME;
    }

    private TruthJUnit() {
    }

    private static class ThrowableAssumptionViolatedException
    extends AssumptionViolatedException {
        public ThrowableAssumptionViolatedException(String message, Throwable throwable) {
            super(message);
            if (throwable != null) {
                this.initCause(throwable);
            }
        }
    }
}

