/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

public enum ResourceType {
    ANIM("anim", "Animation", new String[0]),
    ANIMATOR("animator", "Animator", new String[0]),
    ARRAY("array", "Array", "string-array", "integer-array"),
    ATTR("attr", "Attr", new String[0]),
    BOOL("bool", "Boolean", new String[0]),
    COLOR("color", "Color", new String[0]),
    DECLARE_STYLEABLE("declare-styleable", "Declare Styleable", new String[0]),
    DIMEN("dimen", "Dimension", new String[0]),
    DRAWABLE("drawable", "Drawable", new String[0]),
    FRACTION("fraction", "Fraction", new String[0]),
    ID("id", "ID", new String[0]),
    INTEGER("integer", "Integer", new String[0]),
    INTERPOLATOR("interpolator", "Interpolator", new String[0]),
    LAYOUT("layout", "Layout", new String[0]),
    MENU("menu", "Menu", new String[0]),
    MIPMAP("mipmap", "Mip Map", new String[0]),
    PLURALS("plurals", "Plurals", new String[0]),
    RAW("raw", "Raw", new String[0]),
    STRING("string", "String", new String[0]),
    STYLE("style", "Style", new String[0]),
    STYLEABLE("styleable", "Styleable", new String[0]),
    TRANSITION("transition", "Transition", new String[0]),
    XML("xml", "XML", new String[0]),
    PUBLIC("public", "###", new String[0]);

    private final String mName;
    private final String mDisplayName;
    private final String[] mAlternateXmlNames;

    private ResourceType(String name, String displayName, String ... alternateXmlNames) {
        this.mName = name;
        this.mDisplayName = displayName;
        this.mAlternateXmlNames = alternateXmlNames;
    }

    public String getName() {
        return this.mName;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public static ResourceType getEnum(String name) {
        for (ResourceType rType : ResourceType.values()) {
            if (rType.mName.equals(name)) {
                return rType;
            }
            if (rType.mAlternateXmlNames == null) continue;
            for (String alternate : rType.mAlternateXmlNames) {
                if (!alternate.equals(name)) continue;
                return rType;
            }
        }
        return null;
    }

    public static String[] getNames() {
        ResourceType[] values = ResourceType.values();
        String[] names = new String[values.length];
        for (int i = values.length - 1; i >= 0; --i) {
            names[i] = values[i].getName();
        }
        return names;
    }

    public String toString() {
        return this.getName();
    }
}

