/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import proguard.classfile.ClassPool;
import proguard.classfile.ProgramClass;
import proguard.classfile.io.ProgramClassWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryWriter;
import proguard.io.RenamedDataEntry;

public class ClassRewriter
implements DataEntryReader {
    private final ClassPool classPool;
    private final DataEntryWriter dataEntryWriter;

    public ClassRewriter(ClassPool classPool, DataEntryWriter dataEntryWriter) {
        this.classPool = classPool;
        this.dataEntryWriter = dataEntryWriter;
    }

    @Override
    public void read(DataEntry dataEntry) throws IOException {
        String string = dataEntry.getName();
        String string2 = string.substring(0, string.length() - ".class".length());
        ProgramClass programClass = (ProgramClass)this.classPool.getClass(string2);
        if (programClass != null) {
            OutputStream outputStream;
            String string3 = programClass.getName();
            if (!string2.equals(string3)) {
                dataEntry = new RenamedDataEntry(dataEntry, string3 + ".class");
            }
            if ((outputStream = this.dataEntryWriter.getOutputStream(dataEntry)) != null) {
                DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                new ProgramClassWriter(dataOutputStream).visitProgramClass(programClass);
                dataOutputStream.flush();
            }
        }
    }
}

