/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SerializingExecutor
implements Executor,
Runnable {
    private static final Logger log = Logger.getLogger(SerializingExecutor.class.getName());
    private static final AtomicIntegerFieldUpdater<SerializingExecutor> runStateUpdater = AtomicIntegerFieldUpdater.newUpdater(SerializingExecutor.class, "runState");
    private static final int STOPPED = 0;
    private static final int RUNNING = -1;
    private final Executor executor;
    private final Queue<Runnable> runQueue = new ConcurrentLinkedQueue<Runnable>();
    private volatile int runState = 0;

    public SerializingExecutor(Executor executor) {
        Preconditions.checkNotNull((Object)executor, (Object)"'executor' must not be null.");
        this.executor = executor;
    }

    @Override
    public void execute(Runnable r) {
        this.runQueue.add((Runnable)Preconditions.checkNotNull((Object)r, (Object)"'r' must not be null."));
        this.schedule(r);
    }

    private void schedule(@Nullable Runnable removable) {
        if (runStateUpdater.compareAndSet(this, 0, -1)) {
            boolean success = false;
            try {
                this.executor.execute(this);
                success = true;
            }
            finally {
                if (!success) {
                    if (removable != null) {
                        this.runQueue.remove(removable);
                    }
                    runStateUpdater.set(this, 0);
                }
            }
        }
    }

    @Override
    public void run() {
        try {
            Runnable r;
            while ((r = this.runQueue.poll()) != null) {
                try {
                    r.run();
                }
                catch (RuntimeException e) {
                    log.log(Level.SEVERE, "Exception while executing runnable " + r, e);
                }
            }
        }
        finally {
            runStateUpdater.set(this, 0);
        }
        if (!this.runQueue.isEmpty()) {
            this.schedule(null);
        }
    }
}

