/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

public class EnumCodec<T extends Enum<T>>
implements ObjectCodec<T> {
    private final Class<T> enumClass;
    private final ImmutableList<T> values;

    public EnumCodec(Class<T> enumClass) {
        this.enumClass = enumClass;
        this.values = ImmutableList.copyOf((Object[])((Enum[])enumClass.getEnumConstants()));
    }

    @Override
    public Class<T> getEncodedClass() {
        return this.enumClass;
    }

    @Override
    public void serialize(T value, CodedOutputStream codedOut) throws IOException {
        Preconditions.checkNotNull(value, (String)"Enum value for %s is null", this.enumClass);
        codedOut.writeEnumNoTag(((Enum)value).ordinal());
    }

    @Override
    public T deserialize(CodedInputStream codedIn) throws SerializationException, IOException {
        int ordinal = codedIn.readEnum();
        try {
            return (T)((Enum)this.values.get(ordinal));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SerializationException("Invalid ordinal for " + this.enumClass.getName() + " enum: " + ordinal, e);
        }
    }
}

