/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.client.CompletionAwareCacheRequest;
import com.hazelcast.client.impl.client.PartitionClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.cache.expiry.ExpiryPolicy;

public class CachePutAllRequest
extends PartitionClientRequest
implements CompletionAwareCacheRequest,
RetryableRequest {
    private String name;
    private InMemoryFormat inMemoryFormat;
    private int partitionId;
    private int completionId;
    private List<Map.Entry<Data, Data>> entries;
    private ExpiryPolicy expiryPolicy;

    public CachePutAllRequest() {
    }

    public CachePutAllRequest(String name, InMemoryFormat inMemoryFormat, List<Map.Entry<Data, Data>> entries, ExpiryPolicy expiryPolicy, int partitionId) {
        this.name = name;
        this.inMemoryFormat = inMemoryFormat;
        this.entries = entries;
        this.expiryPolicy = expiryPolicy;
        this.partitionId = partitionId;
    }

    @Override
    protected Operation prepareOperation() {
        ICacheService service = (ICacheService)this.getService();
        CacheOperationProvider operationProvider = service.getCacheOperationProvider(this.name, this.inMemoryFormat);
        return operationProvider.createPutAllOperation(this.entries, this.expiryPolicy, this.completionId);
    }

    @Override
    public void setCompletionId(Integer completionId) {
        this.completionId = completionId != null ? completionId : -1;
    }

    @Override
    protected int getPartition() {
        return this.partitionId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public final int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 28;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.name);
        writer.writeUTF("i", this.inMemoryFormat.name());
        writer.writeInt("p", this.partitionId);
        writer.writeInt("c", this.completionId);
        writer.writeInt("s", this.entries.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Map.Entry<Data, Data> entry : this.entries) {
            out.writeData(entry.getKey());
            out.writeData(entry.getValue());
        }
        out.writeObject(this.expiryPolicy);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.inMemoryFormat = InMemoryFormat.valueOf(reader.readUTF("i"));
        this.partitionId = reader.readInt("p");
        this.completionId = reader.readInt("c");
        int size = reader.readInt("s");
        ObjectDataInput in = reader.getRawDataInput();
        this.entries = new ArrayList<Map.Entry<Data, Data>>(size);
        for (int i = 0; i < size; ++i) {
            Data key = in.readData();
            Data value = in.readData();
            this.entries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(key, value));
        }
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
    }

    @Override
    public Permission getRequiredPermission() {
        return new CachePermission(this.name, "put");
    }

    @Override
    public Object[] getParameters() {
        if (this.expiryPolicy == null) {
            return new Object[]{this.entries};
        }
        return new Object[]{this.entries, this.expiryPolicy};
    }

    @Override
    public String getMethodName() {
        return "putAll";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

