/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.extension.memoized;

import autovalue.shaded.com.google$.auto.common.$BasicAnnotationProcessor;
import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$SetMultimap;
import com.google.auto.value.extension.memoized.Memoized;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

public final class MemoizedValidator
extends $BasicAnnotationProcessor {
    @Override
    protected Iterable<? extends $BasicAnnotationProcessor.ProcessingStep> initSteps() {
        return $ImmutableList.of(new ValidationStep(this.processingEnv.getMessager()));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private static final class ValidationStep
    implements $BasicAnnotationProcessor.ProcessingStep {
        private final Messager messager;

        ValidationStep(Messager messager) {
            this.messager = messager;
        }

        @Override
        public Set<? extends Class<? extends Annotation>> annotations() {
            return $ImmutableSet.of(Memoized.class);
        }

        public Set<Element> process($SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
            for (ExecutableElement method : ElementFilter.methodsIn(elementsByAnnotation.values())) {
                if (ValidationStep.isAutoValue(method.getEnclosingElement())) continue;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "@Memoized methods must be declared only in @AutoValue classes", method, $MoreElements.getAnnotationMirror(method, Memoized.class).get());
            }
            return $ImmutableSet.of();
        }

        private static boolean isAutoValue(Element element) {
            return element.getAnnotationMirrors().stream().map(annotation -> $MoreTypes.asTypeElement(annotation.getAnnotationType())).anyMatch(type -> type.getQualifiedName().contentEquals("com.google.auto.value.AutoValue"));
        }
    }
}

