/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.meta;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.UpdatablePackage;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public final class RepositoryPackages {
    private Set<UpdatablePackage> mUpdatedPkgs = Sets.newTreeSet();
    private Set<RemotePackage> mNewPkgs = Sets.newTreeSet();
    private final long myTimestampMs;
    private Multimap<String, ? extends LocalPackage> mLocalPackagesByPrefix = TreeMultimap.create();
    private Map<String, UpdatablePackage> mConsolidatedPkgs = Maps.newTreeMap();
    private Map<String, ? extends LocalPackage> mLocalPackages = Maps.newHashMap();
    private Map<String, RemotePackage> mRemotePackages = Maps.newTreeMap();
    private final Object mLock = new Object();

    public RepositoryPackages() {
        this.myTimestampMs = System.currentTimeMillis();
    }

    public RepositoryPackages(Map<String, LocalPackage> localPkgs, Map<String, RemotePackage> remotePkgs) {
        this();
        this.setLocalPkgInfos(localPkgs);
        this.setRemotePkgInfos(remotePkgs);
    }

    public long getTimestampMs() {
        return this.myTimestampMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UpdatablePackage> getUpdatedPkgs() {
        Set<UpdatablePackage> result = this.mUpdatedPkgs;
        if (result == null) {
            Object object = this.mLock;
            synchronized (object) {
                this.computeUpdates();
                result = this.mUpdatedPkgs;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RemotePackage> getNewPkgs() {
        Set<RemotePackage> result = this.mNewPkgs;
        if (result == null) {
            Object object = this.mLock;
            synchronized (object) {
                this.computeUpdates();
                result = this.mNewPkgs;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, UpdatablePackage> getConsolidatedPkgs() {
        Map<String, UpdatablePackage> result = this.mConsolidatedPkgs;
        if (result == null) {
            Object object = this.mLock;
            synchronized (object) {
                this.computeUpdates();
                result = this.mConsolidatedPkgs;
            }
        }
        return result;
    }

    public Map<String, ? extends LocalPackage> getLocalPackages() {
        return this.mLocalPackages;
    }

    public Map<String, RemotePackage> getRemotePackages() {
        return this.mRemotePackages;
    }

    public Collection<? extends LocalPackage> getLocalPackagesForPrefix(String pathPrefix) {
        return this.mLocalPackagesByPrefix.get((Object)pathPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalPkgInfos(Map<String, ? extends LocalPackage> packages) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLocalPackages = packages;
            this.invalidate();
            this.computeLocalPackagePrefixes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemotePkgInfos(Map<String, RemotePackage> packages) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRemotePackages = packages;
            this.invalidate();
        }
    }

    private void invalidate() {
        this.mConsolidatedPkgs = null;
        this.mNewPkgs = null;
        this.mUpdatedPkgs = null;
    }

    private void computeUpdates() {
        TreeMap newConsolidatedPkgs = Maps.newTreeMap();
        HashSet updates = Sets.newHashSet();
        for (String path : this.mLocalPackages.keySet()) {
            LocalPackage local = this.mLocalPackages.get(path);
            UpdatablePackage updatable = new UpdatablePackage(local);
            newConsolidatedPkgs.put(path, updatable);
            if (!this.mRemotePackages.containsKey(path)) continue;
            updatable.setRemote(this.mRemotePackages.get(path));
            if (!updatable.isUpdate()) continue;
            updates.add(updatable);
        }
        HashSet news = Sets.newHashSet();
        for (String path : this.mRemotePackages.keySet()) {
            if (newConsolidatedPkgs.containsKey(path)) continue;
            RemotePackage remote = this.mRemotePackages.get(path);
            news.add(remote);
            UpdatablePackage updatable = new UpdatablePackage(remote);
            newConsolidatedPkgs.put(path, updatable);
        }
        this.mNewPkgs = news;
        this.mUpdatedPkgs = updates;
        this.mConsolidatedPkgs = newConsolidatedPkgs;
    }

    private void computeLocalPackagePrefixes() {
        TreeMultimap res = TreeMultimap.create();
        block0: for (Map.Entry<String, ? extends LocalPackage> entry : this.mLocalPackages.entrySet()) {
            String key = entry.getKey();
            while (true) {
                res.put((Object)key, (Object)entry.getValue());
                int endIndex = key.lastIndexOf(59);
                if (endIndex < 0) continue block0;
                key = key.substring(0, endIndex);
            }
        }
        this.mLocalPackagesByPrefix = res;
    }
}

