//
//  LEDView.m
//  BinaryClockenzie
//
//  Created by John Schilling on Tue Jan 20 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import "LEDView.h"


@implementation LEDView

- (id)initWithFrame:(NSRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        _LED = [[NSMutableArray alloc] init];
        [_LED addObject:[NSImage imageNamed:@"LED_off.tif"]];       // 0
        [_LED addObject:[NSImage imageNamed:@"LED_red.tif"]];       // 1
        [_LED addObject:[NSImage imageNamed:@"LED_orange.tif"]];    // 2
        [_LED addObject:[NSImage imageNamed:@"LED_yellow.tif"]];    // 3
        [_LED addObject:[NSImage imageNamed:@"LED_green.tif"]];     // 4
        [_LED addObject:[NSImage imageNamed:@"LED_blue.tif"]];      // 5
        [_LED addObject:[NSImage imageNamed:@"LED_purple.tif"]];    // 6
        [_LED addObject:[NSImage imageNamed:@"LED_kat.tif"]];     // 7
    }
    return self;
}

- (void)dealloc
{
    [super dealloc];
}

- (void)drawRect:(NSRect)rect {
    if ( [_LED objectAtIndex:_num] == nil ) return;
    [[_LED objectAtIndex:_num] compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver];
}



- (void)setImage:(int)imageNumber
{
    if (imageNumber >= [_LED count]) {
        _num = 0;
    } else {
        _num = imageNumber;
    }
    
    [self setNeedsDisplay:YES];
}

@end
