/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.ber.stream.BERElement;

public class BERObjectId
extends BERElement {
    private int[] m_value = null;

    public BERObjectId(int[] nArray) {
        this.m_value = new int[nArray.length];
        System.arraycopy(nArray, 0, this.m_value, 0, nArray.length);
    }

    public BERObjectId(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        this.m_value = new int[stringTokenizer.countTokens()];
        for (int i = 0; i < this.m_value.length; ++i) {
            this.m_value[i] = Integer.parseInt(stringTokenizer.nextToken());
        }
    }

    public BERObjectId(InputStream inputStream, int[] nArray) throws IOException {
        int n = BERElement.readLengthOctets(inputStream, nArray);
        nArray[0] = nArray[0] + n;
        int[] nArray2 = new int[1];
        Vector<Integer> vector = new Vector<Integer>(10);
        nArray2[0] = 0;
        int n2 = this.readSubIdentifier(inputStream, nArray2);
        n -= nArray2[0];
        if (n2 < 40) {
            vector.addElement(new Integer(0));
        } else if (n2 < 80) {
            vector.addElement(new Integer(1));
        } else {
            vector.addElement(new Integer(2));
        }
        vector.addElement(new Integer(n2 - (Integer)vector.elementAt(vector.size() - 1) * 40));
        while (n > 0) {
            nArray2[0] = 0;
            n2 = this.readSubIdentifier(inputStream, nArray2);
            n -= nArray2[0];
            vector.addElement(new Integer(n2));
        }
        this.m_value = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.m_value[i] = (Integer)vector.elementAt(i);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(6);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeSubIdentifier(byteArrayOutputStream, this.m_value[0] * 40 + this.m_value[1]);
        for (int i = 2; i < this.m_value.length; ++i) {
            this.writeSubIdentifier(byteArrayOutputStream, this.m_value[i]);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        BERObjectId.sendDefiniteLength(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    private int readSubIdentifier(InputStream inputStream, int[] nArray) throws IOException {
        int n;
        int n2 = 0;
        do {
            n = inputStream.read();
            nArray[0] = nArray[0] + 1;
            n2 = n2 << 7 | n & 0x7F;
        } while ((n & 0x80) > 0);
        return n2;
    }

    private void writeSubIdentifier(OutputStream outputStream, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (n > 0) {
            byteArrayOutputStream.write(n & 0x7F);
            n >>= 7;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        for (int i = byArray.length - 1; i > 0; --i) {
            outputStream.write(byArray[i] | 0x80);
        }
        outputStream.write(byArray[0]);
    }

    public int[] getValue() {
        return this.m_value;
    }

    public int getType() {
        return 6;
    }

    public String toString() {
        if (this.m_value == null) {
            return "ObjectIdentifier (null)";
        }
        String string = "";
        for (int i = 0; i < this.m_value.length; ++i) {
            if (i != 0) {
                string = string + " ";
            }
            string = string + this.m_value[i];
        }
        return "ObjectIdentifier {" + string + "}";
    }
}

