/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.elements.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.intabulas.sandler.elements.AtomElement;
import org.intabulas.sandler.elements.Content;
import org.intabulas.sandler.elements.Link;
import org.intabulas.sandler.elements.Person;
import org.intabulas.sandler.elements.SandlerEntry;
import org.intabulas.sandler.elements.impl.ContentImpl;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AbstractEntryElement
implements SandlerEntry,
AtomElement {
    protected Content _title;
    protected Content _summary;
    protected Date _modified;
    protected String _id;
    protected Person _author;
    protected List _contributorList = new ArrayList();
    protected List _linksList = new ArrayList();

    public Content getSummary() {
        return this._summary;
    }

    public void setSummary(Content summary) {
        this._summary = summary;
    }

    public void setSummary(String summary) {
        this._summary = new ContentImpl();
        this._summary.setBody(summary);
    }

    public Content getTitle() {
        return this._title;
    }

    public void setTitle(Content title) {
        this._title = title;
    }

    public void setTitle(String title) {
        this._title = new ContentImpl();
        this._title.setBody(title);
    }

    public Date getModified() {
        return this._modified;
    }

    public void setModified(Date date) {
        this._modified = date;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public Person getAuthor() {
        return this._author;
    }

    public void setAuthor(Person author) {
        this._author = author;
    }

    public boolean removeContributor(Person contributor) {
        boolean result = false;
        if (this._contributorList.contains(contributor)) {
            result = this._contributorList.remove(contributor);
        }
        return result;
    }

    public boolean addContributor(Person contributor) {
        return this._contributorList.add(contributor);
    }

    public int getContributorCount() {
        return this._contributorList.size();
    }

    public void removeContributor(int index) {
        if (index >= 0 && index < this._contributorList.size()) {
            this._contributorList.remove(index);
        }
    }

    public Person getContributor(int index) {
        Person result = null;
        if (index >= 0 && index < this._contributorList.size()) {
            result = (Person)this._contributorList.get(index);
        }
        return result;
    }

    public List getContributors() {
        return Collections.unmodifiableList(this._contributorList);
    }

    public void addContributor(int index, Person contributor) {
        if (index >= 0 && index < this._contributorList.size()) {
            this._contributorList.add(index, contributor);
        }
    }

    public Collection getLinks() {
        return Collections.unmodifiableList(this._linksList);
    }

    public boolean hasAlternateLink() {
        boolean result = false;
        for (int x = 0; x < this._linksList.size(); ++x) {
            Link link = (Link)this._linksList.get(x);
            if (link == null || link.getRelationship() == null || !link.getRelationship().equals("alternate")) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean hasExistingAlternateLink(String type) {
        boolean result = false;
        for (int x = 0; x < this._linksList.size(); ++x) {
            Link link = (Link)this._linksList.get(x);
            if (link == null || link.getRelationship() == null || !link.getRelationship().equals("alternate") || !link.getType().equals(type)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean addLink(Link link) {
        boolean canadd = true;
        boolean result = false;
        if (link != null) {
            if (link.getRelationship() != null && link.getRelationship().equals("alternate") && link.getType() != null) {
                boolean bl = canadd = !this.hasExistingAlternateLink(link.getType());
            }
            if (canadd) {
                result = this._linksList.add(link);
            }
        }
        return result;
    }

    public void addLink(int index, Link link) {
        boolean canadd = true;
        if (link != null) {
            if (link.getRelationship() != null && link.getRelationship().equals("alternate") && link.getType() != null) {
                boolean bl = canadd = !this.hasExistingAlternateLink(link.getType());
            }
            if (canadd && index >= 0 && index < this._linksList.size()) {
                this._linksList.add(index, link);
            }
        }
    }

    public Link getLink(int index) {
        Link result = null;
        if (index >= 0 && index < this._linksList.size()) {
            result = (Link)this._linksList.get(index);
        }
        return result;
    }

    public int getLinkCount() {
        return this._linksList.size();
    }

    public boolean removeLink(Link link) {
        boolean result = false;
        if (this._linksList.contains(link)) {
            result = this._linksList.remove(link);
        }
        return result;
    }

    public void removeLink(int index) {
        if (index >= 0 && index < this._linksList.size()) {
            this._linksList.remove(index);
        }
    }

    public void loadDocument(XmlPullParser parser) throws XmlPullParserException {
    }

    public void clear() {
        this._title = null;
        this._summary = null;
        this._modified = null;
        this._id = null;
        this._author = null;
        this._contributorList.clear();
        this._linksList.clear();
    }
}

