/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

class TextBuffer {
    private static final String CVS_ID = "@(#) $RCSfile: TextBuffer.java,v $ $Revision: 1.5 $ $Date: 2003/01/23 02:23:31 $ $Name: jdom_1_0_b9_rc2 $";
    private String prefixString;
    private char[] array = new char[4096];
    private int arraySize = 0;

    public void append(char[] source, int start, int count) {
        if (this.prefixString == null) {
            this.prefixString = new String(source, start, count);
        } else {
            this.ensureCapacity(this.arraySize + count);
            System.arraycopy(source, start, this.array, this.arraySize, count);
            this.arraySize += count;
        }
    }

    public void clear() {
        this.arraySize = 0;
        this.prefixString = null;
    }

    private void ensureCapacity(int csize) {
        int capacity = this.array.length;
        if (csize > capacity) {
            char[] old = this.array;
            int nsize = capacity;
            while (csize > nsize) {
                nsize += capacity / 2;
            }
            this.array = new char[nsize];
            System.arraycopy(old, 0, this.array, 0, this.arraySize);
        }
    }

    public int size() {
        if (this.prefixString == null) {
            return 0;
        }
        return this.prefixString.length() + this.arraySize;
    }

    public String toString() {
        if (this.prefixString == null) {
            return "";
        }
        String str = "";
        str = this.arraySize == 0 ? this.prefixString : new StringBuffer(this.prefixString.length() + this.arraySize).append(this.prefixString).append(this.array, 0, this.arraySize).toString();
        return str;
    }
}

