/*
 * Decompiled with CFR 0.152.
 */
package ccl.util;

import ccl.util.FileUtil;
import ccl.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ClassPathUtil {
    public static String getAbsoluteClassFileName(String sFullClassName_, String sClasspath_) {
        String sRelativeClassName = sFullClassName_.replace('.', File.separatorChar) + ".class";
        int pos = 0;
        int lastpos = 0;
        while (lastpos != -1) {
            String sCurrentDir;
            pos = sClasspath_.indexOf(File.pathSeparatorChar, lastpos);
            if (pos == -1) {
                sCurrentDir = sClasspath_.substring(lastpos);
                lastpos = -1;
            } else {
                sCurrentDir = sClasspath_.substring(lastpos, pos);
                lastpos = pos + 1;
                if (lastpos >= sClasspath_.length()) {
                    lastpos = -1;
                }
            }
            String sTestFile = FileUtil.concatPath(sCurrentDir, sRelativeClassName);
            if (!FileUtil.existsFile(sTestFile)) continue;
            return sTestFile;
        }
        return null;
    }

    public static String getJarFileName(String sFullClassName_) throws IOException, ZipException {
        return ClassPathUtil.getJarFileName(sFullClassName_, System.getProperty("java.class.path"));
    }

    public static String getJarFileName(String sFullClassName_, String sClasspath_) throws IOException, ZipException {
        String sClassFileName = sFullClassName_.replace('.', '/') + ".class";
        Vector vClasspathElements = Util.stringToLines(sClasspath_, File.pathSeparatorChar);
        Enumeration eElements = vClasspathElements.elements();
        while (eElements.hasMoreElements()) {
            String sNextArchiv = (String)eElements.nextElement();
            if (!Util.endsWith(sNextArchiv, ".zip") && !Util.endsWith(sNextArchiv, ".jar") || !FileUtil.existsFile(sNextArchiv)) continue;
            ZipFile pZipFile = new ZipFile(sNextArchiv);
            ZipEntry pZipEntry = pZipFile.getEntry(sClassFileName);
            if (pZipEntry != null) {
                pZipFile.close();
                return sNextArchiv;
            }
            pZipFile.close();
        }
        return null;
    }

    public static String getClassOrJarFileName(String sFullClassName_) throws IOException, ClassNotFoundException, ZipException {
        return ClassPathUtil.getClassOrJarFileName(sFullClassName_, System.getProperty("java.class.path"));
    }

    public static String getClassOrJarFileName(String sFullClassName_, String sClasspath_) throws IOException, ClassNotFoundException, ZipException {
        String sAbsoluteClassFileName = ClassPathUtil.getAbsoluteClassFileName(sFullClassName_, sClasspath_);
        if (sAbsoluteClassFileName != null) {
            return sAbsoluteClassFileName;
        }
        return ClassPathUtil.getJarFileName(sFullClassName_, sClasspath_);
    }

    public static String jwhich(String sClassName_, String sClasspath_) {
        Vector vClasspaths = Util.stringToLines(sClasspath_, File.pathSeparatorChar);
        try {
            Enumeration eClasspaths = vClasspaths.elements();
            while (eClasspaths.hasMoreElements()) {
                String sNextPath = (String)eClasspaths.nextElement();
                String sClassFile = FileUtil.concatPath(sNextPath, sClassName_.replace('.', File.separatorChar)) + ".class";
                if (FileUtil.existsFile(sClassFile)) {
                    return sClassFile;
                }
                String sZipFile = ClassPathUtil.getJarFileName(sClassName_, sNextPath);
                if (sZipFile == null) continue;
                return sZipFile;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String _getApplicationHomeFromClasses(Object oClass) {
        Util.debug("ccl.util.ClassPathUtil._getApplicationHomeFromClasses(..).ENTER");
        String sRetVal = null;
        String sClassName = oClass.getClass().getName();
        String sClassLocation = FileUtil.getClassPath(oClass);
        Util.debug("ccl.util.ClassPathUtil._getApplicationHomeFromClasses(..).sClassLocation: " + sClassLocation);
        if (!Util.isEmpty(sClassLocation) && FileUtil.existsFile(sClassLocation = FileUtil.concatPath(sClassLocation, Util.getObjectName(oClass) + ".class"))) {
            int dots = Util.getOccurances(sClassName, 46);
            File flParent = new File(sClassLocation);
            Util.debug("ccl.util.ClassPathUtil._getApplicationHomeFromClasses(..).flParent: " + flParent);
            while (dots >= 0) {
                flParent = new File(flParent.getParent());
                --dots;
            }
            String sName = flParent.getName();
            sRetVal = sName.equals("classes") ? flParent.getParent() : flParent.getPath();
        }
        return sRetVal;
    }

    private static String _getApplicationHomeFromLib(Object oClass) {
        String sRetVal = null;
        String sClassName = oClass.getClass().getName();
        try {
            String sJarFile = ClassPathUtil.getJarFileName(sClassName);
            if (!Util.isEmpty(sJarFile) && FileUtil.existsFile(sJarFile)) {
                File flParent = new File(sJarFile);
                sRetVal = (flParent = new File(flParent.getParent())).getName().equals("lib") ? flParent.getParent() : flParent.getPath();
            }
        }
        catch (IOException ioException) {
            Util.printlnErr(ioException);
        }
        return sRetVal;
    }

    public static String getApplicationHome(Object oClass) {
        String sRetVal = null;
        String sClassName = oClass.getClass().getName();
        Util.debug("ccl.util.ClassPathUtil.getApplicationHome(..).sClassName: " + sClassName);
        sRetVal = ClassPathUtil._getApplicationHomeFromClasses(oClass);
        Util.debug("ccl.util.ClassPathUtil.getApplicationHome(..).appHome: " + String.valueOf(sRetVal));
        if (Util.isEmpty(sRetVal)) {
            sRetVal = ClassPathUtil._getApplicationHomeFromLib(oClass);
        }
        Util.debug("ccl.util.ClassPathUtil.getApplicationHome(..).sRetVal: " + sRetVal);
        return sRetVal;
    }
}

