/*
 * Decompiled with CFR 0.152.
 */
package javancss;

import ccl.util.Util;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javancss.Formatter;
import javancss.Javancss;
import javancss.JavancssConstants;
import javancss.PackageMetric;

public class AsciiFormatter
implements Formatter,
JavancssConstants {
    static final int LEN_NR = 3;
    private static final String NL = System.getProperty("line.separator");
    private Javancss _javancss = null;
    private String[] _header = null;
    private int _length = 0;
    private int _nr = 0;
    static NumberFormat _pNumberFormat = null;
    StringBuffer _line = new StringBuffer();

    private String _formatListHeader(int lines, String[] header) {
        this._header = header;
        this._nr = 0;
        StringBuffer sRetVal = new StringBuffer();
        this._length = Util.itoa(lines).length();
        int spaces = Math.max(0, this._length - 3);
        this._length = spaces + 3;
        sRetVal.append(Util.multiplyChar(' ', spaces));
        sRetVal.append("Nr.");
        int nr = 0;
        while (nr < header.length) {
            sRetVal.append(" ").append(header[nr]);
            ++nr;
        }
        sRetVal.append(NL);
        return sRetVal.toString();
    }

    private String _formatListLine(String name, int[] value) {
        StringBuffer sLine = new StringBuffer();
        ++this._nr;
        sLine.append(Util.paddWithSpace(this._nr, this._length));
        int index = 0;
        while (index < this._header.length - 1) {
            sLine.append(" ");
            sLine.append(Util.paddWithSpace(value[index], this._header[index].length()));
            ++index;
        }
        sLine.append(" ");
        sLine.append(name);
        sLine.append(NL);
        return sLine.toString();
    }

    private double _divide(int divident, int divisor) {
        double dRetVal = 0.0;
        if (divisor > 0) {
            dRetVal = (double)Math.round((double)divident / (double)divisor * 100.0) / 100.0;
        }
        return dRetVal;
    }

    private double _divide(long divident, long divisor) {
        double dRetVal = 0.0;
        if (divisor > 0L) {
            dRetVal = (double)Math.round((double)divident / (double)divisor * 100.0) / 100.0;
        }
        return dRetVal;
    }

    private String _formatPackageMatrix(int packages, int classesSum, int functionsSum, int javadocsSum, int ncssSum) {
        ((DecimalFormat)_pNumberFormat).applyPattern("###0.00");
        int maxItemLength = _pNumberFormat.format(ncssSum).length();
        maxItemLength = Math.max(9, maxItemLength);
        String sRetVal = Util.paddWithSpace("Packages", maxItemLength) + " " + Util.paddWithSpace("Classes", maxItemLength) + " " + Util.paddWithSpace("Functions", maxItemLength) + " " + Util.paddWithSpace("NCSS", maxItemLength) + " " + Util.paddWithSpace("Javadocs", maxItemLength) + " | per" + NL;
        sRetVal = sRetVal + Util.multiplyChar('-', (maxItemLength + 1) * 6 + 1) + NL + Util.paddWithSpace(_pNumberFormat.format(packages), maxItemLength) + " " + Util.paddWithSpace(_pNumberFormat.format(classesSum), maxItemLength) + " " + Util.paddWithSpace(_pNumberFormat.format(functionsSum), maxItemLength) + " " + Util.paddWithSpace(_pNumberFormat.format(ncssSum), maxItemLength) + " " + Util.paddWithSpace(_pNumberFormat.format(javadocsSum), maxItemLength) + " | Project" + NL;
        sRetVal = sRetVal + Util.multiplyChar(' ', maxItemLength + 1) + Util.paddWithSpace(_pNumberFormat.format(this._divide(classesSum, packages)), maxItemLength) + " " + Util.paddWithSpace(_pNumberFormat.format(this._divide(functionsSum, packages)), maxItemLength) + " " + Util.paddWithSpace(_pNumberFormat.format(this._divide(ncssSum, packages)), maxItemLength) + " " + Util.paddWithSpace(_pNumberFormat.format(this._divide(javadocsSum, packages)), maxItemLength) + " | Package" + NL;
        sRetVal = sRetVal + Util.multiplyChar(' ', (maxItemLength + 1) * 2) + Util.paddWithSpace(_pNumberFormat.format(this._divide(functionsSum, classesSum)), maxItemLength) + " " + Util.paddWithSpace(_pNumberFormat.format(this._divide(ncssSum, classesSum)), maxItemLength) + " " + Util.paddWithSpace(_pNumberFormat.format(this._divide(javadocsSum, classesSum)), maxItemLength) + " | Class" + NL;
        sRetVal = sRetVal + Util.multiplyChar(' ', (maxItemLength + 1) * 3) + Util.paddWithSpace(_pNumberFormat.format(this._divide(ncssSum, functionsSum)), maxItemLength) + " " + Util.paddWithSpace(_pNumberFormat.format(this._divide(javadocsSum, functionsSum)), maxItemLength) + " | Function" + NL;
        ((DecimalFormat)_pNumberFormat).applyPattern("#,##0.00");
        return sRetVal;
    }

    public AsciiFormatter(Javancss javancss) {
        this._javancss = javancss;
        _pNumberFormat = NumberFormat.getInstance(Locale.US);
        ((DecimalFormat)_pNumberFormat).applyPattern("#,##0.00");
    }

    public String printPackageNcss() {
        Vector vPackageMetrics = this._javancss.getPackageMetrics();
        int packages = vPackageMetrics.size();
        String sRetVal = this._formatListHeader(packages, new String[]{"  Classes", "Functions", "     NCSS", " Javadocs", "Package"});
        int classesSum = 0;
        int functionsSum = 0;
        int javadocsSum = 0;
        int ncssSum = 0;
        Enumeration ePackages = vPackageMetrics.elements();
        while (ePackages.hasMoreElements()) {
            PackageMetric pPackageMetric = (PackageMetric)ePackages.nextElement();
            classesSum += pPackageMetric.classes;
            functionsSum += pPackageMetric.functions;
            ncssSum += pPackageMetric.ncss;
            javadocsSum += pPackageMetric.javadocs;
            sRetVal = sRetVal + this._formatListLine(pPackageMetric.name, new int[]{pPackageMetric.classes, pPackageMetric.functions, pPackageMetric.ncss, pPackageMetric.javadocs});
        }
        int packagesLength = Util.itoa(packages).length();
        int spaces = Math.max(packagesLength, 3) + 1;
        sRetVal = sRetVal + Util.multiplyChar(' ', spaces) + "--------- --------- --------- ---------" + NL;
        sRetVal = sRetVal + Util.multiplyChar(' ', spaces) + Util.paddWithSpace(classesSum, 9) + " " + Util.paddWithSpace(functionsSum, 9) + " " + Util.paddWithSpace(ncssSum, 9) + " " + Util.paddWithSpace(javadocsSum, 9) + " Total" + NL + NL;
        sRetVal = sRetVal + this._formatPackageMatrix(packages, classesSum, functionsSum, javadocsSum, ncssSum);
        return sRetVal;
    }

    private String _formatObjectResume(int objects, long lObjectSum, long lFunctionSum, long lClassesSum, long lJVDCSum) {
        double fAverageNcss = this._divide(lObjectSum, (long)objects);
        double fAverageFuncs = this._divide(lFunctionSum, (long)objects);
        double fAverageClasses = this._divide(lClassesSum, (long)objects);
        double fAverageJavadocs = this._divide(lJVDCSum, (long)objects);
        DecimalFormat pNumberFormat = new DecimalFormat("#,##0.00");
        String sRetVal = "Average Object NCSS:             " + Util.paddWithSpace(pNumberFormat.format(fAverageNcss), 9) + NL;
        sRetVal = sRetVal + "Average Object Functions:        " + Util.paddWithSpace(pNumberFormat.format(fAverageFuncs), 9) + NL;
        sRetVal = sRetVal + "Average Object Inner Classes:    " + Util.paddWithSpace(pNumberFormat.format(fAverageClasses), 9) + NL;
        sRetVal = sRetVal + "Average Object Javadoc Comments: " + Util.paddWithSpace(pNumberFormat.format(fAverageJavadocs), 9) + NL;
        sRetVal = sRetVal + "Program NCSS:                    " + Util.paddWithSpace(pNumberFormat.format(this._javancss.getNcss()), 9) + NL;
        return sRetVal;
    }

    public String printObjectNcss() {
        Vector vObjectMetrics = this._javancss.getObjectMetrics();
        String sRetVal = this._formatListHeader(vObjectMetrics.size(), new String[]{"NCSS", "Functions", "Classes", "Javadocs", "Class"});
        long lFunctionSum = 0L;
        long lClassesSum = 0L;
        long lObjectSum = 0L;
        long lJVDCSum = 0L;
        Enumeration eClasses = vObjectMetrics.elements();
        while (eClasses.hasMoreElements()) {
            Vector vClassMetrics = (Vector)eClasses.nextElement();
            String sClass = (String)vClassMetrics.elementAt(0);
            int objectNcss = (Integer)vClassMetrics.elementAt(1);
            int functions = (Integer)vClassMetrics.elementAt(2);
            int classes = (Integer)vClassMetrics.elementAt(3);
            int jvdcs = (Integer)vClassMetrics.elementAt(6);
            lObjectSum += (long)objectNcss;
            lFunctionSum += (long)functions;
            lClassesSum += (long)classes;
            lJVDCSum += (long)jvdcs;
            sRetVal = sRetVal + this._formatListLine(sClass, new int[]{objectNcss, functions, classes, jvdcs});
        }
        sRetVal = sRetVal + this._formatObjectResume(vObjectMetrics.size(), lObjectSum, lFunctionSum, lClassesSum, lJVDCSum);
        return sRetVal;
    }

    private String _formatFunctionResume(int functions, long lFunctionSum, long lCCNSum, long lJVDCSum) {
        StringBuffer sRetVal = new StringBuffer();
        double fAverageNcss = this._divide(lFunctionSum, (long)functions);
        double fAverageCCN = this._divide(lCCNSum, (long)functions);
        double fAverageJVDC = this._divide(lJVDCSum, (long)functions);
        DecimalFormat pNumberFormat = new DecimalFormat("#,##0.00");
        sRetVal.append("Average Function NCSS: ").append(Util.paddWithSpace(pNumberFormat.format(fAverageNcss), 10)).append(NL);
        sRetVal.append("Average Function CCN:  ").append(Util.paddWithSpace(pNumberFormat.format(fAverageCCN), 10)).append(NL);
        sRetVal.append("Average Function JVDC: ").append(Util.paddWithSpace(pNumberFormat.format(fAverageJVDC), 10)).append(NL);
        sRetVal.append("Program NCSS:          ").append(Util.paddWithSpace(pNumberFormat.format(this._javancss.getNcss()), 10)).append(NL);
        return sRetVal.toString();
    }

    public String printFunctionNcss() {
        StringBuffer sRetVal = new StringBuffer(80000);
        Vector vFunctionMetrics = this._javancss.getFunctionMetrics();
        sRetVal.append(this._formatListHeader(vFunctionMetrics.size(), new String[]{"NCSS", "CCN", "JVDC", "Function"}));
        long lFunctionSum = 0L;
        long lCCNSum = 0L;
        long lJVDCSum = 0L;
        Enumeration eFunctions = vFunctionMetrics.elements();
        while (eFunctions.hasMoreElements()) {
            Vector vSingleFunctionMetrics = (Vector)eFunctions.nextElement();
            String sFunction = null;
            sFunction = (String)vSingleFunctionMetrics.elementAt(0);
            int functionNcss = (Integer)vSingleFunctionMetrics.elementAt(1);
            int functionCCN = (Integer)vSingleFunctionMetrics.elementAt(2);
            int functionJVDC = (Integer)vSingleFunctionMetrics.elementAt(3);
            lFunctionSum += (long)functionNcss;
            lCCNSum += (long)functionCCN;
            lJVDCSum += (long)functionJVDC;
            sRetVal.append(this._formatListLine(sFunction, new int[]{functionNcss, functionCCN, functionJVDC}));
        }
        sRetVal.append(this._formatFunctionResume(vFunctionMetrics.size(), lFunctionSum, lCCNSum, lJVDCSum));
        return sRetVal.toString();
    }

    public String printJavaNcss() {
        return "Java NCSS: " + this._javancss.getNcss() + NL;
    }
}

