package net.sf.colorer.eclipse.ftpp;

import net.sf.colorer.FileType;
import net.sf.colorer.Group;
import net.sf.colorer.ParserFactory;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * Reads out filetype and groups layout from HRC object model
 * @author Igor Russkih
 *
 */
class FileTypesContentProvider implements  ITreeContentProvider{

    public FileTypesContentProvider() {}

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Group){
            Group[] g = ((Group)parentElement).getGroups();
            FileType[] ft = ((Group)parentElement).getFileTypes();
            Object[] children = new Object[g.length + ft.length];
            System.arraycopy(ft, 0, children, 0, ft.length);
            System.arraycopy(g, 0, children, ft.length, g.length);
            return children;
        }
        return null;
    }
    public boolean hasChildren(Object element) {
        if (element instanceof Group){
            return ((Group)element).getGroups().length != 0 || ((Group)element).getFileTypes().length != 0;
        }
        return false;
    }
    public Object getParent(Object element) {
        if (element instanceof FileType){
            return ((FileType)element).getGroup();
        }
        return null;
    }
    public Object[] getElements(Object inputElement) {
        ParserFactory pf = (ParserFactory)inputElement;
        return pf.getHRCParser().getGroups();
    }
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
    public void dispose() {
    }
}
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Colorer Library.
 *
 * The Initial Developer of the Original Code is
 * Igor Russkih <irusskih at gmail.com>.
 * Portions created by the Initial Developer are Copyright (C) 1999-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
