/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.rangedifferencer;

public class RangeDifference {
    public static final int NOCHANGE = 0;
    public static final int CHANGE = 2;
    public static final int CONFLICT = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int ANCESTOR = 4;
    public static final int ERROR = 5;
    int fKind;
    int fLeftStart;
    int fLeftLength;
    int fRightStart;
    int fRightLength;
    int lAncestorStart;
    int lAncestorLength;

    RangeDifference(int n) {
        this.fKind = n;
    }

    public RangeDifference(int n, int n2, int n3, int n4, int n5) {
        this.fKind = n;
        this.fRightStart = n2;
        this.fRightLength = n3;
        this.fLeftStart = n4;
        this.fLeftLength = n5;
    }

    RangeDifference(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(n, n2, n3, n4, n5);
        this.lAncestorStart = n6;
        this.lAncestorLength = n7;
    }

    public int kind() {
        return this.fKind;
    }

    public int ancestorStart() {
        return this.lAncestorStart;
    }

    public int ancestorLength() {
        return this.lAncestorLength;
    }

    public int ancestorEnd() {
        return this.lAncestorStart + this.lAncestorLength;
    }

    public int rightStart() {
        return this.fRightStart;
    }

    public int rightLength() {
        return this.fRightLength;
    }

    public int rightEnd() {
        return this.fRightStart + this.fRightLength;
    }

    public int leftStart() {
        return this.fLeftStart;
    }

    public int leftLength() {
        return this.fLeftLength;
    }

    public int leftEnd() {
        return this.fLeftStart + this.fLeftLength;
    }

    public int maxLength() {
        return Math.max(this.fRightLength, Math.max(this.fLeftLength, this.lAncestorLength));
    }

    public boolean equals(Object object) {
        if (object instanceof RangeDifference) {
            RangeDifference rangeDifference = (RangeDifference)object;
            return this.fKind == rangeDifference.fKind && this.fLeftStart == rangeDifference.fLeftStart && this.fLeftLength == rangeDifference.fLeftLength && this.fRightStart == rangeDifference.fRightStart && this.fRightLength == rangeDifference.fRightLength && this.lAncestorStart == rangeDifference.lAncestorStart && this.lAncestorLength == rangeDifference.lAncestorLength;
        }
        return super.equals(object);
    }

    public String toString() {
        String string = "Left: " + this.toRangeString(this.fLeftStart, this.fLeftLength) + " Right: " + this.toRangeString(this.fRightStart, this.fRightLength);
        if (this.lAncestorLength > 0 || this.lAncestorStart > 0) {
            string = string + " Ancestor: " + this.toRangeString(this.lAncestorStart, this.lAncestorLength);
        }
        return string;
    }

    private String toRangeString(int n, int n2) {
        return "(" + n + ", " + n2 + ")";
    }
}

