/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html;

import org.outerj.daisy.diff.html.dom.ImageNode;
import org.outerj.daisy.diff.html.dom.Node;
import org.outerj.daisy.diff.html.dom.TagNode;
import org.outerj.daisy.diff.html.dom.TextNode;
import org.outerj.daisy.diff.html.modification.Modification;
import org.outerj.daisy.diff.html.modification.ModificationType;
import org.outerj.daisy.diff.output.DiffOutput;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HtmlSaxDiffOutput
implements DiffOutput {
    private ContentHandler handler;
    private String prefix;

    public HtmlSaxDiffOutput(ContentHandler contentHandler, String string) {
        this.handler = contentHandler;
        this.prefix = string;
    }

    public void generateOutput(TagNode tagNode) throws SAXException {
        if (!tagNode.getQName().equalsIgnoreCase("img") && !tagNode.getQName().equalsIgnoreCase("body")) {
            this.handler.startElement("", tagNode.getQName(), tagNode.getQName(), tagNode.getAttributes());
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "";
        for (Node node : tagNode) {
            Object object;
            if (node instanceof TagNode) {
                if (bl) {
                    this.handler.endElement("", "span", "span");
                    bl = false;
                } else if (bl3) {
                    this.handler.endElement("", "span", "span");
                    bl3 = false;
                } else if (bl2) {
                    this.handler.endElement("", "span", "span");
                    bl2 = false;
                }
                this.generateOutput((TagNode)node);
                continue;
            }
            if (!(node instanceof TextNode)) continue;
            TextNode textNode = (TextNode)node;
            Modification modification = textNode.getModification();
            if (bl && (modification.getType() != ModificationType.ADDED || modification.isFirstOfID())) {
                this.handler.endElement("", "span", "span");
                bl = false;
            } else if (bl3 && (modification.getType() != ModificationType.CHANGED || !modification.getChanges().equals(string) || modification.isFirstOfID())) {
                this.handler.endElement("", "span", "span");
                bl3 = false;
            } else if (bl2 && (modification.getType() != ModificationType.REMOVED || modification.isFirstOfID())) {
                this.handler.endElement("", "span", "span");
                bl2 = false;
            }
            if (!bl && modification.getType() == ModificationType.ADDED) {
                object = new AttributesImpl();
                ((AttributesImpl)object).addAttribute("", "class", "class", "CDATA", "diff-html-added");
                if (modification.isFirstOfID()) {
                    ((AttributesImpl)object).addAttribute("", "id", "id", "CDATA", (Object)((Object)modification.getType()) + "-" + this.prefix + "-" + modification.getID());
                }
                this.addAttributes(modification, (AttributesImpl)object);
                this.handler.startElement("", "span", "span", (Attributes)object);
                bl = true;
            } else if (!bl3 && modification.getType() == ModificationType.CHANGED) {
                object = new AttributesImpl();
                ((AttributesImpl)object).addAttribute("", "class", "class", "CDATA", "diff-html-changed");
                if (modification.isFirstOfID()) {
                    ((AttributesImpl)object).addAttribute("", "id", "id", "CDATA", (Object)((Object)modification.getType()) + "-" + this.prefix + "-" + modification.getID());
                }
                this.addAttributes(modification, (AttributesImpl)object);
                this.handler.startElement("", "span", "span", (Attributes)object);
                bl3 = true;
                string = modification.getChanges();
            } else if (!bl2 && modification.getType() == ModificationType.REMOVED) {
                object = new AttributesImpl();
                ((AttributesImpl)object).addAttribute("", "class", "class", "CDATA", "diff-html-removed");
                if (modification.isFirstOfID()) {
                    ((AttributesImpl)object).addAttribute("", "id", "id", "CDATA", (Object)((Object)modification.getType()) + "-" + this.prefix + "-" + modification.getID());
                }
                this.addAttributes(modification, (AttributesImpl)object);
                this.handler.startElement("", "span", "span", (Attributes)object);
                bl2 = true;
            }
            object = textNode.getText().toCharArray();
            if (textNode instanceof ImageNode) {
                this.writeImage((ImageNode)textNode);
                continue;
            }
            this.handler.characters((char[])object, 0, ((Object)object).length);
        }
        if (bl) {
            this.handler.endElement("", "span", "span");
            bl = false;
        } else if (bl3) {
            this.handler.endElement("", "span", "span");
            bl3 = false;
        } else if (bl2) {
            this.handler.endElement("", "span", "span");
            bl2 = false;
        }
        if (!tagNode.getQName().equalsIgnoreCase("img") && !tagNode.getQName().equalsIgnoreCase("body")) {
            this.handler.endElement("", tagNode.getQName(), tagNode.getQName());
        }
    }

    private void writeImage(ImageNode imageNode) throws SAXException {
        AttributesImpl attributesImpl = imageNode.getAttributes();
        if (imageNode.getModification().getType() == ModificationType.REMOVED) {
            attributesImpl.addAttribute("", "changeType", "changeType", "CDATA", "diff-removed-image");
        } else if (imageNode.getModification().getType() == ModificationType.ADDED) {
            attributesImpl.addAttribute("", "changeType", "changeType", "CDATA", "diff-added-image");
        }
        this.handler.startElement("", "img", "img", attributesImpl);
        this.handler.endElement("", "img", "img");
    }

    private void addAttributes(Modification modification, AttributesImpl attributesImpl) {
        String string;
        if (modification.getType() == ModificationType.CHANGED) {
            string = modification.getChanges();
            attributesImpl.addAttribute("", "changes", "changes", "CDATA", string);
        }
        string = modification.getPrevious() == null ? "first-" + this.prefix : (Object)((Object)modification.getPrevious().getType()) + "-" + this.prefix + "-" + modification.getPrevious().getID();
        attributesImpl.addAttribute("", "previous", "previous", "CDATA", string);
        String string2 = (Object)((Object)modification.getType()) + "-" + this.prefix + "-" + modification.getID();
        attributesImpl.addAttribute("", "changeId", "changeId", "CDATA", string2);
        String string3 = modification.getNext() == null ? "last-" + this.prefix : (Object)((Object)modification.getNext().getType()) + "-" + this.prefix + "-" + modification.getNext().getID();
        attributesImpl.addAttribute("", "next", "next", "CDATA", string3);
    }
}

