/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.tag;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.outerj.daisy.diff.tag.Atom;
import org.outerj.daisy.diff.tag.DelimiterAtom;
import org.outerj.daisy.diff.tag.IAtomSplitter;
import org.outerj.daisy.diff.tag.TextAtom;

public class ArgumentComparator
implements IAtomSplitter {
    private List<Atom> atoms = new ArrayList<Atom>(5);

    public ArgumentComparator(String string) {
        this.generateAtoms(string);
    }

    private void generateAtoms(String string) {
        if (this.atoms.size() > 0) {
            throw new IllegalStateException("Atoms can only be generated once");
        }
        StringBuilder stringBuilder = new StringBuilder(30);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<' || c == '>') {
                if (stringBuilder.length() > 0) {
                    this.atoms.add(new TextAtom(stringBuilder.toString()));
                    stringBuilder.setLength(0);
                }
                this.atoms.add(new TextAtom("" + c));
                stringBuilder.setLength(0);
                continue;
            }
            if (DelimiterAtom.isValidDelimiter("" + c)) {
                if (stringBuilder.length() > 0) {
                    this.atoms.add(new TextAtom(stringBuilder.toString()));
                    stringBuilder.setLength(0);
                }
                this.atoms.add(new DelimiterAtom(c));
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            this.atoms.add(new TextAtom(stringBuilder.toString()));
            stringBuilder.setLength(0);
        }
    }

    @Override
    public Atom getAtom(int n) {
        if (n < 0 || n >= this.atoms.size()) {
            throw new IndexOutOfBoundsException("There is no Atom with index " + n);
        }
        return this.atoms.get(n);
    }

    @Override
    public int getRangeCount() {
        return this.atoms.size();
    }

    @Override
    public boolean rangesEqual(int n, IRangeComparator iRangeComparator, int n2) {
        ArgumentComparator argumentComparator;
        try {
            argumentComparator = (ArgumentComparator)iRangeComparator;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return argumentComparator.getAtom(n2).equalsIdentifier(this.getAtom(n));
    }

    @Override
    public boolean skipRangeComparison(int n, int n2, IRangeComparator iRangeComparator) {
        return false;
    }

    @Override
    public String substring(int n, int n2) {
        if (n == n2) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(this.atoms.get(i).getFullText());
        }
        return stringBuilder.toString();
    }

    @Override
    public String substring(int n) {
        return this.substring(n, this.atoms.size());
    }
}

