/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.ECoord;
import com.sun.electric.util.math.GenMath;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;

public class ImmutableArcInst
extends ImmutableElectricObject {
    public static final int TAILEND = 0;
    public static final int HEADEND = 1;
    public static final Variable.Key ARC_RADIUS = Variable.newKey("ARC_radius");
    private static final int MAX_EXTEND = 0xFFFFFFF;
    public static final int DEFAULTANGLE = -1;
    private static final int ELIB_FIXED = 1;
    private static final int ELIB_FIXANG = 2;
    private static final int ELIB_AANGLE = 16352;
    private static final int ELIB_AANGLESH = 5;
    private static final int ELIB_ISHEADNEGATED = 65536;
    private static final int ELIB_NOEXTEND = 131072;
    private static final int ELIB_ISTAILNEGATED = 262144;
    private static final int ELIB_ISDIRECTIONAL = 524288;
    private static final int ELIB_NOTEND0 = 0x100000;
    private static final int ELIB_NOTEND1 = 0x200000;
    private static final int ELIB_REVERSEEND = 0x400000;
    private static final int ELIB_CANTSLIDE = 0x800000;
    private static final int ELIB_HARDSELECTA = Integer.MIN_VALUE;
    private static final int TAIL_ARROWED_MASK = 1;
    private static final int HEAD_ARROWED_MASK = 2;
    private static final int TAIL_EXTENDED_MASK = 4;
    private static final int HEAD_EXTENDED_MASK = 8;
    private static final int TAIL_NEGATED_MASK = 16;
    private static final int HEAD_NEGATED_MASK = 32;
    private static final int BODY_ARROWED_MASK = 64;
    private static final int RIGID_MASK = 128;
    private static final int FIXED_ANGLE_MASK = 256;
    private static final int SLIDABLE_MASK = 512;
    private static final int HARD_SELECT_MASK = 1024;
    private static final int DATABASE_FLAGS = 2047;
    private static final int MANHATTAN_MASK = 2048;
    public static final Flag RIGID = new Flag(128, 'R', false);
    public static final Flag FIXED_ANGLE = new Flag(256, 'F', true);
    public static final Flag SLIDABLE = new Flag(512, 'S', false);
    public static final Flag TAIL_ARROWED = new Flag(1, 'Y', false);
    public static final Flag HEAD_ARROWED = new Flag(2, 'X', false);
    public static final Flag BODY_ARROWED = new Flag(64, 'B', false);
    public static final Flag TAIL_EXTENDED = new Flag(4, 'J', true);
    public static final Flag HEAD_EXTENDED = new Flag(8, 'I', true);
    public static final Flag TAIL_NEGATED = new Flag(16, 'N', false);
    public static final Flag HEAD_NEGATED = new Flag(32, 'G', false);
    public static final Flag HARD_SELECT = new Flag(1024, 'A', false);
    public static final int DEFAULT_FLAGS = ImmutableArcInst.SLIDABLE.mask | ImmutableArcInst.HEAD_EXTENDED.mask | ImmutableArcInst.TAIL_EXTENDED.mask;
    public static final int FACTORY_DEFAULT_FLAGS = ImmutableArcInst.FIXED_ANGLE.mask | ImmutableArcInst.SLIDABLE.mask | ImmutableArcInst.HEAD_EXTENDED.mask | ImmutableArcInst.TAIL_EXTENDED.mask;
    public static final Name BASENAME = Name.findName("net@0");
    public static final ImmutableArcInst[] NULL_ARRAY = new ImmutableArcInst[0];
    public final int arcId;
    public final ArcProtoId protoId;
    public final Name name;
    public final TextDescriptor nameDescriptor;
    public final int tailNodeId;
    public final PortProtoId tailPortId;
    public final EPoint tailLocation;
    public final int headNodeId;
    public final PortProtoId headPortId;
    public final EPoint headLocation;
    private final int gridExtendOverMin;
    private final short angle;
    public static final Comparator<ImmutableArcInst> ARCS_ORDER = new Comparator<ImmutableArcInst>(){

        @Override
        public int compare(ImmutableArcInst a1, ImmutableArcInst a2) {
            int cmp = Name.STRING_NUMBER_ORDER.compare(a1.name, a2.name);
            if (cmp != 0) {
                return cmp;
            }
            return a1.arcId < a2.arcId ? -1 : (a1.arcId > a2.arcId ? 1 : 0);
        }
    };

    ImmutableArcInst(int arcId, ArcProtoId protoId, Name name, TextDescriptor nameDescriptor, int tailNodeId, PortProtoId tailPortId, EPoint tailLocation, int headNodeId, PortProtoId headPortId, EPoint headLocation, int gridExtendOverMin, short angle, int flags, Variable[] vars) {
        super(vars, flags);
        this.arcId = arcId;
        this.protoId = protoId;
        this.name = name;
        this.nameDescriptor = nameDescriptor;
        this.tailNodeId = tailNodeId;
        this.tailPortId = tailPortId;
        this.tailLocation = tailLocation;
        this.headNodeId = headNodeId;
        this.headPortId = headPortId;
        this.headLocation = headLocation;
        this.gridExtendOverMin = gridExtendOverMin;
        this.angle = angle;
    }

    public boolean isUsernamed() {
        return !this.name.isTempname();
    }

    public ECoord getCoordExtendOverMin() {
        return ECoord.fromGrid(this.getGridExtendOverMin());
    }

    public double getLambdaExtendOverMin() {
        return DBMath.gridToLambda(this.getGridExtendOverMin());
    }

    public long getFixpExtendOverMin() {
        return (long)this.gridExtendOverMin << 20;
    }

    public long getGridExtendOverMin() {
        return this.gridExtendOverMin;
    }

    public double getLambdaLength() {
        return this.tailLocation.lambdaDistance(this.headLocation);
    }

    public double getGridLength() {
        return this.tailLocation.gridDistance(this.headLocation);
    }

    public boolean isZeroLength() {
        return this.tailLocation.equals(this.headLocation);
    }

    public int getAngle() {
        return this.angle;
    }

    public int getDefinedAngle() {
        if (this.angle == -1) {
            return 0;
        }
        return this.angle;
    }

    public int getOppositeAngle() {
        if (this.angle == -1) {
            return this.angle;
        }
        return this.angle >= 1800 ? this.angle - 1800 : this.angle + 1800;
    }

    public boolean is(Flag flag) {
        return (this.flags & flag.mask) != 0;
    }

    public boolean isRigid() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isFixedAngle() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isSlidable() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isHardSelect() {
        return (this.flags & 0x400) != 0;
    }

    public boolean isArrowed(int connIndex) {
        if ((connIndex & 0xFFFFFFFE) != 0) {
            throw new IllegalArgumentException("Bad end " + connIndex);
        }
        return (this.flags >> connIndex & 1) != 0;
    }

    public boolean isTailArrowed() {
        return (this.flags & 1) != 0;
    }

    public boolean isHeadArrowed() {
        return (this.flags & 2) != 0;
    }

    public boolean isBodyArrowed() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isExtended(int connIndex) {
        if ((connIndex & 0xFFFFFFFE) != 0) {
            throw new IllegalArgumentException("Bad end " + connIndex);
        }
        return (this.flags >> connIndex & 4) != 0;
    }

    public boolean isTailExtended() {
        return (this.flags & 4) != 0;
    }

    public boolean isHeadExtended() {
        return (this.flags & 8) != 0;
    }

    public boolean isNegated(int connIndex) {
        if ((connIndex & 0xFFFFFFFE) != 0) {
            throw new IllegalArgumentException("Bad end " + connIndex);
        }
        return (this.flags >> connIndex & 0x10) != 0;
    }

    public boolean isTailNegated() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isHeadNegated() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isManhattan() {
        return (this.flags & 0x800) != 0;
    }

    private static int updateManhattan(int flags, EPoint headLocation, EPoint tailLocation, int angle) {
        return ImmutableArcInst.isManhattan(headLocation, tailLocation, angle) ? flags | 0x800 : flags & 0xFFFFF7FF;
    }

    private static boolean isManhattan(EPoint headLocation, EPoint tailLocation, int angle) {
        if (headLocation.getGridX() == tailLocation.getGridX()) {
            return headLocation.getGridY() != tailLocation.getGridY() || angle == -1 || angle == 0 || angle == 900 || angle == 1800 || angle == 2700;
        }
        return tailLocation.getGridY() == headLocation.getGridY();
    }

    public static ImmutableArcInst newInstance(int arcId, ArcProtoId protoId, Name name, TextDescriptor nameDescriptor, int tailNodeId, PortProtoId tailPortId, EPoint tailLocation, int headNodeId, PortProtoId headPortId, EPoint headLocation, long gridExtendOverMin, int angle, int flags) {
        if (arcId < 0) {
            throw new IllegalArgumentException("arcId");
        }
        if (protoId == null) {
            throw new NullPointerException("protoId");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.isValid() || name.hasEmptySubnames() || name.isTempname() && (name.getBasename() != BASENAME || name.isBus())) {
            throw new IllegalArgumentException("name");
        }
        if (nameDescriptor != null) {
            nameDescriptor = nameDescriptor.withoutParam();
        }
        if (tailNodeId < 0) {
            throw new IllegalArgumentException("tailNodeId");
        }
        if (tailPortId == null) {
            throw new NullPointerException("tailPortId");
        }
        if (tailLocation == null) {
            throw new NullPointerException("tailLocation");
        }
        if (headNodeId < 0) {
            throw new IllegalArgumentException("headNodeId");
        }
        if (headPortId == null) {
            throw new NullPointerException("headPortId");
        }
        if (headLocation == null) {
            throw new NullPointerException("headLocation");
        }
        if (gridExtendOverMin <= -268435455L || gridExtendOverMin >= 0xFFFFFFFL) {
            throw new IllegalArgumentException("gridExtendOverMin");
        }
        int intGridExtendOverMin = (int)gridExtendOverMin;
        if (angle < -1 || angle >= 3600) {
            throw new IllegalArgumentException("angle");
        }
        short shortAngle = ImmutableArcInst.updateAngle((short)angle, tailLocation, headLocation);
        flags &= 0x7FF;
        if (!(tailPortId instanceof PrimitivePortId)) {
            flags &= 0xFFFFFFEF;
        }
        if (!(headPortId instanceof PrimitivePortId)) {
            flags &= 0xFFFFFFDF;
        }
        flags = ImmutableArcInst.updateManhattan(flags, headLocation, tailLocation, angle);
        return new ImmutableArcInst(arcId, protoId, name, nameDescriptor, tailNodeId, tailPortId, tailLocation, headNodeId, headPortId, headLocation, intGridExtendOverMin, shortAngle, flags, Variable.NULL_ARRAY);
    }

    public ImmutableArcInst withArcId(int arcId) {
        if (this.arcId == arcId) {
            return this;
        }
        if (arcId < 0) {
            throw new IllegalArgumentException("arcId");
        }
        return new ImmutableArcInst(arcId, this.protoId, this.name, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.gridExtendOverMin, this.angle, this.flags, this.getVars());
    }

    public ImmutableArcInst withName(Name name) {
        if (this.name.toString().equals(name.toString())) {
            return this;
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.isValid() || name.hasEmptySubnames() || name.isTempname() && (name.getBasename() != BASENAME || name.isBus())) {
            throw new IllegalArgumentException("name");
        }
        return new ImmutableArcInst(this.arcId, this.protoId, name, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.gridExtendOverMin, this.angle, this.flags, this.getVars());
    }

    public ImmutableArcInst withNameDescriptor(TextDescriptor nameDescriptor) {
        if (nameDescriptor != null) {
            nameDescriptor = nameDescriptor.withoutParam();
        }
        if (this.nameDescriptor == nameDescriptor) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoId, this.name, nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.gridExtendOverMin, this.angle, this.flags, this.getVars());
    }

    public ImmutableArcInst withConnections(int tailNodeId, PortProtoId tailPortId, int headNodeId, PortProtoId headPortId) {
        if (tailNodeId < 0) {
            throw new IllegalArgumentException("tailNodeId");
        }
        if (tailPortId == null) {
            throw new NullPointerException("tailPortId");
        }
        if (headNodeId < 0) {
            throw new IllegalArgumentException("headNodeId");
        }
        if (headPortId == null) {
            throw new NullPointerException("headPortId");
        }
        if (this.tailNodeId == tailNodeId && this.tailPortId == tailPortId && this.headNodeId == headNodeId && this.headPortId == headPortId) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoId, this.name, this.nameDescriptor, tailNodeId, tailPortId, this.tailLocation, headNodeId, headPortId, this.headLocation, this.gridExtendOverMin, this.angle, this.flags, this.getVars());
    }

    public ImmutableArcInst withLocations(EPoint tailLocation, EPoint headLocation) {
        if (this.tailLocation.equals(tailLocation) && this.headLocation.equals(headLocation)) {
            return this;
        }
        if (tailLocation == null) {
            throw new NullPointerException("tailLocation");
        }
        if (headLocation == null) {
            throw new NullPointerException("headLocation");
        }
        short angle = ImmutableArcInst.updateAngle(this.angle, tailLocation, headLocation);
        int flags = ImmutableArcInst.updateManhattan(this.flags, headLocation, tailLocation, angle);
        return new ImmutableArcInst(this.arcId, this.protoId, this.name, this.nameDescriptor, this.tailNodeId, this.tailPortId, tailLocation, this.headNodeId, this.headPortId, headLocation, this.gridExtendOverMin, angle, flags, this.getVars());
    }

    public ImmutableArcInst withGridExtendOverMin(long gridExtendOverMin) {
        if ((long)this.gridExtendOverMin == gridExtendOverMin) {
            return this;
        }
        if (gridExtendOverMin <= -268435455L || gridExtendOverMin >= 0xFFFFFFFL) {
            throw new IllegalArgumentException("gridWidth");
        }
        return new ImmutableArcInst(this.arcId, this.protoId, this.name, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, (int)gridExtendOverMin, this.angle, this.flags, this.getVars());
    }

    public ImmutableArcInst withAngle(int angle) {
        if (!this.tailLocation.equals(this.headLocation)) {
            return this;
        }
        if (angle < -1 || angle >= 3600) {
            throw new IllegalArgumentException("angle");
        }
        if (this.angle == angle) {
            return this;
        }
        short shortAngle = (short)angle;
        int flags = ImmutableArcInst.updateManhattan(this.flags, this.headLocation, this.tailLocation, shortAngle);
        return new ImmutableArcInst(this.arcId, this.protoId, this.name, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.gridExtendOverMin, shortAngle, flags, this.getVars());
    }

    public ImmutableArcInst withFlags(int flags) {
        flags &= 0x7FF;
        if (!(this.tailPortId instanceof PrimitivePortId)) {
            flags &= 0xFFFFFFEF;
        }
        if (!(this.headPortId instanceof PrimitivePortId)) {
            flags &= 0xFFFFFFDF;
        }
        if ((this.flags & 0x7FF) == flags) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoId, this.name, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.gridExtendOverMin, this.angle, flags |= this.flags & 0x800, this.getVars());
    }

    public ImmutableArcInst withFlag(Flag flag, boolean value2) {
        return this.withFlags(flag.set(this.flags, value2));
    }

    public ImmutableArcInst withVariable(Variable var) {
        Variable[] vars = this.arrayWithVariable(var.withParam(false).withInherit(false));
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoId, this.name, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.gridExtendOverMin, this.angle, this.flags, vars);
    }

    public ImmutableArcInst withoutVariable(Variable.Key key) {
        Variable[] vars = this.arrayWithoutVariable(key);
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoId, this.name, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.gridExtendOverMin, this.angle, this.flags, vars);
    }

    ImmutableArcInst withRenamedIds(IdMapper idMapper) {
        Variable[] vars = this.arrayWithRenamedIds(idMapper);
        PortProtoId tailPortId = this.tailPortId;
        PortProtoId headPortId = this.headPortId;
        if (tailPortId instanceof ExportId) {
            tailPortId = idMapper.get((ExportId)tailPortId);
        }
        if (headPortId instanceof ExportId) {
            headPortId = idMapper.get((ExportId)headPortId);
        }
        if (this.getVars() == vars && this.tailPortId == tailPortId && this.headPortId == headPortId) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoId, this.name, this.nameDescriptor, this.tailNodeId, tailPortId, this.tailLocation, this.headNodeId, headPortId, this.headLocation, this.gridExtendOverMin, this.angle, this.flags, vars);
    }

    private static short updateAngle(short angle, EPoint tailLocation, EPoint headLocation) {
        if (tailLocation.equals(headLocation)) {
            return angle;
        }
        return (short)GenMath.figureAngle(headLocation.getGridX() - tailLocation.getGridX(), headLocation.getGridY() - tailLocation.getGridY());
    }

    @Override
    void write(IdWriter writer) throws IOException {
        writer.writeArcId(this.arcId);
        writer.writeArcProtoId(this.protoId);
        writer.writeNameKey(this.name);
        writer.writeTextDescriptor(this.nameDescriptor);
        writer.writeNodeId(this.tailNodeId);
        writer.writePortProtoId(this.tailPortId);
        writer.writePoint(this.tailLocation);
        writer.writeNodeId(this.headNodeId);
        writer.writePortProtoId(this.headPortId);
        writer.writePoint(this.headLocation);
        writer.writeInt(this.gridExtendOverMin);
        writer.writeShort(this.angle);
        writer.writeInt(this.flags);
        super.write(writer);
    }

    static ImmutableArcInst read(IdReader reader) throws IOException {
        int arcId = reader.readNodeId();
        ArcProtoId protoId = reader.readArcProtoId();
        Name name = reader.readNameKey();
        TextDescriptor nameDescriptor = reader.readTextDescriptor();
        int tailNodeId = reader.readNodeId();
        PortProtoId tailPortId = reader.readPortProtoId();
        EPoint tailLocation = reader.readPoint();
        int headNodeId = reader.readNodeId();
        PortProtoId headPortId = reader.readPortProtoId();
        EPoint headLocation = reader.readPoint();
        int gridExtendOverMin = reader.readInt();
        short angle = reader.readShort();
        int flags = reader.readInt();
        boolean hasVars = reader.readBoolean();
        Variable[] vars = hasVars ? ImmutableArcInst.readVars(reader) : Variable.NULL_ARRAY;
        return new ImmutableArcInst(arcId, protoId, name, nameDescriptor, tailNodeId, tailPortId, tailLocation, headNodeId, headPortId, headLocation, gridExtendOverMin, ImmutableArcInst.updateAngle(angle, tailLocation, headLocation), flags, vars);
    }

    @Override
    public int hashCodeExceptVariables() {
        return this.arcId;
    }

    @Override
    public boolean equalsExceptVariables(ImmutableElectricObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableArcInst)) {
            return false;
        }
        ImmutableArcInst that = (ImmutableArcInst)o;
        return this.arcId == that.arcId && this.protoId == that.protoId && this.name == that.name && this.nameDescriptor == that.nameDescriptor && this.tailNodeId == that.tailNodeId && this.tailPortId == that.tailPortId && this.tailLocation.equals(that.tailLocation) && this.headNodeId == that.headNodeId && this.headPortId == that.headPortId && this.headLocation.equals(that.headLocation) && this.gridExtendOverMin == that.gridExtendOverMin && this.angle == that.angle && this.flags == that.flags;
    }

    public void makeGridBox(long[] gridCoords, boolean tailExtended, boolean headExtended, long gridExtend) {
        long hy;
        long hx;
        long ly;
        long lx;
        assert (gridExtend > 0L);
        long et = tailExtended ? gridExtend : 0L;
        long eh = headExtended ? gridExtend : 0L;
        switch (this.angle) {
            case -1: 
            case 0: {
                long m = this.tailLocation.getGridY();
                lx = this.tailLocation.getGridX() - et;
                ly = m - gridExtend;
                hx = this.headLocation.getGridX() + eh;
                hy = m + gridExtend;
                break;
            }
            case 900: {
                long m = this.tailLocation.getGridX();
                lx = m - gridExtend;
                ly = this.tailLocation.getGridY() - et;
                hx = m + gridExtend;
                hy = this.headLocation.getGridY() + eh;
                break;
            }
            case 1800: {
                long m = this.tailLocation.getGridY();
                lx = this.headLocation.getGridX() - eh;
                ly = m - gridExtend;
                hx = this.tailLocation.getGridX() + et;
                hy = m + gridExtend;
                break;
            }
            case 2700: {
                long m = this.tailLocation.getGridX();
                lx = m - gridExtend;
                ly = this.headLocation.getGridY() - eh;
                hx = m + gridExtend;
                hy = this.tailLocation.getGridY() + et;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        gridCoords[0] = lx;
        gridCoords[1] = ly;
        gridCoords[2] = hx;
        gridCoords[3] = hy;
    }

    public void makeFixpBox(long[] fixpCoords, boolean tailExtended, boolean headExtended, long gridExtend) {
        long hy;
        long hx;
        long ly;
        long lx;
        assert (gridExtend > 0L);
        long et = tailExtended ? gridExtend : 0L;
        long eh = headExtended ? gridExtend : 0L;
        switch (this.angle) {
            case -1: 
            case 0: {
                long m = this.tailLocation.getGridY();
                lx = this.tailLocation.getGridX() - et;
                ly = m - gridExtend;
                hx = this.headLocation.getGridX() + eh;
                hy = m + gridExtend;
                break;
            }
            case 900: {
                long m = this.tailLocation.getGridX();
                lx = m - gridExtend;
                ly = this.tailLocation.getGridY() - et;
                hx = m + gridExtend;
                hy = this.headLocation.getGridY() + eh;
                break;
            }
            case 1800: {
                long m = this.tailLocation.getGridY();
                lx = this.headLocation.getGridX() - eh;
                ly = m - gridExtend;
                hx = this.tailLocation.getGridX() + et;
                hy = m + gridExtend;
                break;
            }
            case 2700: {
                long m = this.tailLocation.getGridX();
                lx = m - gridExtend;
                ly = this.headLocation.getGridY() - eh;
                hx = m + gridExtend;
                hy = this.tailLocation.getGridY() + et;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        fixpCoords[0] = lx << 20;
        fixpCoords[1] = ly << 20;
        fixpCoords[2] = hx << 20;
        fixpCoords[3] = hy << 20;
    }

    public Double getRadius() {
        Variable var = this.getVar(ARC_RADIUS);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Integer) {
            return new Double((double)((Integer)obj).intValue() / 2000.0);
        }
        return null;
    }

    public boolean check(TechPool techPool) {
        Technology tech;
        ArcProto protoType = techPool.getArcProto(this.protoId);
        if (protoType == null) {
            return false;
        }
        if (this.name.isBus() && (!((tech = protoType.getTechnology()) instanceof Schematics) || protoType != ((Schematics)tech).bus_arc)) {
            return false;
        }
        if (this.isTailNegated()) {
            if (!techPool.getPrimitivePort((PrimitivePortId)this.tailPortId).isNegatable()) {
                return false;
            }
            if (protoType.getTechnology().isNoNegatedArcs()) {
                return false;
            }
        }
        if (this.isHeadNegated()) {
            if (!techPool.getPrimitivePort((PrimitivePortId)this.headPortId).isNegatable()) {
                return false;
            }
            if (protoType.getTechnology().isNoNegatedArcs()) {
                return false;
            }
        }
        return true;
    }

    public void check() {
        super.check(false);
        assert (this.arcId >= 0);
        assert (this.protoId != null);
        assert (this.name != null);
        assert (this.name.isValid() && !this.name.hasEmptySubnames());
        if (this.name.isTempname()) assert (this.name.getBasename() == BASENAME && !this.name.isBus());
        if (this.nameDescriptor != null) assert (!this.nameDescriptor.isParam());
        assert (this.tailNodeId >= 0);
        assert (this.tailPortId != null);
        assert (this.tailLocation != null);
        assert (this.headNodeId >= 0);
        assert (this.headPortId != null);
        assert (this.headLocation != null);
        assert (-268435455 < this.gridExtendOverMin && this.gridExtendOverMin < 0xFFFFFFF);
        assert ((this.flags & 0xFFFFF000) == 0);
        assert (this.isManhattan() == ImmutableArcInst.isManhattan(this.headLocation, this.tailLocation, this.angle));
        if (this.isTailNegated()) assert (this.tailPortId instanceof PrimitivePortId);
        if (this.isHeadNegated()) assert (this.headPortId instanceof PrimitivePortId);
        assert (-1 <= this.angle && this.angle < 3600);
        if (!this.tailLocation.equals(this.headLocation)) assert (this.angle == GenMath.figureAngle(this.headLocation.getGridX() - this.tailLocation.getGridX(), this.headLocation.getGridY() - this.tailLocation.getGridY()));
    }

    static void checkList(Iterable list2) {
        ImmutableArcInst prevA = null;
        for (ImmutableArcInst a : list2) {
            a.check();
            if (prevA != null) {
                int cmp = TextUtils.STRING_NUMBER_ORDER.compare(prevA.name.toString(), a.name.toString());
                assert (cmp <= 0);
                if (cmp == 0) {
                    assert (!a.name.isTempname());
                    assert (prevA.arcId < a.arcId);
                }
            }
            prevA = a;
        }
    }

    public int getElibBits() {
        int elibAngle;
        boolean normalEnd;
        int elibBits = 0;
        if (this.isRigid()) {
            elibBits |= 1;
        }
        if (this.isFixedAngle()) {
            elibBits |= 2;
        }
        if (!this.isSlidable()) {
            elibBits |= 0x800000;
        }
        if (this.isHardSelect()) {
            elibBits |= Integer.MIN_VALUE;
        }
        if (!this.isHeadExtended() || !this.isTailExtended()) {
            elibBits |= 0x20000;
            if (this.isHeadExtended() != this.isTailExtended()) {
                if (this.isTailExtended()) {
                    elibBits |= 0x100000;
                }
                if (this.isHeadExtended()) {
                    elibBits |= 0x200000;
                }
            }
        }
        if (this.isHeadArrowed() || this.isTailArrowed() || this.isBodyArrowed()) {
            elibBits |= 0x80000;
            if (this.isTailArrowed()) {
                elibBits |= 0x400000;
            }
            if (!this.isHeadArrowed() && !this.isTailArrowed()) {
                elibBits |= 0x200000;
            }
        }
        boolean bl = normalEnd = (elibBits & 0x400000) == 0;
        if (this.isTailNegated()) {
            elibBits |= normalEnd ? 262144 : 65536;
        }
        if (this.isHeadNegated()) {
            elibBits |= normalEnd ? 65536 : 262144;
        }
        if ((elibAngle = (this.angle + 5) / 10) >= 360) {
            elibAngle -= 360;
        }
        return elibBits | elibAngle << 5;
    }

    public static int flagsFromElib(int elibBits) {
        int newBits = 0;
        if ((elibBits & 1) != 0) {
            newBits |= ImmutableArcInst.RIGID.mask;
        }
        if ((elibBits & 2) != 0) {
            newBits |= ImmutableArcInst.FIXED_ANGLE.mask;
        }
        if ((elibBits & 0x800000) == 0) {
            newBits |= ImmutableArcInst.SLIDABLE.mask;
        }
        if ((elibBits & Integer.MIN_VALUE) != 0) {
            newBits |= ImmutableArcInst.HARD_SELECT.mask;
        }
        if ((elibBits & 0x40000) != 0) {
            newBits |= (elibBits & 0x400000) == 0 ? ImmutableArcInst.TAIL_NEGATED.mask : ImmutableArcInst.HEAD_NEGATED.mask;
        }
        if ((elibBits & 0x10000) != 0) {
            newBits |= (elibBits & 0x400000) == 0 ? ImmutableArcInst.HEAD_NEGATED.mask : ImmutableArcInst.TAIL_NEGATED.mask;
        }
        if ((elibBits & 0x20000) != 0) {
            if ((elibBits & 0x100000) != 0) {
                newBits |= ImmutableArcInst.TAIL_EXTENDED.mask;
            }
            if ((elibBits & 0x200000) != 0) {
                newBits |= ImmutableArcInst.HEAD_EXTENDED.mask;
            }
        } else {
            newBits |= ImmutableArcInst.TAIL_EXTENDED.mask | ImmutableArcInst.HEAD_EXTENDED.mask;
        }
        if ((elibBits & 0x80000) != 0) {
            newBits |= ImmutableArcInst.BODY_ARROWED.mask;
            if ((elibBits & 0x400000) == 0) {
                if ((elibBits & 0x200000) == 0) {
                    newBits |= ImmutableArcInst.HEAD_ARROWED.mask;
                }
            } else if ((elibBits & 0x100000) == 0) {
                newBits |= ImmutableArcInst.TAIL_ARROWED.mask;
            }
        }
        return newBits;
    }

    public static int angleFromElib(int elibBits) {
        int angle = (elibBits & 0x3FE0) >> 5;
        return angle % 360 * 10;
    }

    public static interface Iterable
    extends java.lang.Iterable<ImmutableArcInst> {
        public boolean isEmpty();

        public int size();

        public ImmutableArcInst get(int var1);

        @Override
        public Iterator<ImmutableArcInst> iterator();

        public int searchByName(String var1);
    }

    public static class Flag {
        final int mask;
        final char jelibChar;
        final boolean jelibDefault;

        private Flag(int mask, char jelibChar, boolean jelibDefault) {
            this.mask = mask;
            this.jelibChar = jelibChar;
            this.jelibDefault = jelibDefault;
        }

        public boolean is(int userBits) {
            return (userBits & this.mask) != 0;
        }

        public int set(int userBits, boolean value2) {
            return value2 ? userBits | this.mask : userBits & ~this.mask;
        }
    }
}

