/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.drc.Quick;
import com.sun.electric.tool.drc.Schematic;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.ECoord;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DRCTest
extends AbstractTest {
    public DRCTest(String name) {
        super(name);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new DRCTest("Primitive"));
        list.add(new DRCTest("Layout1"));
        list.add(new DRCTest("Layout2"));
        list.add(new DRCTest("Schematic1"));
        list.add(new DRCTest("Schematic2"));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/DRC/output/";
    }

    public Boolean Primitive() {
        this.createMessageOutput();
        return DRCTest.primitiveTechTest();
    }

    public static Boolean primitiveTechTest() {
        Boolean passed = Boolean.TRUE;
        if (!DRCTest.testDRCRules("mocmos", "MOSIS", 20, 20, 8)) {
            passed = Boolean.FALSE;
        }
        return passed;
    }

    public static boolean testDRCRules(String techName, String foundryName, int ERROR_DEFAULT, int ERROR_EXHAUSTIVE, int ERROR_CELL) {
        Technology tech = DRCTest.setFoundry(Technology.findTechnology(techName), foundryName);
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        Cell gallery = DRCTest.builTechLibrary(tech, foundryName, ep);
        return DRCTest.basicDRCLayoutTestInternal(gallery, ERROR_DEFAULT, 0, ERROR_EXHAUSTIVE, 0, ERROR_CELL, 0, false, DRC.DRCCheckMinArea.AREA_LOCAL);
    }

    private static Cell builTechLibrary(Technology tech, String foundryName, EditingPreferences ep) {
        Library lib = Library.newInstance(tech.getTechName() + "-" + foundryName, null);
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        Technology theTech = DRCTest.setFoundry(tech, foundryName);
        Iterator<PrimitiveNode> it = theTech.getNodes();
        block0: while (it.hasNext()) {
            PrimitiveNode pnp = it.next();
            if (pnp.isNotUsed()) continue;
            boolean first = true;
            double xS = pnp.getDefWidth(ep) * 2.0;
            double yS = pnp.getDefHeight(ep) * 2.0;
            if (xS < 3.0) {
                xS = 3.0;
            }
            if (yS < 3.0) {
                yS = 3.0;
            }
            double nodeXPos = -xS * 2.0;
            Point2D[] pos = new Point2D[]{new Point2D.Double(nodeXPos - xS, -5.0 + yS), new Point2D.Double(nodeXPos + xS, -5.0 + yS), new Point2D.Double(nodeXPos - xS, -5.0 - yS), new Point2D.Double(nodeXPos + xS, -5.0 - yS)};
            SizeOffset so = pnp.getProtoSizeOffset();
            xS = pnp.getDefWidth(ep) - so.getLowXOffset() - so.getHighXOffset();
            yS = pnp.getDefHeight(ep) - so.getLowYOffset() - so.getHighYOffset();
            double[] xsc = new double[4];
            double[] ysc = new double[4];
            xsc[0] = xS * 1.0;
            ysc[0] = yS * 1.0;
            xsc[1] = xS * 2.0;
            ysc[1] = yS * 1.0;
            xsc[2] = xS * 1.0;
            ysc[2] = yS * 2.0;
            xsc[3] = xS * 2.0;
            ysc[3] = yS * 2.0;
            if (pnp.isMulticut()) {
                EPoint min2size = pnp.getMulticut2Size();
                double min2X = min2size.getLambdaX();
                double min2Y = min2size.getLambdaY();
                xsc[1] = min2X;
                xsc[3] = min2X;
                ysc[2] = min2Y;
                ysc[3] = min2Y;
            }
            Cell nNp = null;
            for (int e = 0; e < 4; ++e) {
                if (e != 0 && first || pnp.isSquare() && (e == 1 || e == 2)) continue;
                double newXSize = xsc[e] + so.getLowXOffset() + so.getHighXOffset();
                double newYSize = ysc[e] + so.getLowYOffset() + so.getHighYOffset();
                if (first) {
                    first = false;
                    String fName = "node-" + pnp.getName() + "{lay}";
                    if (lib.findNodeProto(fName) != null) {
                        System.out.println("Warning: multiple nodes named '" + fName + "'");
                        continue block0;
                    }
                    nNp = Cell.makeInstance(ep, lib, fName);
                    cellList.add(nNp);
                    if (nNp == null) {
                        return null;
                    }
                }
                NodeInst.makeInstance(pnp, ep, EPoint.snap(pos[e]), newXSize, newYSize, nNp);
            }
        }
        Cell gallery = Cell.newInstance(lib, "gallery{lay}");
        NodeInst ni = null;
        double y = 0.0;
        for (Cell c : cellList) {
            if (ni != null) {
                y += ni.getBounds().getHeight() * 1.5;
            }
            ni = LayoutLib.newNodeInst(c, ep, c.getBounds().getWidth(), y += c.getBounds().getHeight(), 0.0, 0.0, 0.0, gallery);
        }
        return gallery;
    }

    public Boolean Layout1() {
        this.createMessageOutput();
        if (DRCTest.basicDRCTest(Technology.getMocmosTechnology(), Foundry.Type.MOSIS, this.getRegressionPath() + "/data/qThree", "qThreeTop", "qThreeTop.jelib", 4739, 0, 5027, 0, 810, 0, false, DRC.DRCCheckMinArea.AREA_LOCAL)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean Layout2() {
        this.createMessageOutput();
        if (DRCTest.basicDRCTest(Technology.getMocmosTechnology(), Foundry.Type.MOSIS, this.getRegressionPath() + "/data/muddChip", "chip", "MIPS.jelib", 532012, 4444, 759286, 4444, 189, 4444, false, DRC.DRCCheckMinArea.AREA_LOCAL)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean basicDRCTest(Technology tech, Foundry.Type foundry, String regressiondata, String testCell, String testlib, int ERROR_DEFAULT, int WARN_DEFAULT, int ERROR_EXHAUSTIVE, int WARN_EXHAUSTIVE, int ERROR_CELL, int WARN_CELL, boolean checkArea, DRC.DRCCheckMinArea areaAlgo) {
        Cell lay = DRCTest.getCellToDRC(tech, foundry, regressiondata, testCell, testlib);
        return DRCTest.basicDRCLayoutTestInternal(lay, ERROR_DEFAULT, WARN_DEFAULT, ERROR_EXHAUSTIVE, WARN_EXHAUSTIVE, ERROR_CELL, WARN_CELL, checkArea, areaAlgo);
    }

    private static Cell getCellToDRC(Technology tech, Foundry.Type foundry, String regressiondata, String testcell, String testlib) {
        DRCTest.setFoundry(tech, foundry.getName());
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        Library rootLib = LayoutLib.openLibForRead(regressiondata + "/" + testlib, ep, true);
        View view = View.LAYOUT;
        Cell lay = rootLib.findNodeProto(testcell + view.getAbbreviationExtension());
        return lay;
    }

    public Boolean Schematic1() {
        this.createMessageOutput();
        if (DRCTest.basicDRCSchematicTest(this.getRegressionPath() + "/data/qThree", "qThreeTop", "qThreeTop.jelib", 1050, 2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean Schematic2() {
        this.createMessageOutput();
        if (DRCTest.basicDRCSchematicTest(this.getRegressionPath() + "/data/muddChip", "chip", "MIPS.jelib", 195, 0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean basicDRCSchematicTest(String regressiondata, String testcell, String testlib, int ERROR_DEFAULT, int WARN_DEFAULT) {
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        LayoutLib.openLibForRead(regressiondata + "/" + testlib, ep, true);
        Library.repairAllLibraries(ep);
        URL fileURL = TextUtils.makeURLToFile(testlib);
        String libName = TextUtils.getFileNameWithoutExtension(fileURL);
        Library rootLib = Library.findLibrary(libName);
        View view = View.SCHEMATIC;
        Cell schematic = rootLib.findNodeProto(testcell + view.getAbbreviationExtension());
        return DRCTest.basicDRCSchematicTestInternal(schematic, ERROR_DEFAULT, WARN_DEFAULT);
    }

    private static boolean basicDRCSchematicTestInternal(Cell schematic, int ERROR_DEFAULT, int WARN_DEFAULT) {
        boolean good;
        int warnCounts;
        int errorCounts;
        try {
            if (schematic == null) {
                return false;
            }
            DRC.resetDRCDates(false);
            ElapseTimer timer = ElapseTimer.createInstance();
            timer.start();
            ErrorLogger errorLogger = DRC.getDRCErrorLogger(false, null);
            errorLogger.disablePopups();
            Schematic.doCheck(errorLogger, schematic, null, new DRC.DRCPreferences(true));
            errorLogger.termLogging(true);
            errorCounts = errorLogger.getNumErrors();
            warnCounts = errorLogger.getNumWarnings();
            timer.end();
            System.out.println(errorCounts + " errors and " + warnCounts + " warnings found (took " + timer.toString() + ")");
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("exception: " + e);
            e.printStackTrace();
            return false;
        }
        boolean bl = good = errorCounts == ERROR_DEFAULT && warnCounts == WARN_DEFAULT;
        if (!good) {
            System.out.println("ERROR: Expected " + ERROR_DEFAULT + " errors and " + WARN_DEFAULT + " warnings");
        }
        return good;
    }

    public static boolean basicDRCLayoutTestInternal(Cell lay, int ERROR_DEFAULT, int WARN_DEFAULT, int ERROR_EXHAUSTIVE, int WARN_EXHAUSTIVE, int ERROR_CELL, int WARN_CELL, boolean checkArea, DRC.DRCCheckMinArea areaAlgo) {
        boolean globalPassed = true;
        try {
            if (lay == null) {
                return false;
            }
            DRC.DRCPreferences dp = new DRC.DRCPreferences(true);
            dp.setResolution(lay.getTechnology(), ECoord.ZERO);
            dp.ignoreAreaCheck = !checkArea;
            dp.ignoreExtensionRuleChecking = true;
            dp.storeDatesInMemory = true;
            dp.minAreaAlgoOption = areaAlgo;
            int[] expectedErrors = new int[]{ERROR_DEFAULT, ERROR_CELL, ERROR_EXHAUSTIVE};
            int[] expectedWarns = new int[]{WARN_DEFAULT, WARN_CELL, WARN_EXHAUSTIVE};
            for (DRC.DRCCheckMode mode : DRC.DRCCheckMode.values()) {
                boolean passed;
                if (expectedErrors[mode.mode()] == -1) continue;
                System.out.println("------RUNNING " + (Object)((Object)mode) + " MODE -------------");
                dp.errorType = mode;
                DRC.resetDRCDates(false);
                ElapseTimer timer = ElapseTimer.createInstance();
                timer.start();
                ErrorLogger errorLogger = Quick.checkDesignRules(dp, lay, null, null);
                errorLogger.disablePopups();
                errorLogger.termLogging(true);
                int errorCounts = errorLogger.getNumErrors();
                int warnCounts = errorLogger.getNumWarnings();
                timer.end();
                System.out.println(errorCounts + " errors and " + warnCounts + " warnings found (took " + timer.toString() + ")");
                boolean bl = passed = errorCounts == expectedErrors[mode.mode()] && warnCounts == expectedWarns[mode.mode()];
                if (!passed) {
                    System.out.println("ERROR: Expected " + expectedErrors[mode.mode()] + " errors and " + expectedWarns[mode.mode()] + " warnings");
                    globalPassed = false;
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            System.out.println("exception: " + e);
            e.printStackTrace();
            return false;
        }
        return globalPassed;
    }
}

