/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.xml.XMLValidator;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public final class ValidatorMap {
    private Map<XMLValidators, Predicate<? super ValidationContext>> validators;

    public static Builder builder() {
        return new Builder();
    }

    private ValidatorMap(Map<XMLValidators, Predicate<? super ValidationContext>> validators) {
        this.validators = validators;
    }

    public List<XMLValidator> getValidators(final ValidationContext context) {
        return FluentIterable.from(this.validators.entrySet()).transform(new Function<Map.Entry<XMLValidators, Predicate<? super ValidationContext>>, XMLValidator>(){

            @Override
            public XMLValidator apply(Map.Entry<XMLValidators, Predicate<? super ValidationContext>> entry) {
                return entry.getValue().apply(context) ? entry.getKey().get() : null;
            }
        }).filter(Predicates.notNull()).toList();
    }

    public static final class Builder {
        private LinkedListMultimap<XMLValidators, Predicate<? super ValidationContext>> validatorsBuilder = LinkedListMultimap.create();

        public Builder put(Predicate<? super ValidationContext> predicate, XMLValidators validator) {
            this.validatorsBuilder.put(validator, predicate);
            return this;
        }

        public Builder putAll(Predicate<? super ValidationContext> predicate, XMLValidators ... validators) {
            for (XMLValidators validator : validators) {
                this.put(predicate, validator);
            }
            return this;
        }

        public Builder put(XMLValidators validator) {
            return this.put(Predicates.alwaysTrue(), validator);
        }

        public Builder putAll(XMLValidators ... validators) {
            return this.putAll(Predicates.alwaysTrue(), validators);
        }

        public ValidatorMap build() {
            return new ValidatorMap(ImmutableMap.copyOf(Maps.transformValues(this.validatorsBuilder.asMap(), new Function<Iterable<Predicate<? super ValidationContext>>, Predicate<? super ValidationContext>>(){

                @Override
                public Predicate<? super ValidationContext> apply(Iterable<Predicate<? super ValidationContext>> predicates) {
                    return Predicates.or(predicates);
                }
            })));
        }
    }
}

