USING: alien.syntax alien.c-types classes.struct windows.types
windows.directx.dxgiformat windows.com.syntax windows.com windows.ole32
windows.directx.dxgitype windows.directx.dxgi windows.directx.d3dcommon
windows.directx ;
IN: windows.directx.d3d11

LIBRARY: d3d11

CONSTANT: D3D11_16BIT_INDEX_STRIP_CUT_VALUE   0xffff
CONSTANT: D3D11_32BIT_INDEX_STRIP_CUT_VALUE   0xffffffff
CONSTANT: D3D11_8BIT_INDEX_STRIP_CUT_VALUE    0xff

CONSTANT: D3D11_ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT 9

CONSTANT: D3D11_CLIP_OR_CULL_DISTANCE_COUNT           8
CONSTANT: D3D11_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT   2

CONSTANT: D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT                    14
CONSTANT: D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENTS                        4
CONSTANT: D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT               32
CONSTANT: D3D11_COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT                     15
CONSTANT: D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS               4
CONSTANT: D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT                    15
CONSTANT: D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST           1
CONSTANT: D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS               1
CONSTANT: D3D11_COMMONSHADER_FLOWCONTROL_NESTING_LIMIT                         64
CONSTANT: D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS     4
CONSTANT: D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT          1
CONSTANT: D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST 1
CONSTANT: D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS     1
CONSTANT: D3D11_COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT               32
CONSTANT: D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS                1
CONSTANT: D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT                     128
CONSTANT: D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST            1
CONSTANT: D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS                1
CONSTANT: D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT                         128
CONSTANT: D3D11_COMMONSHADER_SAMPLER_REGISTER_COMPONENTS                       1
CONSTANT: D3D11_COMMONSHADER_SAMPLER_REGISTER_COUNT                            16
CONSTANT: D3D11_COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST                   1
CONSTANT: D3D11_COMMONSHADER_SAMPLER_REGISTER_READ_PORTS                       1
CONSTANT: D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT                                16
CONSTANT: D3D11_COMMONSHADER_SUBROUTINE_NESTING_LIMIT                          32
CONSTANT: D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENTS                          4
CONSTANT: D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT                 32
CONSTANT: D3D11_COMMONSHADER_TEMP_REGISTER_COUNT                               4096
CONSTANT: D3D11_COMMONSHADER_TEMP_REGISTER_READS_PER_INST                      3
CONSTANT: D3D11_COMMONSHADER_TEMP_REGISTER_READ_PORTS                          3
CONSTANT: D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX                      10
CONSTANT: D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN                      -10
CONSTANT: D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE                         -8
CONSTANT: D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE                         7

CONSTANT: D3D11_CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    256
CONSTANT: D3D11_CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP             64
CONSTANT: D3D11_CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    240
CONSTANT: D3D11_CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP             68
CONSTANT: D3D11_CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    224
CONSTANT: D3D11_CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP             72
CONSTANT: D3D11_CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    208
CONSTANT: D3D11_CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP             76
CONSTANT: D3D11_CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    192
CONSTANT: D3D11_CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP             84
CONSTANT: D3D11_CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    176
CONSTANT: D3D11_CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP             92
CONSTANT: D3D11_CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    160
CONSTANT: D3D11_CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP             100
CONSTANT: D3D11_CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    144
CONSTANT: D3D11_CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP             112
CONSTANT: D3D11_CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    128
CONSTANT: D3D11_CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP             128
CONSTANT: D3D11_CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    112
CONSTANT: D3D11_CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP             144
CONSTANT: D3D11_CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    96
CONSTANT: D3D11_CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP             168
CONSTANT: D3D11_CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    80
CONSTANT: D3D11_CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP             204
CONSTANT: D3D11_CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    64
CONSTANT: D3D11_CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP             256
CONSTANT: D3D11_CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    48
CONSTANT: D3D11_CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP             340
CONSTANT: D3D11_CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    32
CONSTANT: D3D11_CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP             512
CONSTANT: D3D11_CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD    16
CONSTANT: D3D11_CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP             768
CONSTANT: D3D11_CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION      1
CONSTANT: D3D11_CS_4_X_RAW_UAV_BYTE_ALIGNMENT                         256
CONSTANT: D3D11_CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP             768
CONSTANT: D3D11_CS_4_X_THREAD_GROUP_MAX_X                             768
CONSTANT: D3D11_CS_4_X_THREAD_GROUP_MAX_Y                             768
CONSTANT: D3D11_CS_4_X_UAV_REGISTER_COUNT                             1
CONSTANT: D3D11_CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION           65535
CONSTANT: D3D11_CS_TGSM_REGISTER_COUNT                                8192
CONSTANT: D3D11_CS_TGSM_REGISTER_READS_PER_INST                       1
CONSTANT: D3D11_CS_TGSM_RESOURCE_REGISTER_COMPONENTS                  1
CONSTANT: D3D11_CS_TGSM_RESOURCE_REGISTER_READ_PORTS                  1
CONSTANT: D3D11_CS_THREAD_GROUP_MAX_THREADS_PER_GROUP                 1024
CONSTANT: D3D11_CS_THREAD_GROUP_MAX_X                                 1024
CONSTANT: D3D11_CS_THREAD_GROUP_MAX_Y                                 1024
CONSTANT: D3D11_CS_THREAD_GROUP_MAX_Z                                 64
CONSTANT: D3D11_CS_THREAD_GROUP_MIN_X                                 1
CONSTANT: D3D11_CS_THREAD_GROUP_MIN_Y                                 1
CONSTANT: D3D11_CS_THREAD_GROUP_MIN_Z                                 1
CONSTANT: D3D11_CS_THREAD_LOCAL_TEMP_REGISTER_POOL                    16384

CONSTANT: D3D11_DEFAULT_BLEND_FACTOR_ALPHA                1.0
CONSTANT: D3D11_DEFAULT_BLEND_FACTOR_GREEN                1.0
CONSTANT: D3D11_DEFAULT_BORDER_COLOR_COMPONENT            0.0
CONSTANT: D3D11_DEFAULT_DEPTH_BIAS_CLAMP                  0.0
CONSTANT: D3D11_DEFAULT_MAX_ANISOTROPY                    16
CONSTANT: D3D11_DEFAULT_MIP_LOD_BIAS                      0.0
CONSTANT: D3D11_DEFAULT_RENDER_TARGET_ARRAY_INDEX         0
CONSTANT: D3D11_DEFAULT_SAMPLE_MASK                       0xffffffff
CONSTANT: D3D11_DEFAULT_SCISSOR_ENDX                      0
CONSTANT: D3D11_DEFAULT_SCISSOR_ENDY                      0
CONSTANT: D3D11_DEFAULT_SCISSOR_STARTX                    0
CONSTANT: D3D11_DEFAULT_SCISSOR_STARTY                    0
CONSTANT: D3D11_DEFAULT_SLOPE_SCALED_DEPTH_BIAS           0.0
CONSTANT: D3D11_DEFAULT_STENCIL_READ_MASK                 0xff
CONSTANT: D3D11_DEFAULT_STENCIL_REFERENCE                 0
CONSTANT: D3D11_DEFAULT_STENCIL_WRITE_MASK                0xff
CONSTANT: D3D11_DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX    0
CONSTANT: D3D11_DEFAULT_VIEWPORT_HEIGHT                   0
CONSTANT: D3D11_DEFAULT_VIEWPORT_MAX_DEPTH                0.0
CONSTANT: D3D11_DEFAULT_VIEWPORT_MIN_DEPTH                0.0
CONSTANT: D3D11_DEFAULT_VIEWPORT_TOPLEFTX                 0
CONSTANT: D3D11_DEFAULT_VIEWPORT_TOPLEFTY                 0
CONSTANT: D3D11_DEFAULT_VIEWPORT_WIDTH                    0

CONSTANT: D3D11_DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS             3968
CONSTANT: D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS            4
CONSTANT: D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT   32
CONSTANT: D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COUNT                 32
CONSTANT: D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST        2
CONSTANT: D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS            1
CONSTANT: D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS             3
CONSTANT: D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT    32
CONSTANT: D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COUNT                  1
CONSTANT: D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST         2
CONSTANT: D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS             1
CONSTANT: D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS           4
CONSTANT: D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT  32
CONSTANT: D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT                32
CONSTANT: D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST       2
CONSTANT: D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS           1
CONSTANT: D3D11_DS_OUTPUT_REGISTER_COMPONENTS                         4
CONSTANT: D3D11_DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT                32
CONSTANT: D3D11_DS_OUTPUT_REGISTER_COUNT                              32

CONSTANT: D3D11_FLOAT16_FUSED_TOLERANCE_IN_ULP        0.6
CONSTANT: D3D11_FLOAT32_MAX                           3.402823466e+38
CONSTANT: D3D11_FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP   0.6
CONSTANT: D3D11_FLOAT_TO_SRGB_EXPONENT_DENOMINATOR    2.4
CONSTANT: D3D11_FLOAT_TO_SRGB_EXPONENT_NUMERATOR      1.0
CONSTANT: D3D11_FLOAT_TO_SRGB_OFFSET                  0.055
CONSTANT: D3D11_FLOAT_TO_SRGB_SCALE_1                 12.92
CONSTANT: D3D11_FLOAT_TO_SRGB_SCALE_2                 1.055
CONSTANT: D3D11_FLOAT_TO_SRGB_THRESHOLD               0.0031308

CONSTANT: D3D11_FTOI_INSTRUCTION_MAX_INPUT    2147483647.999
CONSTANT: D3D11_FTOI_INSTRUCTION_MIN_INPUT    -2147483648.999
CONSTANT: D3D11_FTOU_INSTRUCTION_MAX_INPUT    4294967295.999
CONSTANT: D3D11_FTOU_INSTRUCTION_MIN_INPUT    0.0

CONSTANT: D3D11_GS_INPUT_INSTANCE_ID_READS_PER_INST               2
CONSTANT: D3D11_GS_INPUT_INSTANCE_ID_READ_PORTS                   1
CONSTANT: D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS          1
CONSTANT: D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT 32
CONSTANT: D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COUNT               1
CONSTANT: D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS           1
CONSTANT: D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT  32
CONSTANT: D3D11_GS_INPUT_PRIM_CONST_REGISTER_COUNT                1
CONSTANT: D3D11_GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST       2
CONSTANT: D3D11_GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS           1
CONSTANT: D3D11_GS_INPUT_REGISTER_COMPONENTS                      4
CONSTANT: D3D11_GS_INPUT_REGISTER_COMPONENT_BIT_COUNT             32
CONSTANT: D3D11_GS_INPUT_REGISTER_COUNT                           32
CONSTANT: D3D11_GS_INPUT_REGISTER_READS_PER_INST                  2
CONSTANT: D3D11_GS_INPUT_REGISTER_READ_PORTS                      1
CONSTANT: D3D11_GS_INPUT_REGISTER_VERTICES                        32
CONSTANT: D3D11_GS_MAX_INSTANCE_COUNT                             32
CONSTANT: D3D11_GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES       1024
CONSTANT: D3D11_GS_OUTPUT_ELEMENTS                                32
CONSTANT: D3D11_GS_OUTPUT_REGISTER_COMPONENTS                     4
CONSTANT: D3D11_GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT            32
CONSTANT: D3D11_GS_OUTPUT_REGISTER_COUNT                          32

CONSTANT: D3D11_HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT               32
CONSTANT: D3D11_HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT              32
CONSTANT: D3D11_HS_CONTROL_POINT_REGISTER_COMPONENTS                      4
CONSTANT: D3D11_HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT             32
CONSTANT: D3D11_HS_CONTROL_POINT_REGISTER_READS_PER_INST                  2
CONSTANT: D3D11_HS_CONTROL_POINT_REGISTER_READ_PORTS                      1
CONSTANT: D3D11_HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND                  0xffffffff
CONSTANT: D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS             1
CONSTANT: D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT    32
CONSTANT: D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT                  1
CONSTANT: D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST         2
CONSTANT: D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS             1
CONSTANT: D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS             1
CONSTANT: D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT    32
CONSTANT: D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT                  1
CONSTANT: D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST         2
CONSTANT: D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS             1
CONSTANT: D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS                 1
CONSTANT: D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT        32
CONSTANT: D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT                      1
CONSTANT: D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST             2
CONSTANT: D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS                 1
CONSTANT: D3D11_HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND                  0xffffffff
CONSTANT: D3D11_HS_MAXTESSFACTOR_LOWER_BOUND                              1.0
CONSTANT: D3D11_HS_MAXTESSFACTOR_UPPER_BOUND                              64.0
CONSTANT: D3D11_HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS                3968
CONSTANT: D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS            1
CONSTANT: D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENT_BIT_COUNT   32
CONSTANT: D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT                 1
CONSTANT: D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST        2
CONSTANT: D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS            1
CONSTANT: D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS              4
CONSTANT: D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT     32
CONSTANT: D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT                   32
CONSTANT: D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST          2
CONSTANT: D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS              1

CONSTANT: D3D11_IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES       0
CONSTANT: D3D11_IA_DEFAULT_PRIMITIVE_TOPOLOGY                 0
CONSTANT: D3D11_IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES      0
CONSTANT: D3D11_IA_INDEX_INPUT_RESOURCE_SLOT_COUNT            1
CONSTANT: D3D11_IA_INSTANCE_ID_BIT_COUNT                      32
CONSTANT: D3D11_IA_INTEGER_ARITHMETIC_BIT_COUNT               32
CONSTANT: D3D11_IA_PATCH_MAX_CONTROL_POINT_COUNT              32
CONSTANT: D3D11_IA_PRIMITIVE_ID_BIT_COUNT                     32
CONSTANT: D3D11_IA_VERTEX_ID_BIT_COUNT                        32
CONSTANT: D3D11_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT           32
CONSTANT: D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS 128
CONSTANT: D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT       32

CONSTANT: D3D11_INTEGER_DIVIDE_BY_ZERO_QUOTIENT   0xffffffff
CONSTANT: D3D11_INTEGER_DIVIDE_BY_ZERO_REMAINDER  0xffffffff

CONSTANT: D3D11_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL 0xffffffff
CONSTANT: D3D11_KEEP_UNORDERED_ACCESS_VIEWS           0xffffffff

CONSTANT: D3D11_LINEAR_GAMMA  1.0

CONSTANT: D3D11_MAX_BORDER_COLOR_COMPONENT        1.0
CONSTANT: D3D11_MAX_DEPTH                         1.0
CONSTANT: D3D11_MAX_MAXANISOTROPY                 16
CONSTANT: D3D11_MAX_MULTISAMPLE_SAMPLE_COUNT      32
CONSTANT: D3D11_MAX_POSITION_VALUE                3.402823466e+34
CONSTANT: D3D11_MAX_TEXTURE_DIMENSION_2_TO_EXP    17

CONSTANT: D3D11_MAJOR_VERSION 11
CONSTANT: D3D11_MINOR_VERSION 0

CONSTANT: D3D11_MIN_BORDER_COLOR_COMPONENT    0.0
CONSTANT: D3D11_MIN_DEPTH                     0.0
CONSTANT: D3D11_MIN_MAXANISOTROPY             0

CONSTANT: D3D11_MIP_LOD_BIAS_MAX                  15.99
CONSTANT: D3D11_MIP_LOD_BIAS_MIN                  -16.0
CONSTANT: D3D11_MIP_LOD_FRACTIONAL_BIT_COUNT      8
CONSTANT: D3D11_MIP_LOD_RANGE_BIT_COUNT           8

CONSTANT: D3D11_MULTISAMPLE_ANTIALIAS_LINE_WIDTH  1.4

CONSTANT: D3D11_NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT 0

CONSTANT: D3D11_PIXEL_ADDRESS_RANGE_BIT_COUNT 15

CONSTANT: D3D11_PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT 16

CONSTANT: D3D11_PS_CS_UAV_REGISTER_COMPONENTS                 1
CONSTANT: D3D11_PS_CS_UAV_REGISTER_COUNT                      8
CONSTANT: D3D11_PS_CS_UAV_REGISTER_READS_PER_INST             1
CONSTANT: D3D11_PS_CS_UAV_REGISTER_READ_PORTS                 1
CONSTANT: D3D11_PS_FRONTFACING_DEFAULT_VALUE                  0xffffffff
CONSTANT: D3D11_PS_FRONTFACING_FALSE_VALUE                    0
CONSTANT: D3D11_PS_FRONTFACING_TRUE_VALUE                     0xffffffff
CONSTANT: D3D11_PS_INPUT_REGISTER_COMPONENTS                  4
CONSTANT: D3D11_PS_INPUT_REGISTER_COMPONENT_BIT_COUNT         32
CONSTANT: D3D11_PS_INPUT_REGISTER_COUNT                       32
CONSTANT: D3D11_PS_INPUT_REGISTER_READS_PER_INST              2
CONSTANT: D3D11_PS_INPUT_REGISTER_READ_PORTS                  1
CONSTANT: D3D11_PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT   0.0
CONSTANT: D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENTS           1
CONSTANT: D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT  32
CONSTANT: D3D11_PS_OUTPUT_DEPTH_REGISTER_COUNT                1
CONSTANT: D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENTS            1
CONSTANT: D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT   32
CONSTANT: D3D11_PS_OUTPUT_MASK_REGISTER_COUNT                 1
CONSTANT: D3D11_PS_OUTPUT_REGISTER_COMPONENTS                 4
CONSTANT: D3D11_PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT        32
CONSTANT: D3D11_PS_OUTPUT_REGISTER_COUNT                      8
CONSTANT: D3D11_PS_PIXEL_CENTER_FRACTIONAL_COMPONENT          0.5

CONSTANT: D3D11_RAW_UAV_SRV_BYTE_ALIGNMENT 16

CONSTANT: D3D11_REQ_BLEND_OBJECT_COUNT_PER_DEVICE                 4096
CONSTANT: D3D11_REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP          27
CONSTANT: D3D11_REQ_CONSTANT_BUFFER_ELEMENT_COUNT                 4096
CONSTANT: D3D11_REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE         4096
CONSTANT: D3D11_REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP              32
CONSTANT: D3D11_REQ_DRAW_VERTEX_COUNT_2_TO_EXP                    32
CONSTANT: D3D11_REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION   16384
CONSTANT: D3D11_REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT    1024
CONSTANT: D3D11_REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT       4096
CONSTANT: D3D11_REQ_MAXANISOTROPY                                 16
CONSTANT: D3D11_REQ_MIP_LEVELS                                    15
CONSTANT: D3D11_REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES         2048
CONSTANT: D3D11_REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE            4096
CONSTANT: D3D11_REQ_RENDER_TO_BUFFER_WINDOW_WIDTH                 16384
CONSTANT: D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM  128
CONSTANT: D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM  0.25
CONSTANT: D3D11_REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP       20
CONSTANT: D3D11_REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE               4096
CONSTANT: D3D11_REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION                2048
CONSTANT: D3D11_REQ_TEXTURE1D_U_DIMENSION                         16384
CONSTANT: D3D11_REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION                2048
CONSTANT: D3D11_REQ_TEXTURE2D_U_OR_V_DIMENSION                    16384
CONSTANT: D3D11_REQ_TEXTURE3D_U_V_OR_W_DIMENSION                  2048
CONSTANT: D3D11_REQ_TEXTURECUBE_DIMENSION                         16384

CONSTANT: D3D11_RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL 0

CONSTANT: D3D11_SHADER_MAJOR_VERSION              5
CONSTANT: D3D11_SHADER_MAX_INSTANCES              65535
CONSTANT: D3D11_SHADER_MAX_INTERFACES             253
CONSTANT: D3D11_SHADER_MAX_INTERFACE_CALL_SITES   4096
CONSTANT: D3D11_SHADER_MAX_TYPES                  65535
CONSTANT: D3D11_SHADER_MINOR_VERSION              0

CONSTANT: D3D11_SHIFT_INSTRUCTION_PAD_VALUE               0
CONSTANT: D3D11_SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT   5

CONSTANT: D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT 8

CONSTANT: D3D11_SO_BUFFER_MAX_STRIDE_IN_BYTES         2048
CONSTANT: D3D11_SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES   512
CONSTANT: D3D11_SO_BUFFER_SLOT_COUNT                  4
CONSTANT: D3D11_SO_DDI_REGISTER_INDEX_DENOTING_GAP    0xffffffff
CONSTANT: D3D11_SO_NO_RASTERIZED_STREAM               0xffffffff
CONSTANT: D3D11_SO_OUTPUT_COMPONENT_COUNT             128
CONSTANT: D3D11_SO_STREAM_COUNT                       4

CONSTANT: D3D11_SPEC_DATE_DAY     04
CONSTANT: D3D11_SPEC_DATE_MONTH   06
CONSTANT: D3D11_SPEC_DATE_YEAR    2009
CONSTANT: D3D11_SPEC_VERSION      1.0

CONSTANT: D3D11_SRGB_GAMMA                        2.2
CONSTANT: D3D11_SRGB_TO_FLOAT_DENOMINATOR_1       12.92
CONSTANT: D3D11_SRGB_TO_FLOAT_DENOMINATOR_2       1.055
CONSTANT: D3D11_SRGB_TO_FLOAT_EXPONENT            2.4
CONSTANT: D3D11_SRGB_TO_FLOAT_OFFSET              0.055
CONSTANT: D3D11_SRGB_TO_FLOAT_THRESHOLD           0.04045
CONSTANT: D3D11_SRGB_TO_FLOAT_TOLERANCE_IN_ULP    0.5

CONSTANT: D3D11_STANDARD_COMPONENT_BIT_COUNT                      32
CONSTANT: D3D11_STANDARD_COMPONENT_BIT_COUNT_DOUBLED              64
CONSTANT: D3D11_STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE  4
CONSTANT: D3D11_STANDARD_PIXEL_COMPONENT_COUNT                    128
CONSTANT: D3D11_STANDARD_PIXEL_ELEMENT_COUNT                      32
CONSTANT: D3D11_STANDARD_VECTOR_SIZE                              4
CONSTANT: D3D11_STANDARD_VERTEX_ELEMENT_COUNT                     32
CONSTANT: D3D11_STANDARD_VERTEX_TOTAL_COMPONENT_COUNT             64

CONSTANT: D3D11_SUBPIXEL_FRACTIONAL_BIT_COUNT 8
CONSTANT: D3D11_SUBTEXEL_FRACTIONAL_BIT_COUNT 8

CONSTANT: D3D11_TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR              64
CONSTANT: D3D11_TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR   64
CONSTANT: D3D11_TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR               63
CONSTANT: D3D11_TESSELLATOR_MAX_TESSELLATION_FACTOR                   64
CONSTANT: D3D11_TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR              2
CONSTANT: D3D11_TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR   1
CONSTANT: D3D11_TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR               1

CONSTANT: D3D11_TEXEL_ADDRESS_RANGE_BIT_COUNT 16

CONSTANT: D3D11_UNBOUND_MEMORY_ACCESS_RESULT 0

CONSTANT: D3D11_VIEWPORT_AND_SCISSORRECT_MAX_INDEX                    15
CONSTANT: D3D11_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE    16

CONSTANT: D3D11_VIEWPORT_BOUNDS_MAX   32767
CONSTANT: D3D11_VIEWPORT_BOUNDS_MIN   -32768

CONSTANT: D3D11_VS_INPUT_REGISTER_COMPONENTS              4
CONSTANT: D3D11_VS_INPUT_REGISTER_COMPONENT_BIT_COUNT     32
CONSTANT: D3D11_VS_INPUT_REGISTER_COUNT                   32
CONSTANT: D3D11_VS_INPUT_REGISTER_READS_PER_INST          2
CONSTANT: D3D11_VS_INPUT_REGISTER_READ_PORTS              1
CONSTANT: D3D11_VS_OUTPUT_REGISTER_COMPONENTS             4
CONSTANT: D3D11_VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT    32
CONSTANT: D3D11_VS_OUTPUT_REGISTER_COUNT                  32

CONSTANT: D3D11_WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT 10
CONSTANT: D3D11_WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP 25
CONSTANT: D3D11_WHQL_DRAW_VERTEX_COUNT_2_TO_EXP       25

CONSTANT: D3D11_ERROR_TOO_MANY_UNIQUE_STATE_OBJECTS                0x887c0001
CONSTANT: D3D11_ERROR_FILE_NOT_FOUND                               0x887c0002
CONSTANT: D3D11_ERROR_TOO_MANY_UNIQUE_VIEW_OBJECTS                 0x887c003
CONSTANT: D3D11_ERROR_DEFERRED_CONTEXT_MAP_WITHOUT_INITIAL_DISCARD 0x887c004

CONSTANT: D3D11_INPUT_PER_VERTEX_DATA   0
CONSTANT: D3D11_INPUT_PER_INSTANCE_DATA 1
TYPEDEF: int D3D11_INPUT_CLASSIFICATION

CONSTANT: D3D11_APPEND_ALIGNED_ELEMENT 0xffffffff

STRUCT: D3D11_INPUT_ELEMENT_DESC
    { SemanticName         LPCSTR                     }
    { SemanticIndex        UINT                       }
    { Format               DXGI_FORMAT                }
    { InputSlot            UINT                       }
    { AlignedByteOffset    UINT                       }
    { InputSlotClass       D3D11_INPUT_CLASSIFICATION }
    { InstanceDataStepRate UINT                       } ;

CONSTANT: D3D11_FILL_WIREFRAME 2
CONSTANT: D3D11_FILL_SOLID     3
TYPEDEF: int D3D11_FILL_MODE

CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_UNDEFINED                  0
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_POINTLIST                  1
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_LINELIST                   2
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP                  3
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST               4
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP              5
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_LINELIST_ADJ               10
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ              11
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ           12
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ          13
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST  33
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST  34
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST  35
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST  36
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST  37
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST  38
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST  39
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST  40
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST  41
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST 42
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST 43
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST 44
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST 45
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST 46
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST 47
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST 48
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST 49
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST 50
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST 51
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST 52
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST 53
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST 54
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST 55
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST 56
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST 57
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST 58
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST 59
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST 60
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST 61
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST 62
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST 63
CONSTANT: D3D11_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST 64
TYPEDEF: int D3D11_PRIMITIVE_TOPOLOGY

CONSTANT: D3D11_PRIMITIVE_UNDEFINED               0
CONSTANT: D3D11_PRIMITIVE_POINT                   1
CONSTANT: D3D11_PRIMITIVE_LINE                    2
CONSTANT: D3D11_PRIMITIVE_TRIANGLE                3
CONSTANT: D3D11_PRIMITIVE_LINE_ADJ                6
CONSTANT: D3D11_PRIMITIVE_TRIANGLE_ADJ            7
CONSTANT: D3D11_PRIMITIVE_1_CONTROL_POINT_PATCH   8
CONSTANT: D3D11_PRIMITIVE_2_CONTROL_POINT_PATCH   9
CONSTANT: D3D11_PRIMITIVE_3_CONTROL_POINT_PATCH   10
CONSTANT: D3D11_PRIMITIVE_4_CONTROL_POINT_PATCH   11
CONSTANT: D3D11_PRIMITIVE_5_CONTROL_POINT_PATCH   12
CONSTANT: D3D11_PRIMITIVE_6_CONTROL_POINT_PATCH   13
CONSTANT: D3D11_PRIMITIVE_7_CONTROL_POINT_PATCH   14
CONSTANT: D3D11_PRIMITIVE_8_CONTROL_POINT_PATCH   15
CONSTANT: D3D11_PRIMITIVE_9_CONTROL_POINT_PATCH   16
CONSTANT: D3D11_PRIMITIVE_10_CONTROL_POINT_PATCH  17
CONSTANT: D3D11_PRIMITIVE_11_CONTROL_POINT_PATCH  18
CONSTANT: D3D11_PRIMITIVE_12_CONTROL_POINT_PATCH  19
CONSTANT: D3D11_PRIMITIVE_13_CONTROL_POINT_PATCH  20
CONSTANT: D3D11_PRIMITIVE_14_CONTROL_POINT_PATCH  21
CONSTANT: D3D11_PRIMITIVE_15_CONTROL_POINT_PATCH  22
CONSTANT: D3D11_PRIMITIVE_16_CONTROL_POINT_PATCH  23
CONSTANT: D3D11_PRIMITIVE_17_CONTROL_POINT_PATCH  24
CONSTANT: D3D11_PRIMITIVE_18_CONTROL_POINT_PATCH  25
CONSTANT: D3D11_PRIMITIVE_19_CONTROL_POINT_PATCH  26
CONSTANT: D3D11_PRIMITIVE_20_CONTROL_POINT_PATCH  27
CONSTANT: D3D11_PRIMITIVE_21_CONTROL_POINT_PATCH  28
CONSTANT: D3D11_PRIMITIVE_22_CONTROL_POINT_PATCH  29
CONSTANT: D3D11_PRIMITIVE_23_CONTROL_POINT_PATCH  30
CONSTANT: D3D11_PRIMITIVE_24_CONTROL_POINT_PATCH  31
CONSTANT: D3D11_PRIMITIVE_25_CONTROL_POINT_PATCH  32
CONSTANT: D3D11_PRIMITIVE_26_CONTROL_POINT_PATCH  33
CONSTANT: D3D11_PRIMITIVE_27_CONTROL_POINT_PATCH  34
CONSTANT: D3D11_PRIMITIVE_28_CONTROL_POINT_PATCH  35
CONSTANT: D3D11_PRIMITIVE_29_CONTROL_POINT_PATCH  36
CONSTANT: D3D11_PRIMITIVE_30_CONTROL_POINT_PATCH  37
CONSTANT: D3D11_PRIMITIVE_31_CONTROL_POINT_PATCH  38
CONSTANT: D3D11_PRIMITIVE_32_CONTROL_POINT_PATCH  39
TYPEDEF: int D3D11_PRIMITIVE

CONSTANT: D3D11_CULL_NONE  1
CONSTANT: D3D11_CULL_FRONT 2
CONSTANT: D3D11_CULL_BACK  3
TYPEDEF: int D3D11_CULL_MODE

STRUCT: D3D11_SO_DECLARATION_ENTRY
    { Stream UINT }
    { SemanticName LPCSTR }
    { SemanticIndex UINT }
    { StartComponent BYTE }
    { ComponentCount BYTE }
    { OutputSlot BYTE } ;

STRUCT: D3D11_VIEWPORT
    { TopLeftX FLOAT }
    { TopLeftY FLOAT }
    { Width FLOAT }
    { Height FLOAT }
    { MinDepth FLOAT }
    { MaxDepth FLOAT } ;

CONSTANT: D3D11_RESOURCE_DIMENSION_UNKNOWN   0
CONSTANT: D3D11_RESOURCE_DIMENSION_BUFFER    1
CONSTANT: D3D11_RESOURCE_DIMENSION_TEXTURE1D 2
CONSTANT: D3D11_RESOURCE_DIMENSION_TEXTURE2D 3
CONSTANT: D3D11_RESOURCE_DIMENSION_TEXTURE3D 4
TYPEDEF: int D3D11_RESOURCE_DIMENSION

CONSTANT: D3D11_SRV_DIMENSION_UNKNOWN             0
CONSTANT: D3D11_SRV_DIMENSION_BUFFER              1
CONSTANT: D3D11_SRV_DIMENSION_TEXTURE1D           2
CONSTANT: D3D11_SRV_DIMENSION_TEXTURE1DARRAY      3
CONSTANT: D3D11_SRV_DIMENSION_TEXTURE2D           4
CONSTANT: D3D11_SRV_DIMENSION_TEXTURE2DARRAY      5
CONSTANT: D3D11_SRV_DIMENSION_TEXTURE2DMS         6
CONSTANT: D3D11_SRV_DIMENSION_TEXTURE2DMSARRAY    7
CONSTANT: D3D11_SRV_DIMENSION_TEXTURE3D           8
CONSTANT: D3D11_SRV_DIMENSION_TEXTURECUBE         9
CONSTANT: D3D11_SRV_DIMENSION_TEXTURECUBEARRAY    10
CONSTANT: D3D11_SRV_DIMENSION_BUFFEREX            11
TYPEDEF: int D3D11_SRV_DIMENSION

CONSTANT: D3D11_DSV_DIMENSION_UNKNOWN             0
CONSTANT: D3D11_DSV_DIMENSION_TEXTURE1D           1
CONSTANT: D3D11_DSV_DIMENSION_TEXTURE1DARRAY      2
CONSTANT: D3D11_DSV_DIMENSION_TEXTURE2D           3
CONSTANT: D3D11_DSV_DIMENSION_TEXTURE2DARRAY      4
CONSTANT: D3D11_DSV_DIMENSION_TEXTURE2DMS         5
CONSTANT: D3D11_DSV_DIMENSION_TEXTURE2DMSARRAY    6
TYPEDEF: int D3D11_DSV_DIMENSION

CONSTANT: D3D11_RTV_DIMENSION_UNKNOWN             0
CONSTANT: D3D11_RTV_DIMENSION_BUFFER              1
CONSTANT: D3D11_RTV_DIMENSION_TEXTURE1D           2
CONSTANT: D3D11_RTV_DIMENSION_TEXTURE1DARRAY      3
CONSTANT: D3D11_RTV_DIMENSION_TEXTURE2D           4
CONSTANT: D3D11_RTV_DIMENSION_TEXTURE2DARRAY      5
CONSTANT: D3D11_RTV_DIMENSION_TEXTURE2DMS         6
CONSTANT: D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY    7
CONSTANT: D3D11_RTV_DIMENSION_TEXTURE3D           8
TYPEDEF: int D3D11_RTV_DIMENSION

CONSTANT: D3D11_UAV_DIMENSION_UNKNOWN         0
CONSTANT: D3D11_UAV_DIMENSION_BUFFER          1
CONSTANT: D3D11_UAV_DIMENSION_TEXTURE1D       2
CONSTANT: D3D11_UAV_DIMENSION_TEXTURE1DARRAY  3
CONSTANT: D3D11_UAV_DIMENSION_TEXTURE2D       4
CONSTANT: D3D11_UAV_DIMENSION_TEXTURE2DARRAY  5
CONSTANT: D3D11_UAV_DIMENSION_TEXTURE3D       8
TYPEDEF: int D3D11_UAV_DIMENSION

CONSTANT: D3D11_USAGE_DEFAULT   0
CONSTANT: D3D11_USAGE_IMMUTABLE 1
CONSTANT: D3D11_USAGE_DYNAMIC   2
CONSTANT: D3D11_USAGE_STAGING   3
TYPEDEF: int D3D11_USAGE

CONSTANT: D3D11_BIND_VERTEX_BUFFER    1
CONSTANT: D3D11_BIND_INDEX_BUFFER     2
CONSTANT: D3D11_BIND_CONSTANT_BUFFER  4
CONSTANT: D3D11_BIND_SHADER_RESOURCE  8
CONSTANT: D3D11_BIND_STREAM_OUTPUT    16
CONSTANT: D3D11_BIND_RENDER_TARGET    32
CONSTANT: D3D11_BIND_DEPTH_STENCIL    64
CONSTANT: D3D11_BIND_UNORDERED_ACCESS 128
TYPEDEF: int D3D11_BIND_FLAG

CONSTANT: D3D11_CPU_ACCESS_WRITE  0x10000
CONSTANT: D3D11_CPU_ACCESS_READ   0x20000
TYPEDEF: int D3D11_CPU_ACCESS_FLAG

CONSTANT: D3D11_RESOURCE_MISC_GENERATE_MIPS           1
CONSTANT: D3D11_RESOURCE_MISC_SHARED                  2
CONSTANT: D3D11_RESOURCE_MISC_TEXTURECUBE             4
CONSTANT: D3D11_RESOURCE_MISC_DRAWINDIRECT_ARGS       16
CONSTANT: D3D11_RESOURCE_MISC_BUFFER_ALLOW_RAW_VIEWS  32
CONSTANT: D3D11_RESOURCE_MISC_BUFFER_STRUCTURED       64
CONSTANT: D3D11_RESOURCE_MISC_RESOURCE_CLAMP          128
CONSTANT: D3D11_RESOURCE_MISC_SHARED_KEYEDMUTEX       256
CONSTANT: D3D11_RESOURCE_MISC_GDI_COMPATIBLE          512
TYPEDEF: int D3D11_RESOURCE_MISC_FLAG

CONSTANT: D3D11_MAP_READ                  1
CONSTANT: D3D11_MAP_WRITE                 2
CONSTANT: D3D11_MAP_READ_WRITE            3
CONSTANT: D3D11_MAP_WRITE_DISCARD         4
CONSTANT: D3D11_MAP_WRITE_NO_OVERWRITE    5
TYPEDEF: int D3D11_MAP

CONSTANT: D3D11_MAP_FLAG_DO_NOT_WAIT 0x100000
TYPEDEF: int D3D11_MAP_FLAG

CONSTANT: D3D11_RAISE_FLAG_DRIVER_INTERNAL_ERROR 1
TYPEDEF: int D3D11_RAISE_FLAG

CONSTANT: D3D11_CLEAR_DEPTH   1
CONSTANT: D3D11_CLEAR_STENCIL 2
TYPEDEF: int D3D11_CLEAR_FLAG

TYPEDEF: RECT D3D11_RECT

STRUCT: D3D11_BOX
    { left   UINT }
    { top    UINT }
    { front  UINT }
    { right  UINT }
    { bottom UINT }
    { back   UINT } ;

C-TYPE: ID3D11Device
C-TYPE: ID3D11ClassLinkage

COM-INTERFACE: ID3D11DeviceChild IUnknown {1841e5c8-16b0-489b-bcc8-44cfb0d5deae}
    void GetDevice ( ID3D11Device** ppDevice )
    HRESULT GetPrivateData ( REFGUID guid, UINT* pDataSize, void* pData )
    HRESULT SetPrivateData ( REFGUID guid, UINT DataSize, void* pData )
    HRESULT SetPrivateDataInterface ( REFGUID guid, IUnknown* pData ) ;

CONSTANT: D3D11_COMPARISON_NEVER          1
CONSTANT: D3D11_COMPARISON_LESS           2
CONSTANT: D3D11_COMPARISON_EQUAL          3
CONSTANT: D3D11_COMPARISON_LESS_EQUAL     4
CONSTANT: D3D11_COMPARISON_GREATER        5
CONSTANT: D3D11_COMPARISON_NOT_EQUAL      6
CONSTANT: D3D11_COMPARISON_GREATER_EQUAL  7
CONSTANT: D3D11_COMPARISON_ALWAYS         8
TYPEDEF: int D3D11_COMPARISON_FUNC

CONSTANT: D3D11_DEPTH_WRITE_MASK_ZERO 0
CONSTANT: D3D11_DEPTH_WRITE_MASK_ALL  1
TYPEDEF: int D3D11_DEPTH_WRITE_MASK

CONSTANT: D3D11_STENCIL_OP_KEEP       1
CONSTANT: D3D11_STENCIL_OP_ZERO       2
CONSTANT: D3D11_STENCIL_OP_REPLACE    3
CONSTANT: D3D11_STENCIL_OP_INCR_SAT   4
CONSTANT: D3D11_STENCIL_OP_DECR_SAT   5
CONSTANT: D3D11_STENCIL_OP_INVERT     6
CONSTANT: D3D11_STENCIL_OP_INCR       7
CONSTANT: D3D11_STENCIL_OP_DECR       8
TYPEDEF: int D3D11_STENCIL_OP

STRUCT: D3D11_DEPTH_STENCILOP_DESC
    { StencilFailOp      D3D11_STENCIL_OP      }
    { StencilDepthFailOp D3D11_STENCIL_OP      }
    { StencilPassOp      D3D11_STENCIL_OP      }
    { StencilFunc        D3D11_COMPARISON_FUNC } ;

STRUCT: D3D11_DEPTH_STENCIL_DESC
    { DepthEnable      BOOL                       }
    { DepthWriteMask   D3D11_DEPTH_WRITE_MASK     }
    { DepthFunc        D3D11_COMPARISON_FUNC      }
    { StencilEnable    BOOL                       }
    { StencilReadMask  BYTE                      }
    { StencilWriteMask BYTE                      }
    { FrontFace        D3D11_DEPTH_STENCILOP_DESC }
    { BackFace         D3D11_DEPTH_STENCILOP_DESC } ;

COM-INTERFACE: ID3D11DepthStencilState ID3D11DeviceChild {03823efb-8d8f-4e1c-9aa2-f64bb2cbfdf1}
    void GetDesc ( D3D11_DEPTH_STENCIL_DESC* pDesc ) ;

CONSTANT: D3D11_BLEND_ZERO                1
CONSTANT: D3D11_BLEND_ONE                 2
CONSTANT: D3D11_BLEND_SRC_COLOR           3
CONSTANT: D3D11_BLEND_INV_SRC_COLOR       4
CONSTANT: D3D11_BLEND_SRC_ALPHA           5
CONSTANT: D3D11_BLEND_INV_SRC_ALPHA       6
CONSTANT: D3D11_BLEND_DEST_ALPHA          7
CONSTANT: D3D11_BLEND_INV_DEST_ALPHA      8
CONSTANT: D3D11_BLEND_DEST_COLOR          9
CONSTANT: D3D11_BLEND_INV_DEST_COLOR      10
CONSTANT: D3D11_BLEND_SRC_ALPHA_SAT       11
CONSTANT: D3D11_BLEND_BLEND_FACTOR        14
CONSTANT: D3D11_BLEND_INV_BLEND_FACTOR    15
CONSTANT: D3D11_BLEND_SRC1_COLOR          16
CONSTANT: D3D11_BLEND_INV_SRC1_COLOR      17
CONSTANT: D3D11_BLEND_SRC1_ALPHA          18
CONSTANT: D3D11_BLEND_INV_SRC1_ALPHA      19
TYPEDEF: int D3D11_BLEND

CONSTANT: D3D11_BLEND_OP_ADD  1
CONSTANT: D3D11_BLEND_OP_SUBTRACT 2
CONSTANT: D3D11_BLEND_OP_REV_SUBTRACT 3
CONSTANT: D3D11_BLEND_OP_MIN  4
CONSTANT: D3D11_BLEND_OP_MAX  5
TYPEDEF: int D3D11_BLEND_OP

CONSTANT: D3D11_COLOR_WRITE_ENABLE_RED    1
CONSTANT: D3D11_COLOR_WRITE_ENABLE_GREEN  2
CONSTANT: D3D11_COLOR_WRITE_ENABLE_BLUE   4
CONSTANT: D3D11_COLOR_WRITE_ENABLE_ALPHA  8
CONSTANT: D3D11_COLOR_WRITE_ENABLE_ALL    15
TYPEDEF: int D3D11_COLOR_WRITE_ENABLE

STRUCT: D3D11_RENDER_TARGET_BLEND_DESC
    { BlendEnable           BOOL           }
    { SrcBlend              D3D11_BLEND    }
    { DestBlend             D3D11_BLEND    }
    { BlendOp               D3D11_BLEND_OP }
    { SrcBlendAlpha         D3D11_BLEND    }
    { DestBlendAlpha        D3D11_BLEND    }
    { BlendOpAlpha          D3D11_BLEND_OP }
    { RenderTargetWriteMask BYTE          } ;

STRUCT: D3D11_BLEND_DESC
    { AlphaToCoverageEnable BOOL }
    { IndependentBlendEnable BOOL }
    { RenderTarget D3D11_RENDER_TARGET_BLEND_DESC[8] } ;

COM-INTERFACE: ID3D11BlendState ID3D11DeviceChild 75b68faa-347d-4159-8f45-a0640f01cd9a
    void GetDesc ( D3D11_BLEND_DESC* pDesc ) ;

STRUCT: D3D11_RASTERIZER_DESC
    { FillMode              D3D11_FILL_MODE }
    { CullMode              D3D11_CULL_MODE }
    { FrontCounterClockwise BOOL            }
    { DepthBias             INT             }
    { DepthBiasClamp        FLOAT           }
    { SlopeScaledDepthBias  FLOAT           }
    { DepthClipEnable       BOOL            }
    { ScissorEnable         BOOL            }
    { MultisampleEnable     BOOL            }
    { AntialiasedLineEnable BOOL            } ;

COM-INTERFACE: ID3D11RasterizerState ID3D11DeviceChild {9bb4ab81-ab1a-4d8f-b506-fc04200b6ee7}
    void GetDesc ( D3D11_RASTERIZER_DESC* pDesc ) ;

STRUCT: D3D11_SUBRESOURCE_DATA
    { pSysMem          void* }
    { SysMemPitch      UINT  }
    { SysMemSlicePitch UINT  } ;

STRUCT: D3D11_MAPPED_SUBRESOURCE
    { pData       void* }
    { RowPitch    UINT  }
    { DepthPitch  UINT  } ;

COM-INTERFACE: ID3D11Resource ID3D11DeviceChild {dc8e63f3-d12b-4952-b47b-5e45026a862d}
    void GetType ( D3D11_RESOURCE_DIMENSION* pResourceDimension )
    void SetEvictionPriority ( UINT EvictionPriority )
    UINT GetEvictionPriority ( ) ;

STRUCT: D3D11_BUFFER_DESC
    { ByteWidth           UINT        }
    { Usage               D3D11_USAGE }
    { BindFlags           UINT        }
    { CPUAccessFlags      UINT        }
    { MiscFlags           UINT        }
    { StructureByteStride UINT        } ;

COM-INTERFACE: ID3D11Buffer ID3D11Resource {48570b85-d1ee-4fcd-a250-eb350722b037}
    void GetDesc ( D3D11_BUFFER_DESC* pDesc ) ;

STRUCT: D3D11_TEXTURE1D_DESC
    { Width          UINT        }
    { MipLevels      UINT        }
    { ArraySize      UINT        }
    { Format         DXGI_FORMAT }
    { Usage          D3D11_USAGE }
    { BindFlags      UINT        }
    { CPUAccessFlags UINT        }
    { MiscFlags      UINT        } ;

COM-INTERFACE: ID3D11Texture1D ID3D11Resource {f8fb5c27-c6b3-4f75-a4c8-439af2ef564c}
    void GetDesc ( D3D11_TEXTURE1D_DESC* pDesc ) ;

STRUCT: D3D11_TEXTURE2D_DESC
    { Width          UINT             }
    { Height         UINT             }
    { MipLevels      UINT             }
    { ArraySize      UINT             }
    { Format         DXGI_FORMAT      }
    { SampleDesc     DXGI_SAMPLE_DESC }
    { Usage          D3D11_USAGE      }
    { BindFlags      UINT             }
    { CPUAccessFlags UINT             }
    { MiscFlags      UINT             } ;

COM-INTERFACE: ID3D11Texture2D ID3D11Resource {6f15aaf2-d208-4e89-9ab4-489535d34f9c}
    void GetDesc ( D3D11_TEXTURE2D_DESC* pDesc ) ;

STRUCT: D3D11_TEXTURE3D_DESC
    { Width          UINT        }
    { Height         UINT        }
    { Depth          UINT        }
    { MipLevels      UINT        }
    { Format         DXGI_FORMAT }
    { Usage          D3D11_USAGE }
    { BindFlags      UINT        }
    { CPUAccessFlags UINT        }
    { MiscFlags      UINT        } ;

COM-INTERFACE: ID3D11Texture3D ID3D11Resource {037e866e-f56d-4357-a8af-9dabbe6e250e}
    void GetDesc ( D3D11_TEXTURE3D_DESC* pDesc ) ;

CONSTANT: D3D11_TEXTURECUBE_FACE_POSITIVE_X   0
CONSTANT: D3D11_TEXTURECUBE_FACE_NEGATIVE_X   1
CONSTANT: D3D11_TEXTURECUBE_FACE_POSITIVE_Y   2
CONSTANT: D3D11_TEXTURECUBE_FACE_NEGATIVE_Y   3
CONSTANT: D3D11_TEXTURECUBE_FACE_POSITIVE_Z   4
CONSTANT: D3D11_TEXTURECUBE_FACE_NEGATIVE_Z   5
TYPEDEF: int D3D11_TEXTURECUBE_FACE

COM-INTERFACE: ID3D11View ID3D11DeviceChild {839d1216-bb2e-412b-b7f4-a9dbebe08ed1}
    void GetResource ( ID3D11Resource** ppResource ) ;

UNION-STRUCT: D3D11_BUFFER_SRV_UNION1
    { FirstElement  UINT }
    { ElementOffset UINT } ;

UNION-STRUCT: D3D11_BUFFER_SRV_UNION2
    { NumElements UINT }
    { ElementWith UINT } ;

STRUCT: D3D11_BUFFER_SRV
    { First  D3D11_BUFFER_SRV_UNION1 }
    { Second D3D11_BUFFER_SRV_UNION2 } ;

CONSTANT: D3D11_BUFFEREX_SRV_FLAG_RAW 1
TYPEDEF: int D3D11_BUFFEREX_SRV_FLAG

STRUCT: D3D11_BUFFEREX_SRV
    { FirstElement UINT }
    { NumElements  UINT }
    { Flags        UINT } ;

STRUCT: D3D11_TEX1D_SRV
    { MostDetailedMip UINT }
    { MipLevels       UINT } ;

STRUCT: D3D11_TEX1D_ARRAY_SRV
    { MostDetailedMip UINT }
    { MipLevels       UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D11_TEX2D_SRV
    { MostDetailedMip UINT }
    { MipLevels       UINT } ;

STRUCT: D3D11_TEX2D_ARRAY_SRV
    { MostDetailedMip UINT }
    { MipLevels       UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D11_TEX3D_SRV
    { MostDetailedMip UINT }
    { MipLevels       UINT } ;

STRUCT: D3D11_TEXCUBE_SRV
    { MostDetailedMip UINT }
    { MipLevels       UINT } ;

STRUCT: D3D11_TEXCUBE_ARRAY_SRV
    { MostDetailedMip  UINT }
    { MipLevels        UINT }
    { First2DArrayFace UINT }
    { NumCubes         UINT } ;

STRUCT: D3D11_TEX2DMS_SRV
    { UnusedField_NothingToDefine UINT } ;

STRUCT: D3D11_TEX2DMS_ARRAY_SRV
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

UNION-STRUCT: D3D11_SHADER_RESOURCE_VIEW_DESC_UNION
    { Buffer           D3D11_BUFFER_SRV        }
    { Texture1D        D3D11_TEX1D_SRV         }
    { Texture1DArray   D3D11_TEX1D_ARRAY_SRV   }
    { Texture2D        D3D11_TEX2D_SRV         }
    { Texture2DArray   D3D11_TEX2D_ARRAY_SRV   }
    { Texture2DMS      D3D11_TEX2DMS_SRV       }
    { Texture2DMSArray D3D11_TEX2DMS_ARRAY_SRV }
    { Texture3D        D3D11_TEX3D_SRV         }
    { TextureCube      D3D11_TEXCUBE_SRV       }
    { TextureCubeArray D3D11_TEXCUBE_ARRAY_SRV }
    { BufferEx         D3D11_BUFFEREX_SRV      } ;

STRUCT: D3D11_SHADER_RESOURCE_VIEW_DESC
    { Format        DXGI_FORMAT                           }
    { ViewDimension D3D11_SRV_DIMENSION                   }
    { View          D3D11_SHADER_RESOURCE_VIEW_DESC_UNION } ;

COM-INTERFACE: ID3D11ShaderResourceView ID3D11View {b0e06fe0-8192-4e1a-b1ca-36d7414710b2}
    void GetDesc ( D3D11_SHADER_RESOURCE_VIEW_DESC* pDesc ) ;

UNION-STRUCT: D3D11_BUFFER_RTV_UNION1
    { FirstElement  UINT }
    { ElementOffset UINT } ;

UNION-STRUCT: D3D11_BUFFER_RTV_UNION2
    { NumElements  UINT }
    { ElementWidth UINT } ;

STRUCT: D3D11_BUFFER_RTV
    { First  D3D11_BUFFER_RTV_UNION1 }
    { Second D3D11_BUFFER_RTV_UNION2 } ;

STRUCT: D3D11_TEX1D_RTV
    { MipSlice UINT } ;

STRUCT: D3D11_TEX1D_ARRAY_RTV
    { MipSlice        UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D11_TEX2D_RTV
    { MipSlice UINT } ;

STRUCT: D3D11_TEX2DMS_RTV
    { UnusedField_NothingToDefine UINT } ;

STRUCT: D3D11_TEX2D_ARRAY_RTV
    { MipSlice        UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D11_TEX2DMS_ARRAY_RTV
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D11_TEX3D_RTV
    { MipSlice    UINT }
    { FirstWSlice UINT }
    { WSize       UINT } ;

UNION-STRUCT: D3D11_RENDER_TARGET_VIEW_DESC_UNION
    { Buffer           D3D11_BUFFER_RTV        }
    { Texture1D        D3D11_TEX1D_RTV         }
    { Texture1DArray   D3D11_TEX1D_ARRAY_RTV   }
    { Texture2D        D3D11_TEX2D_RTV         }
    { Texture2DArray   D3D11_TEX2D_ARRAY_RTV   }
    { Texture2DMS      D3D11_TEX2DMS_RTV       }
    { Texture2DMSArray D3D11_TEX2DMS_ARRAY_RTV }
    { Texture3D        D3D11_TEX3D_RTV         } ;

STRUCT: D3D11_RENDER_TARGET_VIEW_DESC
    { Format        DXGI_FORMAT                         }
    { ViewDimension D3D11_RTV_DIMENSION                 }
    { View          D3D11_RENDER_TARGET_VIEW_DESC_UNION } ;

COM-INTERFACE: ID3D11RenderTargetView ID3D11View {dfdba067-0b8d-4865-875b-d7b4516cc164}
    void GetDesc ( D3D11_RENDER_TARGET_VIEW_DESC* pDesc ) ;

STRUCT: D3D11_TEX1D_DSV
    { MipSlice UINT } ;

STRUCT: D3D11_TEX1D_ARRAY_DSV
    { MipSlice        UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D11_TEX2D_DSV
    { MipSlice UINT } ;

STRUCT: D3D11_TEX2D_ARRAY_DSV
    { MipSlice        UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D11_TEX2DMS_DSV
    { UnusedField_NothingToDefine UINT } ;

STRUCT: D3D11_TEX2DMS_ARRAY_DSV
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

CONSTANT: D3D11_DSV_READ_ONLY_DEPTH 1
CONSTANT: D3D11_DSV_READ_ONLY_STENCIL 2
TYPEDEF: int D3D11_DSV_FLAG

UNION-STRUCT: D3D11_DEPTH_STENCIL_VIEW_DESC_UNION
    { Texture1D        D3D11_TEX1D_DSV         }
    { Texture1DArray   D3D11_TEX1D_ARRAY_DSV   }
    { Texture2D        D3D11_TEX2D_DSV         }
    { Texture2DArray   D3D11_TEX2D_ARRAY_DSV   }
    { Texture2DMS      D3D11_TEX2DMS_DSV       }
    { Texture2DMSArray D3D11_TEX2DMS_ARRAY_DSV } ;

STRUCT: D3D11_DEPTH_STENCIL_VIEW_DESC
    { Format        DXGI_FORMAT                         }
    { ViewDimension D3D11_DSV_DIMENSION                 }
    { Flags         UINT                                }
    { View          D3D11_DEPTH_STENCIL_VIEW_DESC_UNION } ;

COM-INTERFACE: ID3D11DepthStencilView ID3D11View {9fdac92a-1876-48c3-afad-25b94f84a9b6}
    void GetDesc ( D3D11_DEPTH_STENCIL_VIEW_DESC* pDesc ) ;

CONSTANT: D3D11_BUFFER_UAV_FLAG_RAW     1
CONSTANT: D3D11_BUFFER_UAV_FLAG_APPEND  2
CONSTANT: D3D11_BUFFER_UAV_FLAG_COUNTER 4
TYPEDEF: int D3D11_BUFFER_UAV_FLAG

STRUCT: D3D11_BUFFER_UAV
    { FirstElement UINT }
    { NumElements  UINT }
    { Flags        UINT } ;

STRUCT: D3D11_TEX1D_UAV
    { MipSlice UINT } ;

STRUCT: D3D11_TEX1D_ARRAY_UAV
    { MipSlice        UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D11_TEX2D_UAV
    { MipSlice UINT } ;

STRUCT: D3D11_TEX2D_ARRAY_UAV
    { MipSlice        UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D11_TEX3D_UAV
    { MipSlice    UINT }
    { FirstWSlice UINT }
    { WSize       UINT } ;

UNION-STRUCT: D3D11_UNORDERED_ACCESS_VIEW_DESC_UNION
    { Buffer         D3D11_BUFFER_UAV      }
    { Texture1D      D3D11_TEX1D_UAV       }
    { Texture1DArray D3D11_TEX1D_ARRAY_UAV }
    { Texture2D      D3D11_TEX2D_UAV       }
    { Texture2DArray D3D11_TEX2D_ARRAY_UAV }
    { Texture3D      D3D11_TEX3D_UAV       } ;

STRUCT: D3D11_UNORDERED_ACCESS_VIEW_DESC
    { Format        DXGI_FORMAT                            }
    { ViewDimension D3D11_UAV_DIMENSION                    }
    { View          D3D11_UNORDERED_ACCESS_VIEW_DESC_UNION } ;


COM-INTERFACE: ID3D11UnorderedAccessView ID3D11View {28acf509-7f5c-48f6-8611-f316010a6380}
    void GetDesc ( D3D11_UNORDERED_ACCESS_VIEW_DESC* pDesc ) ;

COM-INTERFACE: ID3D11VertexShader ID3D11DeviceChild {3b301d64-d678-4289-8897-22f8928b72f3} ;

COM-INTERFACE: ID3D11HullShader ID3D11DeviceChild {8e5c6061-628a-4c8e-8264-bbe45cb3d5dd} ;

COM-INTERFACE: ID3D11DomainShader ID3D11DeviceChild {f582c508-0f36-490c-9977-31eece268cfa} ;

COM-INTERFACE: ID3D11GeometryShader ID3D11DeviceChild {38325b96-effb-4022-ba02-2e795b70275c} ;

COM-INTERFACE: ID3D11PixelShader ID3D11DeviceChild {ea82e40d-51dc-4f33-93d4-db7c9125ae8c} ;

COM-INTERFACE: ID3D11ComputeShader ID3D11DeviceChild {4f5b196e-c2bd-495e-bd01-1fded38e4969} ;

COM-INTERFACE: ID3D11InputLayout ID3D11DeviceChild {e4819ddc-4cf0-4025-bd26-5de82a3e07b7} ;

CONSTANT: D3D11_FILTER_MIN_MAG_MIP_POINT                          0x0
CONSTANT: D3D11_FILTER_MIN_MAG_POINT_MIP_LINEAR                   0x1
CONSTANT: D3D11_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT             0x4
CONSTANT: D3D11_FILTER_MIN_POINT_MAG_MIP_LINEAR                   0x5
CONSTANT: D3D11_FILTER_MIN_LINEAR_MAG_MIP_POINT                   0x10
CONSTANT: D3D11_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR            0x11
CONSTANT: D3D11_FILTER_MIN_MAG_LINEAR_MIP_POINT                   0x14
CONSTANT: D3D11_FILTER_MIN_MAG_MIP_LINEAR                         0x15
CONSTANT: D3D11_FILTER_ANISOTROPIC                                0x55
CONSTANT: D3D11_FILTER_COMPARISON_MIN_MAG_MIP_POINT               0x80
CONSTANT: D3D11_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR        0x81
CONSTANT: D3D11_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT  0x84
CONSTANT: D3D11_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR        0x85
CONSTANT: D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT        0x90
CONSTANT: D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR 0x91
CONSTANT: D3D11_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT        0x94
CONSTANT: D3D11_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR              0x95
CONSTANT: D3D11_FILTER_COMPARISON_ANISOTROPIC                     0xd5
TYPEDEF: int D3D11_FILTER

CONSTANT: D3D11_FILTER_TYPE_POINT  0
CONSTANT: D3D11_FILTER_TYPE_LINEAR 1
TYPEDEF: int D3D11_FILTER_TYPE;

CONSTANT: D3D11_FILTER_TYPE_MASK 3
CONSTANT: D3D11_MIN_FILTER_SHIFT 4
CONSTANT: D3D11_MAG_FILTER_SHIFT 2
CONSTANT: D3D11_MIP_FILTER_SHIFT 0
CONSTANT: D3D11_COMPARISON_FILTERING_BIT  0x80
CONSTANT: D3D11_ANISOTROPIC_FILTERING_BIT 0x40

CONSTANT: D3D11_TEXTURE_ADDRESS_WRAP        1
CONSTANT: D3D11_TEXTURE_ADDRESS_MIRROR      2
CONSTANT: D3D11_TEXTURE_ADDRESS_CLAMP       3
CONSTANT: D3D11_TEXTURE_ADDRESS_BORDER      4
CONSTANT: D3D11_TEXTURE_ADDRESS_MIRROR_ONCE 5
TYPEDEF: int D3D11_TEXTURE_ADDRESS_MODE

STRUCT: D3D11_SAMPLER_DESC
    { Filter         D3D11_FILTER               }
    { AddressU       D3D11_TEXTURE_ADDRESS_MODE }
    { AddressV       D3D11_TEXTURE_ADDRESS_MODE }
    { AddressW       D3D11_TEXTURE_ADDRESS_MODE }
    { MipLODBias     FLOAT                      }
    { MaxAnisotropy  UINT                       }
    { ComparisonFunc D3D11_COMPARISON_FUNC      }
    { BorderColor    FLOAT[4]                   }
    { MinLOD         FLOAT                      }
    { MaxLOD         FLOAT                      } ;

COM-INTERFACE: ID3D11SamplerState ID3D11DeviceChild {da6fea51-564c-4487-9810-f0d0f9b4e3a5}
    void GetDesc ( D3D11_SAMPLER_DESC* pDesc ) ;

CONSTANT: D3D11_FORMAT_SUPPORT_BUFFER                         0x1
CONSTANT: D3D11_FORMAT_SUPPORT_IA_VERTEX_BUFFER               0x2
CONSTANT: D3D11_FORMAT_SUPPORT_IA_INDEX_BUFFER                0x4
CONSTANT: D3D11_FORMAT_SUPPORT_SO_BUFFER                      0x8
CONSTANT: D3D11_FORMAT_SUPPORT_TEXTURE1D                      0x10
CONSTANT: D3D11_FORMAT_SUPPORT_TEXTURE2D                      0x20
CONSTANT: D3D11_FORMAT_SUPPORT_TEXTURE3D                      0x40
CONSTANT: D3D11_FORMAT_SUPPORT_TEXTURECUBE                    0x80
CONSTANT: D3D11_FORMAT_SUPPORT_SHADER_LOAD                    0x100
CONSTANT: D3D11_FORMAT_SUPPORT_SHADER_SAMPLE                  0x200
CONSTANT: D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_COMPARISON       0x400
CONSTANT: D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_MONO_TEXT        0x800
CONSTANT: D3D11_FORMAT_SUPPORT_MIP                            0x1000
CONSTANT: D3D11_FORMAT_SUPPORT_MIP_AUTOGEN                    0x2000
CONSTANT: D3D11_FORMAT_SUPPORT_RENDER_TARGET                  0x4000
CONSTANT: D3D11_FORMAT_SUPPORT_BLENDABLE                      0x8000
CONSTANT: D3D11_FORMAT_SUPPORT_DEPTH_STENCIL                  0x10000
CONSTANT: D3D11_FORMAT_SUPPORT_CPU_LOCKABLE                   0x20000
CONSTANT: D3D11_FORMAT_SUPPORT_MULTISAMPLE_RESOLVE            0x40000
CONSTANT: D3D11_FORMAT_SUPPORT_DISPLAY                        0x80000
CONSTANT: D3D11_FORMAT_SUPPORT_CAST_WITHIN_BIT_LAYOUT         0x100000
CONSTANT: D3D11_FORMAT_SUPPORT_MULTISAMPLE_RENDERTARGET       0x200000
CONSTANT: D3D11_FORMAT_SUPPORT_MULTISAMPLE_LOAD               0x400000
CONSTANT: D3D11_FORMAT_SUPPORT_SHADER_GATHER                  0x800000
CONSTANT: D3D11_FORMAT_SUPPORT_BACK_BUFFER_CAST               0x1000000
CONSTANT: D3D11_FORMAT_SUPPORT_TYPED_UNORDERED_ACCESS_VIEW    0x2000000
CONSTANT: D3D11_FORMAT_SUPPORT_SHADER_GATHER_COMPARISON       0x4000000
TYPEDEF: int D3D11_FORMAT_SUPPORT

CONSTANT: D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_ADD                                0x1
CONSTANT: D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_BITWISE_OPS                        0x2
CONSTANT: D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_COMPARE_STORE_OR_COMPARE_EXCHANGE  0x4
CONSTANT: D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_EXCHANGE                           0x8
CONSTANT: D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_SIGNED_MIN_OR_MAX                  0x10
CONSTANT: D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_UNSIGNED_MIN_OR_MAX                0x20
CONSTANT: D3D11_FORMAT_SUPPORT2_UAV_TYPED_LOAD                                0x40
CONSTANT: D3D11_FORMAT_SUPPORT2_UAV_TYPED_STORE                               0x80
TYPEDEF: int D3D11_FORMAT_SUPPORT2

COM-INTERFACE: ID3D11Asynchronous ID3D11DeviceChild {4b35d0cd-1e15-4258-9c98-1b1333f6dd3b}
    UINT GetDataSize ( ) ;

CONSTANT: D3D11_ASYNC_GETDATA_DONOTFLUSH 1
TYPEDEF: int D3D11_ASYNC_GETDATA_FLAG

CONSTANT: D3D11_QUERY_EVENT                           0
CONSTANT: D3D11_QUERY_OCCLUSION                       1
CONSTANT: D3D11_QUERY_TIMESTAMP                       2
CONSTANT: D3D11_QUERY_TIMESTAMP_DISJOINT              3
CONSTANT: D3D11_QUERY_PIPELINE_STATISTICS             4
CONSTANT: D3D11_QUERY_OCCLUSION_PREDICATE             5
CONSTANT: D3D11_QUERY_SO_STATISTICS                   6
CONSTANT: D3D11_QUERY_SO_OVERFLOW_PREDICATE           7
CONSTANT: D3D11_QUERY_SO_STATISTICS_STREAM0           8
CONSTANT: D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM0   9
CONSTANT: D3D11_QUERY_SO_STATISTICS_STREAM1           10
CONSTANT: D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM1   11
CONSTANT: D3D11_QUERY_SO_STATISTICS_STREAM2           12
CONSTANT: D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM2   13
CONSTANT: D3D11_QUERY_SO_STATISTICS_STREAM3           14
CONSTANT: D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM3   15
TYPEDEF: int D3D11_QUERY

CONSTANT: D3D11_QUERY_MISC_PREDICATEHINT 1
TYPEDEF: int D3D11_QUERY_MISC_FLAG

STRUCT: D3D11_QUERY_DESC
    { Query     D3D11_QUERY }
    { MiscFlags UINT        } ;

COM-INTERFACE: ID3D11Query ID3D11Asynchronous {d6c00747-87b7-425e-b84d-44d108560afd}
    void GetDesc ( D3D11_QUERY_DESC* pDesc ) ;

COM-INTERFACE: ID3D11Predicate ID3D11Query {9eb576dd-9f77-4d86-81aa-8bab5fe490e2} ;

STRUCT: D3D11_QUERY_DATA_TIMESTAMP_DISJOINT
    { Frequency UINT64 }
    { Disjoint  BOOL   } ;

STRUCT: D3D11_QUERY_DATA_PIPELINE_STATISTICS
    { IAVertices    UINT64 }
    { IAPrimitives  UINT64 }
    { VSInvocations UINT64 }
    { GSInvocations UINT64 }
    { GSPrimitives  UINT64 }
    { CInvocations  UINT64 }
    { CPrimitives   UINT64 }
    { PSInvocations UINT64 }
    { HSInvocations UINT64 }
    { DSInvocations UINT64 }
    { CSInvocations UINT64 } ;

STRUCT: D3D11_QUERY_DATA_SO_STATISTICS
    { NumPrimitivesWritten    UINT64 }
    { PrimitivesStorageNeeded UINT64 } ;

CONSTANT: D3D11_COUNTER_DEVICE_DEPENDENT_0 0x40000000
TYPEDEF: int D3D11_COUNTER

CONSTANT: D3D11_COUNTER_TYPE_FLOAT32 0
CONSTANT: D3D11_COUNTER_TYPE_UINT16  1
CONSTANT: D3D11_COUNTER_TYPE_UINT32  2
CONSTANT: D3D11_COUNTER_TYPE_UINT64  3
TYPEDEF: int D3D11_COUNTER_TYPE

STRUCT: D3D11_COUNTER_DESC
    { Counter   D3D11_COUNTER }
    { MiscFlags UINT          } ;

STRUCT: D3D11_COUNTER_INFO
    { LastDeviceDependentCounter D3D11_COUNTER }
    { NumSimultaneousCounters    UINT          }
    { NumDetectableParallelUnits BYTE         } ;

COM-INTERFACE: ID3D11Counter ID3D11Asynchronous {6e8c49fb-a371-4770-b440-29086022b741}
    void GetDesc ( D3D11_COUNTER_DESC* pDesc ) ;

CONSTANT: D3D11_STANDARD_MULTISAMPLE_PATTERN 0xffffffff
CONSTANT: D3D11_CENTER_MULTISAMPLE_PATTERN   0xfffffffe
TYPEDEF: int D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS

CONSTANT: D3D11_DEVICE_CONTEXT_IMMEDIATE 0
CONSTANT: D3D11_DEVICE_CONTEXT_DEFERRED  1
TYPEDEF: int D3D11_DEVICE_CONTEXT_TYPE

STRUCT: D3D11_CLASS_INSTANCE_DESC
    { InstanceId               UINT }
    { InstanceIndex            UINT }
    { TypeId                   UINT }
    { ConstantBuffer           UINT }
    { BaseConstantBufferOffset UINT }
    { BaseTexture              UINT }
    { BaseSampler              UINT }
    { Created                  BOOL } ;

COM-INTERFACE: ID3D11ClassInstance ID3D11DeviceChild {a6cd7faa-b0b7-4a2f-9436-8662a65797cb}
    void GetClassLinkage ( ID3D11ClassLinkage** ppLinkage )
    void GetDesc ( D3D11_CLASS_INSTANCE_DESC* pDesc )
    void GetInstanceName ( LPSTR pInstanceName, SIZE_T* pBufferLength )
    void GetTypeName ( LPSTR pTypeName, SIZE_T* pBufferLength ) ;

COM-INTERFACE: ID3D11ClassLinkage ID3D11DeviceChild {ddf57cba-9543-46e4-a12b-f207a0fe7fed}
    HRESULT GetClassInstance ( LPCSTR pClassInstanceName, UINT InstanceIndex, ID3D11ClassInstance** ppInstance )
    HRESULT CreateClassInstance ( LPCSTR pClassTypeName, UINT ConstantBufferOffset, UINT ConstantVectorOffset, UINT TextureOffset, UINT SamplerOffset, ID3D11ClassInstance** ppInstance ) ;

COM-INTERFACE: ID3D11CommandList ID3D11DeviceChild {a24bc4d1-769e-43f7-8013-98ff566c18e2}
    UINT GetContextFlags ( ) ;

CONSTANT: D3D11_FEATURE_THREADING                 0
CONSTANT: D3D11_FEATURE_DOUBLES                   1
CONSTANT: D3D11_FEATURE_FORMAT_SUPPORT            2
CONSTANT: D3D11_FEATURE_FORMAT_SUPPORT2           3
CONSTANT: D3D11_FEATURE_D3D10_X_HARDWARE_OPTIONS  4
TYPEDEF: int D3D11_FEATURE

STRUCT: D3D11_FEATURE_DATA_THREADING
    { DriverConcurrentCreates BOOL }
    { DriverCommandLists      BOOL } ;

STRUCT: D3D11_FEATURE_DATA_DOUBLES
    { DoublePrecisionFloatShaderOps BOOL } ;

STRUCT: D3D11_FEATURE_DATA_FORMAT_SUPPORT
    { InFormat         DXGI_FORMAT }
    { OutFormatSupport UINT        } ;

STRUCT: D3D11_FEATURE_DATA_FORMAT_SUPPORT2
    { InFormat          DXGI_FORMAT }
    { OutFormatSupport2 UINT        } ;

STRUCT: D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS
    { ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x BOOL } ;

COM-INTERFACE: ID3D11DeviceContext ID3D11DeviceChild {c0bfa96c-e089-44fb-8eaf-26f8796190da}
    void VSSetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppConstantBuffers )
    void PSSetShaderResources ( UINT StartSlot, UINT NumViews, ID3D11ShaderResourceView** ppShaderResourceViews )
    void PSSetShader ( ID3D11PixelShader* pPixelShader, ID3D11ClassInstance** ppClassInstances, UINT NumClassInstances )
    void PSSetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D11SamplerState** ppSamplers )
    void VSSetShader ( ID3D11VertexShader* pVertexShader, ID3D11ClassInstance** ppClassInstances, UINT NumClassInstances )
    void DrawIndexed ( UINT IndexCount, UINT StartIndexLocation, INT BaseVertexLocation )
    void Draw ( UINT VertexCount, UINT StartVertexLocation )
    HRESULT Map ( ID3D11Resource* pResource, UINT Subresource, D3D11_MAP MapType, UINT MapFlags, D3D11_MAPPED_SUBRESOURCE* pMappedResource )
    void Unmap ( ID3D11Resource* pResource, UINT Subresource )
    void PSSetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppConstantBuffers )
    void IASetInputLayout ( ID3D11InputLayout* pInputLayout )
    void IASetVertexBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppVertexBuffers, UINT* pStrides, UINT* pOffsets )
    void IASetIndexBuffer ( ID3D11Buffer* pIndexBuffer, DXGI_FORMAT Format, UINT Offset )
    void DrawIndexedInstanced ( UINT IndexCountPerInstance, UINT InstanceCount, UINT StartIndexLocation, INT BaseVertexLocation, UINT StartInstanceLocation )
    void DrawInstanced ( UINT VertexCountPerInstance, UINT InstanceCount, UINT StartVertexLocation, UINT StartInstanceLocation )
    void GSSetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppConstantBuffers )
    void GSSetShader ( ID3D11GeometryShader* pShader, ID3D11ClassInstance** ppClassInstances, UINT NumClassInstances )
    void IASetPrimitiveTopology ( D3D11_PRIMITIVE_TOPOLOGY Topology )
    void VSSetShaderResources ( UINT StartSlot, UINT NumViews, ID3D11ShaderResourceView** ppShaderResourceViews )
    void VSSetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D11SamplerState** ppSamplers )
    void Begin ( ID3D11Asynchronous* pAsync )
    void End ( ID3D11Asynchronous* pAsync )
    HRESULT GetData ( ID3D11Asynchronous* pAsync, void* pData, UINT DataSize, UINT GetDataFlags )
    void SetPredication ( ID3D11Predicate* pPredicate, BOOL PredicateValue )
    void GSSetShaderResources ( UINT StartSlot, UINT NumViews, ID3D11ShaderResourceView** ppShaderResourceViews )
    void GSSetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D11SamplerState** ppSamplers )
    void OMSetRenderTargets ( UINT NumViews, ID3D11RenderTargetView** ppRenderTargetViews, ID3D11DepthStencilView* pDepthStencilView )
    void OMSetRenderTargetsAndUnorderedAccessViews ( UINT NumRTVs, ID3D11RenderTargetView** ppRenderTargetViews, ID3D11DepthStencilView* pDepthStencilView, UINT UAVStartSlot, UINT NumUAVs, ID3D11UnorderedAccessView** ppUnorderedAccessViews, UINT* pUAVInitialCounts )
    void OMSetBlendState ( ID3D11BlendState* pBlendState, FLOAT[4] BlendFactor, UINT SampleMask )
    void OMSetDepthStencilState ( ID3D11DepthStencilState* pDepthStencilState, UINT StencilRef )
    void SOSetTargets ( UINT NumBuffers, ID3D11Buffer** ppSOTargets, UINT* pOffsets )
    void DrawAuto ( )
    void DrawIndexedInstancedIndirect ( ID3D11Buffer* pBufferForArgs, UINT AlignedByteOffsetForArgs )
    void DrawInstancedIndirect ( ID3D11Buffer* pBufferForArgs, UINT AlignedByteOffsetForArgs )
    void Dispatch ( UINT ThreadGroupCountX, UINT ThreadGroupCountY, UINT ThreadGroupCountZ )
    void DispatchIndirect ( ID3D11Buffer* pBufferForArgs, UINT AlignedByteOffsetForArgs )
    void RSSetState ( ID3D11RasterizerState* pRasterizerState )
    void RSSetViewports ( UINT NumViewports, D3D11_VIEWPORT* pViewports )
    void RSSetScissorRects ( UINT NumRects, D3D11_RECT* pRects )
    void CopySubresourceRegion ( ID3D11Resource* pDstResource, UINT DstSubresource, UINT DstX, UINT DstY, UINT DstZ, ID3D11Resource* pSrcResource, UINT SrcSubresource, D3D11_BOX* pSrcBox )
    void CopyResource ( ID3D11Resource* pDstResource, ID3D11Resource* pSrcResource )
    void UpdateSubresource ( ID3D11Resource* pDstResource, UINT DstSubresource, D3D11_BOX* pDstBox, void* pSrcData, UINT SrcRowPitch, UINT SrcDepthPitch )
    void CopyStructureCount ( ID3D11Buffer* pDstBuffer, UINT DstAlignedByteOffset, ID3D11UnorderedAccessView* pSrcView )
    void ClearRenderTargetView ( ID3D11RenderTargetView* pRenderTargetView, FLOAT[4] ColorRGBA )
    void ClearUnorderedAccessViewUint ( ID3D11UnorderedAccessView* pUnorderedAccessView, UINT[4] Values )
    void ClearUnorderedAccessViewFloat ( ID3D11UnorderedAccessView* pUnorderedAccessView, FLOAT[4] Values )
    void ClearDepthStencilView ( ID3D11DepthStencilView* pDepthStencilView, UINT ClearFlags, FLOAT Depth, BYTE Stencil )
    void GenerateMips ( ID3D11ShaderResourceView* pShaderResourceView )
    void SetResourceMinLOD ( ID3D11Resource* pResource, FLOAT MinLOD )
    FLOAT GetResourceMinLOD ( ID3D11Resource* pResource )
    void ResolveSubresource ( ID3D11Resource* pDstResource, UINT DstSubresource, ID3D11Resource* pSrcResource, UINT SrcSubresource, DXGI_FORMAT Format )
    void ExecuteCommandList ( ID3D11CommandList* pCommandList, BOOL RestoreContextState )
    void HSSetShaderResources ( UINT StartSlot, UINT NumViews, ID3D11ShaderResourceView** ppShaderResourceViews )
    void HSSetShader ( ID3D11HullShader* pHullShader, ID3D11ClassInstance** ppClassInstances, UINT NumClassInstances )
    void HSSetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D11SamplerState** ppSamplers )
    void HSSetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppConstantBuffers )
    void DSSetShaderResources ( UINT StartSlot, UINT NumViews, ID3D11ShaderResourceView** ppShaderResourceViews )
    void DSSetShader ( ID3D11DomainShader* pDomainShader, ID3D11ClassInstance** ppClassInstances, UINT NumClassInstances )
    void DSSetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D11SamplerState** ppSamplers )
    void DSSetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppConstantBuffers )
    void CSSetShaderResources ( UINT StartSlot, UINT NumViews, ID3D11ShaderResourceView** ppShaderResourceViews )
    void CSSetUnorderedAccessViews ( UINT StartSlot, UINT NumUAVs, ID3D11UnorderedAccessView** ppUnorderedAccessViews, UINT* pUAVInitialCounts )
    void CSSetShader ( ID3D11ComputeShader* pComputeShader, ID3D11ClassInstance** ppClassInstances, UINT NumClassInstances )
    void CSSetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D11SamplerState** ppSamplers )
    void CSSetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppConstantBuffers )
    void VSGetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppConstantBuffers )
    void PSGetShaderResources ( UINT StartSlot, UINT NumViews, ID3D11ShaderResourceView** ppShaderResourceViews )
    void PSGetShader ( ID3D11PixelShader** ppPixelShader, ID3D11ClassInstance** ppClassInstances, UINT* pNumClassInstances )
    void PSGetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D11SamplerState** ppSamplers )
    void VSGetShader ( ID3D11VertexShader** ppVertexShader, ID3D11ClassInstance** ppClassInstances, UINT* pNumClassInstances )
    void PSGetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppConstantBuffers )
    void IAGetInputLayout ( ID3D11InputLayout** ppInputLayout )
    void IAGetVertexBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppVertexBuffers, UINT* pStrides, UINT* pOffsets )
    void IAGetIndexBuffer ( ID3D11Buffer** pIndexBuffer, DXGI_FORMAT* Format, UINT* Offset )
    void GSGetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppConstantBuffers )
    void GSGetShader ( ID3D11GeometryShader** ppGeometryShader, ID3D11ClassInstance** ppClassInstances, UINT* pNumClassInstances )
    void IAGetPrimitiveTopology ( D3D11_PRIMITIVE_TOPOLOGY* pTopology )
    void VSGetShaderResources ( UINT StartSlot, UINT NumViews, ID3D11ShaderResourceView** ppShaderResourceViews )
    void VSGetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D11SamplerState** ppSamplers )
    void GetPredication ( ID3D11Predicate** ppPredicate, BOOL* pPredicateValue )
    void GSGetShaderResources ( UINT StartSlot, UINT NumViews, ID3D11ShaderResourceView** ppShaderResourceViews )
    void GSGetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D11SamplerState** ppSamplers )
    void OMGetRenderTargets ( UINT NumViews, ID3D11RenderTargetView** ppRenderTargetViews, ID3D11DepthStencilView** ppDepthStencilView )
    void OMGetRenderTargetsAndUnorderedAccessViews ( UINT NumRTVs, ID3D11RenderTargetView** ppRenderTargetViews, ID3D11DepthStencilView** ppDepthStencilView, UINT UAVStartSlot, UINT NumUAVs, ID3D11UnorderedAccessView** ppUnorderedAccessViews )
    void OMGetBlendState ( ID3D11BlendState** ppBlendState, FLOAT[4] BlendFactor, UINT* pSampleMask )
    void OMGetDepthStencilState ( ID3D11DepthStencilState** ppDepthStencilState, UINT* pStencilRef )
    void SOGetTargets ( UINT NumBuffers, ID3D11Buffer** ppSOTargets )
    void RSGetState ( ID3D11RasterizerState** ppRasterizerState )
    void RSGetViewports ( UINT* pNumViewports, D3D11_VIEWPORT* pViewports )
    void RSGetScissorRects ( UINT* pNumRects, D3D11_RECT* pRects )
    void HSGetShaderResources ( UINT StartSlot, UINT NumViews, ID3D11ShaderResourceView** ppShaderResourceViews )
    void HSGetShader ( ID3D11HullShader** ppHullShader, ID3D11ClassInstance** ppClassInstances, UINT* pNumClassInstances )
    void HSGetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D11SamplerState** ppSamplers )
    void HSGetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppConstantBuffers )
    void DSGetShaderResources ( UINT StartSlot, UINT NumViews, ID3D11ShaderResourceView** ppShaderResourceViews )
    void DSGetShader ( ID3D11DomainShader** ppDomainShader, ID3D11ClassInstance** ppClassInstances, UINT* pNumClassInstances )
    void DSGetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D11SamplerState** ppSamplers )
    void DSGetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppConstantBuffers )
    void CSGetShaderResources ( UINT StartSlot, UINT NumViews, ID3D11ShaderResourceView** ppShaderResourceViews )
    void CSGetUnorderedAccessViews ( UINT StartSlot, UINT NumUAVs, ID3D11UnorderedAccessView** ppUnorderedAccessViews )
    void CSGetShader ( ID3D11ComputeShader** ppComputeShader, ID3D11ClassInstance** ppClassInstances, UINT* pNumClassInstances )
    void CSGetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D11SamplerState** ppSamplers )
    void CSGetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D11Buffer** ppConstantBuffers )
    void ClearState ( )
    void Flush ( )
    D3D11_DEVICE_CONTEXT_TYPE GetType ( )
    UINT GetContextFlags ( )
    HRESULT FinishCommandList ( BOOL RestoreDeferredContextState, ID3D11CommandList** ppCommandList ) ;

COM-INTERFACE: ID3D11Device IUnknown {db6f6ddb-ac77-4e88-8253-819df9bbf140}
    HRESULT CreateBuffer ( D3D11_BUFFER_DESC* pDesc, D3D11_SUBRESOURCE_DATA* pInitialData, ID3D11Buffer** ppBuffer )
    HRESULT CreateTexture1D ( D3D11_TEXTURE1D_DESC* pDesc, D3D11_SUBRESOURCE_DATA* pInitialData, ID3D11Texture1D** ppTexture1D )
    HRESULT CreateTexture2D ( D3D11_TEXTURE2D_DESC* pDesc, D3D11_SUBRESOURCE_DATA* pInitialData, ID3D11Texture2D** ppTexture2D )
    HRESULT CreateTexture3D ( D3D11_TEXTURE3D_DESC* pDesc, D3D11_SUBRESOURCE_DATA* pInitialData, ID3D11Texture3D** ppTexture3D )
    HRESULT CreateShaderResourceView ( ID3D11Resource* pResource, D3D11_SHADER_RESOURCE_VIEW_DESC* pDesc, ID3D11ShaderResourceView** ppSRView )
    HRESULT CreateUnorderedAccessView ( ID3D11Resource* pResource, D3D11_UNORDERED_ACCESS_VIEW_DESC* pDesc, ID3D11UnorderedAccessView** ppUAView )
    HRESULT CreateRenderTargetView ( ID3D11Resource* pResource, D3D11_RENDER_TARGET_VIEW_DESC* pDesc, ID3D11RenderTargetView** ppRTView )
    HRESULT CreateDepthStencilView ( ID3D11Resource* pResource, D3D11_DEPTH_STENCIL_VIEW_DESC* pDesc, ID3D11DepthStencilView** ppDepthStencilView )
    HRESULT CreateInputLayout ( D3D11_INPUT_ELEMENT_DESC* pInputElementDescs, UINT NumElements, void* pShaderBytecodeWithInputSignature, SIZE_T BytecodeLength, ID3D11InputLayout** ppInputLayout )
    HRESULT CreateVertexShader ( void* pShaderBytecode, SIZE_T BytecodeLength, ID3D11ClassLinkage* pClassLinkage, ID3D11VertexShader** ppVertexShader )
    HRESULT CreateGeometryShader ( void* pShaderBytecode, SIZE_T BytecodeLength, ID3D11ClassLinkage* pClassLinkage, ID3D11GeometryShader** ppGeometryShader )
    HRESULT CreateGeometryShaderWithStreamOutput ( void* pShaderBytecode, SIZE_T BytecodeLength, D3D11_SO_DECLARATION_ENTRY* pSODeclaration, UINT NumEntries, UINT* pBufferStrides, UINT NumStrides, UINT RasterizedStream, ID3D11ClassLinkage* pClassLinkage, ID3D11GeometryShader** ppGeometryShader )
    HRESULT CreatePixelShader ( void* pShaderBytecode, SIZE_T BytecodeLength, ID3D11ClassLinkage* pClassLinkage, ID3D11PixelShader** ppPixelShader )
    HRESULT CreateHullShader ( void* pShaderBytecode, SIZE_T BytecodeLength, ID3D11ClassLinkage* pClassLinkage, ID3D11HullShader** ppHullShader )
    HRESULT CreateDomainShader ( void* pShaderBytecode, SIZE_T BytecodeLength, ID3D11ClassLinkage* pClassLinkage, ID3D11DomainShader** ppDomainShader )
    HRESULT CreateComputeShader ( void* pShaderBytecode, SIZE_T BytecodeLength, ID3D11ClassLinkage* pClassLinkage, ID3D11ComputeShader** ppComputeShader )
    HRESULT CreateClassLinkage ( ID3D11ClassLinkage** ppLinkage )
    HRESULT CreateBlendState ( D3D11_BLEND_DESC* pBlendStateDesc, ID3D11BlendState** ppBlendState )
    HRESULT CreateDepthStencilState ( D3D11_DEPTH_STENCIL_DESC* pDepthStencilDesc, ID3D11DepthStencilState** ppDepthStencilState )
    HRESULT CreateRasterizerState ( D3D11_RASTERIZER_DESC* pRasterizerDesc, ID3D11RasterizerState** ppRasterizerState )
    HRESULT CreateSamplerState ( D3D11_SAMPLER_DESC* pSamplerDesc, ID3D11SamplerState** ppSamplerState )
    HRESULT CreateQuery ( D3D11_QUERY_DESC* pQueryDesc, ID3D11Query** ppQuery )
    HRESULT CreatePredicate ( D3D11_QUERY_DESC* pPredicateDesc, ID3D11Predicate** ppPredicate )
    HRESULT CreateCounter ( D3D11_COUNTER_DESC* pCounterDesc, ID3D11Counter** ppCounter )
    HRESULT CreateDeferredContext ( UINT ContextFlags, ID3D11DeviceContext** ppDeferredContext )
    HRESULT OpenSharedResource ( HANDLE hResource, REFIID ReturnedInterface, void** ppResource )
    HRESULT CheckFormatSupport ( DXGI_FORMAT Format, UINT* pFormatSupport )
    HRESULT CheckMultisampleQualityLevels ( DXGI_FORMAT Format, UINT SampleCount, UINT* pNumQualityLevels )
    void CheckCounterInfo ( D3D11_COUNTER_INFO* pCounterInfo )
    HRESULT CheckCounter ( D3D11_COUNTER_DESC* pDesc, D3D11_COUNTER_TYPE* pType, UINT* pActiveCounters, LPSTR szName, UINT* pNameLength, LPSTR szUnits, UINT* pUnitsLength, LPSTR szDescription, UINT* pDescriptionLength )
    HRESULT CheckFeatureSupport ( D3D11_FEATURE Feature, void* pFeatureSupportData, UINT FeatureSupportDataSize )
    HRESULT GetPrivateData ( REFGUID guid, UINT* pDataSize, void* pData )
    HRESULT SetPrivateData ( REFGUID guid, UINT DataSize, void* pData )
    HRESULT SetPrivateDataInterface ( REFGUID guid, IUnknown* pData )
    D3D_FEATURE_LEVEL GetFeatureLevel ( )
    UINT GetCreationFlags ( )
    HRESULT GetDeviceRemovedReason ( )
    void GetImmediateContext ( ID3D11DeviceContext** ppImmediateContext )
    HRESULT SetExceptionMode ( UINT RaiseFlags )
    UINT GetExceptionMode ( ) ;

CONSTANT: D3D11_CREATE_DEVICE_SINGLETHREADED                              1
CONSTANT: D3D11_CREATE_DEVICE_DEBUG                                       2
CONSTANT: D3D11_CREATE_DEVICE_SWITCH_TO_REF                               4
CONSTANT: D3D11_CREATE_DEVICE_PREVENT_INTERNAL_THREADING_OPTIMIZATIONS    8
CONSTANT: D3D11_CREATE_DEVICE_BGRA_SUPPORT                                32
TYPEDEF: int D3D11_CREATE_DEVICE_FLAG;

CONSTANT: D3D11_SDK_VERSION 7

FUNCTION: HRESULT D3D11CreateDevice (
    IDXGIAdapter*         pAdapter,
    D3D_DRIVER_TYPE       DriverType,
    HMODULE               Software,
    UINT                  Flags,
    D3D_FEATURE_LEVEL*    pFeatureLevels,
    UINT                  FeatureLevels,
    UINT                  SDKVersion,
    ID3D11Device**        ppDevice,
    D3D_FEATURE_LEVEL*    pFeatureLevel,
    ID3D11DeviceContext** ppImmediateContext ) ;

FUNCTION: HRESULT D3D11CreateDeviceAndSwapChain (
    IDXGIAdapter*         pAdapter,
    D3D_DRIVER_TYPE       DriverType,
    HMODULE               Software,
    UINT                  Flags,
    D3D_FEATURE_LEVEL*    pFeatureLevels,
    UINT                  FeatureLevels,
    UINT                  SDKVersion,
    DXGI_SWAP_CHAIN_DESC* pSwapChainDesc,
    IDXGISwapChain**      ppSwapChain,
    ID3D11Device**        ppDevice,
    D3D_FEATURE_LEVEL*    pFeatureLevel,
    ID3D11DeviceContext** ppImmediateContext ) ;
