// (c) Microsoft Corporation 2005-2007.  

#light

namespace Microsoft.FSharp.Control

#nowarn "0057";; // active patterns

open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Control
open Microsoft.FSharp.Collections

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Lazy = 

    type 'a t = 'a Lazy

    exception Undefined = Microsoft.FSharp.Control.Undefined

    let force_with_lock (x: 'a t) = x.SynchronizedForce()
    let force_without_lock (x: 'a t) = x.Force()
    let force (x: 'a t) = force_without_lock x
    let force_val (x: 'a t) = x.Force()
    let lazy_from_fun f = {status=(LazyStatus.Delayed f)}
    let lazy_from_val v = {status=(LazyStatus.Value v)}
    let lazy_is_val x = match x.status with LazyStatus.Value _ -> true | _ -> false
    let (|Lazy|) x = force x
