/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaProperty;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.GeneratedSubclass;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.extensibility.ConventionAwareHelper;
import org.gradle.internal.instantiation.AbstractClassGenerator;
import org.gradle.internal.instantiation.ClassGenerationException;
import org.gradle.internal.instantiation.ClassGenerator;
import org.gradle.internal.instantiation.InjectAnnotationHandler;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.instantiation.ManagedTypeFactory;
import org.gradle.internal.instantiation.MixInExtensibleDynamicObject;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.state.Managed;
import org.gradle.model.internal.asm.AsmClassGenerator;
import org.gradle.model.internal.asm.AsmClassGeneratorUtils;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class AsmBackedClassGenerator
extends AbstractClassGenerator {
    private static final ThreadLocal<ObjectCreationDetails> SERVICES_FOR_NEXT_OBJECT = new ThreadLocal();
    private final boolean decorate;
    private final String suffix;
    private final Integer key;

    public static ServiceLookup getServicesForNext() {
        return AsmBackedClassGenerator.SERVICES_FOR_NEXT_OBJECT.get().services;
    }

    private AsmBackedClassGenerator(boolean decorate, String suffix, Collection<? extends InjectAnnotationHandler> allKnownAnnotations, Collection<Class<? extends Annotation>> enabledAnnotations) {
        super(allKnownAnnotations, enabledAnnotations);
        this.decorate = decorate;
        this.suffix = suffix;
        this.key = enabledAnnotations.size() << 1 | (decorate ? 1 : 0);
    }

    static ClassGenerator decorateAndInject(Collection<? extends InjectAnnotationHandler> allKnownAnnotations, Collection<Class<? extends Annotation>> enabledAnnotations) {
        return new AsmBackedClassGenerator(true, "_Decorated", allKnownAnnotations, enabledAnnotations);
    }

    static ClassGenerator injectOnly(Collection<? extends InjectAnnotationHandler> allKnownAnnotations, Collection<Class<? extends Annotation>> enabledAnnotations) {
        return new AsmBackedClassGenerator(false, "$Inject", allKnownAnnotations, enabledAnnotations);
    }

    @Override
    protected Object key() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T newInstance(Constructor<T> constructor, ServiceLookup services, Instantiator nested, Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ObjectCreationDetails previous = SERVICES_FOR_NEXT_OBJECT.get();
        SERVICES_FOR_NEXT_OBJECT.set(new ObjectCreationDetails(nested, services));
        try {
            constructor.setAccessible(true);
            T t = constructor.newInstance(params);
            return t;
        }
        finally {
            SERVICES_FOR_NEXT_OBJECT.set(previous);
        }
    }

    @Override
    protected AbstractClassGenerator.ClassInspectionVisitor start(Class<?> type) {
        if (type.isAnnotation() || type.isEnum()) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(type);
            formatter.append((CharSequence)" is not a class or interface.");
            throw new ClassGenerationException(formatter.toString());
        }
        return new ClassInspectionVisitorImpl(type, this.decorate, this.suffix);
    }

    private static class NoOpBuilder
    implements AbstractClassGenerator.ClassGenerationVisitor {
        private final Class<?> type;

        public NoOpBuilder(Class<?> type) {
            this.type = type;
        }

        @Override
        public void addConstructor(Constructor<?> constructor) {
        }

        @Override
        public void addDefaultConstructor() {
        }

        @Override
        public void mixInDynamicAware() {
        }

        @Override
        public void mixInConventionAware() {
        }

        @Override
        public void mixInGroovyObject() {
        }

        @Override
        public void addDynamicMethods() {
        }

        @Override
        public void addExtensionsProperty() {
        }

        @Override
        public void applyServiceInjectionToProperty(AbstractClassGenerator.PropertyMetadata property) {
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property, AbstractClassGenerator.MethodMetadata getter) {
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property, Class<? extends Annotation> annotation, AbstractClassGenerator.MethodMetadata getter) {
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property, Class<? extends Annotation> annotation, Method setter) {
        }

        @Override
        public void applyManagedStateToProperty(AbstractClassGenerator.PropertyMetadata property) {
        }

        @Override
        public void applyReadOnlyManagedStateToGetter(AbstractClassGenerator.PropertyMetadata property, Method getter) {
        }

        @Override
        public void applyManagedStateToGetter(AbstractClassGenerator.PropertyMetadata property, Method getter) {
        }

        @Override
        public void applyManagedStateToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
        }

        @Override
        public void addManagedMethods(List<AbstractClassGenerator.PropertyMetadata> properties, List<AbstractClassGenerator.PropertyMetadata> readOnlyProperties) {
        }

        @Override
        public void applyConventionMappingToProperty(AbstractClassGenerator.PropertyMetadata property) {
        }

        @Override
        public void applyConventionMappingToGetter(AbstractClassGenerator.PropertyMetadata property, Method getter) {
        }

        @Override
        public void applyConventionMappingToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
        }

        @Override
        public void applyConventionMappingToSetMethod(AbstractClassGenerator.PropertyMetadata property, Method metaMethod) {
        }

        @Override
        public void addSetMethod(AbstractClassGenerator.PropertyMetadata propertyMetaData, Method setter) {
        }

        @Override
        public void addActionMethod(Method method) {
        }

        @Override
        public void addPropertySetters(AbstractClassGenerator.PropertyMetadata property, Method getter) {
        }

        @Override
        public Class<?> generate() {
            return this.type;
        }
    }

    private static class ObjectCreationDetails {
        final Instantiator instantiator;
        final ServiceLookup services;

        ObjectCreationDetails(Instantiator instantiator, ServiceLookup services) {
            this.instantiator = instantiator;
            this.services = services;
        }
    }

    private static interface MethodCodeBody {
        public void add(MethodVisitor var1);
    }

    private static class ClassBuilderImpl
    implements AbstractClassGenerator.ClassGenerationVisitor {
        public static final int PV_FINAL_STATIC = 4122;
        private static final Set<? extends Class<?>> PRIMITIVE_TYPES = ImmutableSet.of(Byte.TYPE, Boolean.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, (Object[])new Class[]{Float.TYPE, Double.TYPE});
        private static final String DYNAMIC_OBJECT_HELPER_FIELD = "_gr_dyn_";
        private static final String MAPPING_FIELD = "_gr_map_";
        private static final String META_CLASS_FIELD = "_gr_mc_";
        private static final String SERVICES_FIELD = "_gr_svcs_";
        private static final String SERVICES_METHOD = "$gradleServices";
        private static final String FACTORY_FIELD = "_gr_factory_";
        private static final String CONVENTION_MAPPING_FIELD_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(ConventionMapping.class);
        private static final String META_CLASS_TYPE_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(MetaClass.class);
        private static final org.objectweb.asm.Type META_CLASS_TYPE = org.objectweb.asm.Type.getType(MetaClass.class);
        private static final org.objectweb.asm.Type GENERATED_SUBCLASS_TYPE = org.objectweb.asm.Type.getType(GeneratedSubclass.class);
        private static final org.objectweb.asm.Type CONVENTION_AWARE_TYPE = org.objectweb.asm.Type.getType(IConventionAware.class);
        private static final org.objectweb.asm.Type CONVENTION_AWARE_HELPER_TYPE = org.objectweb.asm.Type.getType(ConventionAwareHelper.class);
        private static final org.objectweb.asm.Type DYNAMIC_OBJECT_AWARE_TYPE = org.objectweb.asm.Type.getType(DynamicObjectAware.class);
        private static final org.objectweb.asm.Type EXTENSION_AWARE_TYPE = org.objectweb.asm.Type.getType(ExtensionAware.class);
        private static final org.objectweb.asm.Type HAS_CONVENTION_TYPE = org.objectweb.asm.Type.getType(HasConvention.class);
        private static final org.objectweb.asm.Type DYNAMIC_OBJECT_TYPE = org.objectweb.asm.Type.getType(DynamicObject.class);
        private static final org.objectweb.asm.Type CONVENTION_MAPPING_TYPE = org.objectweb.asm.Type.getType(ConventionMapping.class);
        private static final org.objectweb.asm.Type GROOVY_OBJECT_TYPE = org.objectweb.asm.Type.getType(GroovyObject.class);
        private static final org.objectweb.asm.Type CONVENTION_TYPE = org.objectweb.asm.Type.getType(Convention.class);
        private static final org.objectweb.asm.Type ASM_BACKED_CLASS_GENERATOR_TYPE = org.objectweb.asm.Type.getType(AsmBackedClassGenerator.class);
        private static final org.objectweb.asm.Type ABSTRACT_DYNAMIC_OBJECT_TYPE = org.objectweb.asm.Type.getType(AbstractDynamicObject.class);
        private static final org.objectweb.asm.Type EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE = org.objectweb.asm.Type.getType(MixInExtensibleDynamicObject.class);
        private static final org.objectweb.asm.Type NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE = org.objectweb.asm.Type.getType(BeanDynamicObject.class);
        private static final String JAVA_REFLECT_TYPE_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Type.class);
        private static final org.objectweb.asm.Type CONFIGURE_UTIL_TYPE = org.objectweb.asm.Type.getType(ConfigureUtil.class);
        private static final org.objectweb.asm.Type CLOSURE_TYPE = org.objectweb.asm.Type.getType(Closure.class);
        private static final org.objectweb.asm.Type SERVICE_REGISTRY_TYPE = org.objectweb.asm.Type.getType(ServiceRegistry.class);
        private static final org.objectweb.asm.Type SERVICE_LOOKUP_TYPE = org.objectweb.asm.Type.getType(ServiceLookup.class);
        private static final org.objectweb.asm.Type JAVA_LANG_REFLECT_TYPE = org.objectweb.asm.Type.getType(Type.class);
        private static final org.objectweb.asm.Type OBJECT_TYPE = org.objectweb.asm.Type.getType(Object.class);
        private static final org.objectweb.asm.Type CLASS_TYPE = org.objectweb.asm.Type.getType(Class.class);
        private static final org.objectweb.asm.Type METHOD_TYPE = org.objectweb.asm.Type.getType(Method.class);
        private static final org.objectweb.asm.Type STRING_TYPE = org.objectweb.asm.Type.getType(String.class);
        private static final org.objectweb.asm.Type CLASS_ARRAY_TYPE = org.objectweb.asm.Type.getType(Class[].class);
        private static final org.objectweb.asm.Type GROOVY_SYSTEM_TYPE = org.objectweb.asm.Type.getType(GroovySystem.class);
        private static final org.objectweb.asm.Type META_CLASS_REGISTRY_TYPE = org.objectweb.asm.Type.getType(MetaClassRegistry.class);
        private static final org.objectweb.asm.Type BOOLEAN_TYPE = org.objectweb.asm.Type.getType(Boolean.TYPE);
        private static final org.objectweb.asm.Type OBJECT_ARRAY_TYPE = org.objectweb.asm.Type.getType(Object[].class);
        private static final org.objectweb.asm.Type ACTION_TYPE = org.objectweb.asm.Type.getType(Action.class);
        private static final org.objectweb.asm.Type PROPERTY_INTERNAL_TYPE = org.objectweb.asm.Type.getType(PropertyInternal.class);
        private static final org.objectweb.asm.Type INSTANTIATOR_TYPE = org.objectweb.asm.Type.getType(Instantiator.class);
        private static final org.objectweb.asm.Type INSTANTIATOR_FACTORY_TYPE = org.objectweb.asm.Type.getType(InstantiatorFactory.class);
        private static final org.objectweb.asm.Type OBJECT_FACTORY_TYPE = org.objectweb.asm.Type.getType(ObjectFactory.class);
        private static final org.objectweb.asm.Type CONFIGURABLE_FILE_COLLECTION_TYPE = org.objectweb.asm.Type.getType(ConfigurableFileCollection.class);
        private static final org.objectweb.asm.Type MANAGED_TYPE = org.objectweb.asm.Type.getType(Managed.class);
        private static final org.objectweb.asm.Type REGULAR_FILE_PROPERTY_TYPE = org.objectweb.asm.Type.getType(RegularFileProperty.class);
        private static final org.objectweb.asm.Type DIRECTORY_PROPERTY_TYPE = org.objectweb.asm.Type.getType(DirectoryProperty.class);
        private static final org.objectweb.asm.Type PROPERTY_TYPE = org.objectweb.asm.Type.getType(Property.class);
        private static final org.objectweb.asm.Type LIST_PROPERTY_TYPE = org.objectweb.asm.Type.getType(ListProperty.class);
        private static final org.objectweb.asm.Type SET_PROPERTY_TYPE = org.objectweb.asm.Type.getType(SetProperty.class);
        private static final org.objectweb.asm.Type MAP_PROPERTY = org.objectweb.asm.Type.getType(MapProperty.class);
        private static final org.objectweb.asm.Type EXTENSION_CONTAINER_TYPE = org.objectweb.asm.Type.getType(ExtensionContainer.class);
        private static final String RETURN_VOID_FROM_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_TYPE});
        private static final String RETURN_VOID_FROM_OBJECT_CLASS_DYNAMIC_OBJECT_SERVICE_LOOKUP = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_TYPE, CLASS_TYPE, DYNAMIC_OBJECT_TYPE, SERVICE_LOOKUP_TYPE});
        private static final String RETURN_OBJECT_FROM_STRING_OBJECT_BOOLEAN = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_TYPE, STRING_TYPE, org.objectweb.asm.Type.BOOLEAN_TYPE});
        private static final String RETURN_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)CLASS_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_BOOLEAN = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.BOOLEAN_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_VOID = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_VOID_FROM_CONVENTION_AWARE_CONVENTION = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CONVENTION_AWARE_TYPE, CONVENTION_TYPE});
        private static final String RETURN_CONVENTION = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)CONVENTION_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_CONVENTION_MAPPING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)CONVENTION_MAPPING_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_EXTENSION_CONTAINER = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)EXTENSION_CONTAINER_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_OBJECT_FROM_STRING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE});
        private static final String RETURN_OBJECT_FROM_STRING_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE, OBJECT_TYPE});
        private static final String RETURN_VOID_FROM_STRING_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE, OBJECT_TYPE});
        private static final String RETURN_DYNAMIC_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)DYNAMIC_OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_META_CLASS_FROM_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)META_CLASS_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CLASS_TYPE});
        private static final String RETURN_BOOLEAN_FROM_STRING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)BOOLEAN_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE});
        private static final String RETURN_META_CLASS_REGISTRY = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)META_CLASS_REGISTRY_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_SERVICE_REGISTRY = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)SERVICE_REGISTRY_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_SERVICE_LOOKUP = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)SERVICE_LOOKUP_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_META_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)META_CLASS_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_VOID_FROM_META_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{META_CLASS_TYPE});
        private static final String GET_DECLARED_METHOD_DESCRIPTOR = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)METHOD_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE, CLASS_ARRAY_TYPE});
        private static final String RETURN_OBJECT_FROM_TYPE = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{JAVA_LANG_REFLECT_TYPE});
        private static final String RETURN_CONFIGURABLE_FILE_COLLECTION = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)CONFIGURABLE_FILE_COLLECTION_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_REGULAR_FILE_PROPERTY = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)REGULAR_FILE_PROPERTY_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_DIRECTORY_PROPERTY = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)DIRECTORY_PROPERTY_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_PROPERTY_FROM_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)PROPERTY_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CLASS_TYPE});
        private static final String RETURN_LIST_PROPERTY_FROM_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)LIST_PROPERTY_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CLASS_TYPE});
        private static final String RETURN_SET_PROPERTY_FROM_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)SET_PROPERTY_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CLASS_TYPE});
        private static final String RETURN_MAP_PROPERTY_FROM_CLASS_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)MAP_PROPERTY, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CLASS_TYPE, CLASS_TYPE});
        private static final String[] EMPTY_STRINGS = new String[0];
        private static final org.objectweb.asm.Type[] EMPTY_TYPES = new org.objectweb.asm.Type[0];
        private final ClassWriter visitor;
        private final Class<?> type;
        private final boolean managed;
        private final org.objectweb.asm.Type generatedType;
        private final org.objectweb.asm.Type superclassType;
        private final Map<Type, ReturnTypeEntry> genericReturnTypeConstantsIndex = Maps.newHashMap();
        private final AsmClassGenerator classGenerator;
        private boolean hasMappingField;
        private final boolean conventionAware;
        private final boolean mixInDsl;
        private final boolean extensible;
        private final boolean providesOwnDynamicObject;
        private final boolean requiresServicesMethod;

        private ClassBuilderImpl(Class<?> type, boolean decorated, String suffix, boolean extensible, boolean conventionAware, boolean managed, boolean providesOwnDynamicObject, boolean requiresServicesMethod) {
            this.type = type;
            this.managed = managed;
            this.classGenerator = new AsmClassGenerator(type, suffix);
            this.visitor = this.classGenerator.getVisitor();
            this.generatedType = this.classGenerator.getGeneratedType();
            this.superclassType = org.objectweb.asm.Type.getType(type);
            this.mixInDsl = decorated;
            this.extensible = extensible;
            this.conventionAware = conventionAware;
            this.providesOwnDynamicObject = providesOwnDynamicObject;
            this.requiresServicesMethod = requiresServicesMethod;
        }

        public void startClass() {
            ArrayList<String> interfaceTypes = new ArrayList<String>();
            org.objectweb.asm.Type superclass = this.superclassType;
            if (this.type.isInterface()) {
                interfaceTypes.add(this.superclassType.getInternalName());
                superclass = OBJECT_TYPE;
            }
            interfaceTypes.add(GENERATED_SUBCLASS_TYPE.getInternalName());
            if (this.conventionAware) {
                interfaceTypes.add(CONVENTION_AWARE_TYPE.getInternalName());
            }
            if (this.extensible) {
                interfaceTypes.add(EXTENSION_AWARE_TYPE.getInternalName());
                interfaceTypes.add(HAS_CONVENTION_TYPE.getInternalName());
            }
            if (this.mixInDsl) {
                interfaceTypes.add(DYNAMIC_OBJECT_AWARE_TYPE.getInternalName());
                interfaceTypes.add(GROOVY_OBJECT_TYPE.getInternalName());
            }
            if (this.managed) {
                interfaceTypes.add(MANAGED_TYPE.getInternalName());
            }
            this.includeNotInheritedAnnotations();
            this.visitor.visit(52, 4097, this.generatedType.getInternalName(), null, superclass.getInternalName(), interfaceTypes.toArray(EMPTY_STRINGS));
            if (this.requiresServicesMethod) {
                this.generateServiceRegistrySupportMethods();
            }
            this.generatePublicTypeMethod();
        }

        @Override
        public void addDefaultConstructor() {
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "<init>", RETURN_VOID, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, OBJECT_TYPE.getInternalName(), "<init>", RETURN_VOID, false);
            this.initializeFields(methodVisitor);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addConstructor(Constructor<?> constructor) {
            ArrayList<org.objectweb.asm.Type> paramTypes = new ArrayList<org.objectweb.asm.Type>();
            for (Class<?> paramType : constructor.getParameterTypes()) {
                paramTypes.add(org.objectweb.asm.Type.getType(paramType));
            }
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])paramTypes.toArray(EMPTY_TYPES));
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "<init>", methodDescriptor, AsmClassGeneratorUtils.signature(constructor), EMPTY_STRINGS);
            for (Annotation annotation : constructor.getDeclaredAnnotations()) {
                if (annotation.annotationType().getAnnotation(Inherited.class) != null) continue;
                Retention retention = annotation.annotationType().getAnnotation(Retention.class);
                AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotation(org.objectweb.asm.Type.getType(annotation.annotationType()).getDescriptor(), retention != null && retention.value() == RetentionPolicy.RUNTIME);
                annotationVisitor.visitEnd();
            }
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                methodVisitor.visitVarInsn(org.objectweb.asm.Type.getType(constructor.getParameterTypes()[i]).getOpcode(21), i + 1);
            }
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), "<init>", methodDescriptor, false);
            this.initializeFields(methodVisitor);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void initializeFields(MethodVisitor methodVisitor) {
            if (this.requiresServicesMethod) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(184, ASM_BACKED_CLASS_GENERATOR_TYPE.getInternalName(), "getServicesForNext", RETURN_SERVICE_LOOKUP, false);
                methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), SERVICES_FIELD, SERVICE_LOOKUP_TYPE.getDescriptor());
            }
        }

        @Override
        public void addExtensionsProperty() {
            this.addGetter("getExtensions", EXTENSION_CONTAINER_TYPE, RETURN_EXTENSION_CONTAINER, null, new MethodCodeBody(){

                @Override
                public void add(MethodVisitor visitor) {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitMethodInsn(182, generatedType.getInternalName(), "getConvention", RETURN_CONVENTION, false);
                }
            });
        }

        @Override
        public void mixInDynamicAware() {
            if (!this.mixInDsl) {
                return;
            }
            this.visitor.visitField(2, DYNAMIC_OBJECT_HELPER_FIELD, ABSTRACT_DYNAMIC_OBJECT_TYPE.getDescriptor(), null, null);
            if (this.extensible) {
                this.addGetter("getConvention", CONVENTION_TYPE, RETURN_CONVENTION, null, new MethodCodeBody(){

                    @Override
                    public void add(MethodVisitor visitor) {
                        visitor.visitVarInsn(25, 0);
                        visitor.visitMethodInsn(182, generatedType.getInternalName(), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT, false);
                        visitor.visitTypeInsn(192, EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName());
                        visitor.visitMethodInsn(182, EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName(), "getConvention", RETURN_CONVENTION, false);
                    }
                });
            }
            this.addLazyGetter("getAsDynamicObject", DYNAMIC_OBJECT_TYPE, RETURN_DYNAMIC_OBJECT, null, DYNAMIC_OBJECT_HELPER_FIELD, ABSTRACT_DYNAMIC_OBJECT_TYPE, new MethodCodeBody(){

                @Override
                public void add(MethodVisitor visitor) {
                    this.generateCreateDynamicObject(visitor);
                }
            });
        }

        private void generateCreateDynamicObject(MethodVisitor visitor) {
            if (this.extensible) {
                visitor.visitTypeInsn(187, EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName());
                visitor.visitInsn(89);
                visitor.visitVarInsn(25, 0);
                visitor.visitVarInsn(25, 0);
                visitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getClass", RETURN_CLASS, false);
                visitor.visitMethodInsn(182, CLASS_TYPE.getInternalName(), "getSuperclass", RETURN_CLASS, false);
                if (this.providesOwnDynamicObject) {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitMethodInsn(183, org.objectweb.asm.Type.getType(this.type).getInternalName(), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT, false);
                } else {
                    visitor.visitInsn(1);
                }
                this.putServiceRegistryOnStack(visitor);
                visitor.visitMethodInsn(183, EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName(), "<init>", RETURN_VOID_FROM_OBJECT_CLASS_DYNAMIC_OBJECT_SERVICE_LOOKUP, false);
            } else {
                visitor.visitTypeInsn(187, NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName());
                visitor.visitInsn(89);
                visitor.visitVarInsn(25, 0);
                visitor.visitMethodInsn(183, NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName(), "<init>", RETURN_VOID_FROM_OBJECT, false);
            }
        }

        @Override
        public void mixInConventionAware() {
            this.visitor.visitField(2, MAPPING_FIELD, CONVENTION_MAPPING_FIELD_DESCRIPTOR, null, null);
            this.hasMappingField = true;
            MethodCodeBody initConventionAwareHelper = new MethodCodeBody(){

                @Override
                public void add(MethodVisitor visitor) {
                    visitor.visitTypeInsn(187, CONVENTION_AWARE_HELPER_TYPE.getInternalName());
                    visitor.visitInsn(89);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitMethodInsn(182, generatedType.getInternalName(), "getConvention", RETURN_CONVENTION, false);
                    visitor.visitMethodInsn(183, CONVENTION_AWARE_HELPER_TYPE.getInternalName(), "<init>", RETURN_VOID_FROM_CONVENTION_AWARE_CONVENTION, false);
                }
            };
            this.addLazyGetter("getConventionMapping", CONVENTION_MAPPING_TYPE, RETURN_CONVENTION_MAPPING, null, MAPPING_FIELD, CONVENTION_MAPPING_TYPE, initConventionAwareHelper);
        }

        @Override
        public void mixInGroovyObject() {
            if (!this.mixInDsl) {
                return;
            }
            this.visitor.visitField(2, META_CLASS_FIELD, META_CLASS_TYPE_DESCRIPTOR, null, null);
            MethodCodeBody initMetaClass = new MethodCodeBody(){

                @Override
                public void add(MethodVisitor visitor) {
                    visitor.visitMethodInsn(184, GROOVY_SYSTEM_TYPE.getInternalName(), "getMetaClassRegistry", RETURN_META_CLASS_REGISTRY, false);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitMethodInsn(182, OBJECT_TYPE.getInternalName(), "getClass", RETURN_CLASS, false);
                    visitor.visitMethodInsn(185, META_CLASS_REGISTRY_TYPE.getInternalName(), "getMetaClass", RETURN_META_CLASS_FROM_CLASS, true);
                }
            };
            this.addLazyGetter("getMetaClass", META_CLASS_TYPE, RETURN_META_CLASS, null, META_CLASS_FIELD, META_CLASS_TYPE, initMetaClass);
            this.addSetter("setMetaClass", RETURN_VOID_FROM_META_CLASS, new MethodCodeBody(){

                @Override
                public void add(MethodVisitor visitor) {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitVarInsn(25, 1);
                    visitor.visitFieldInsn(181, generatedType.getInternalName(), ClassBuilderImpl.META_CLASS_FIELD, META_CLASS_TYPE_DESCRIPTOR);
                }
            });
        }

        private void addSetter(String methodName, String methodDescriptor, MethodCodeBody body) {
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, methodName, methodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            body.add(methodVisitor);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addPropertySetters(AbstractClassGenerator.PropertyMetadata property, Method getter) {
            if (!this.mixInDsl) {
                return;
            }
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, MetaProperty.getSetterName((String)property.getName()), RETURN_VOID_FROM_OBJECT, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), getter.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)getter), false);
            methodVisitor.visitTypeInsn(192, PROPERTY_INTERNAL_TYPE.getInternalName());
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(185, PROPERTY_INTERNAL_TYPE.getInternalName(), "setFromAnyValue", RETURN_VOID_FROM_OBJECT, true);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void addLazyGetter(String methodName, org.objectweb.asm.Type returnType, String methodDescriptor, String signature, final String fieldName, final org.objectweb.asm.Type fieldType, final MethodCodeBody initializer) {
            this.addGetter(methodName, returnType, methodDescriptor, signature, new MethodCodeBody(){

                @Override
                public void add(MethodVisitor visitor) {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitFieldInsn(180, generatedType.getInternalName(), fieldName, fieldType.getDescriptor());
                    visitor.visitVarInsn(58, 1);
                    visitor.visitVarInsn(25, 1);
                    Label returnValue = new Label();
                    visitor.visitJumpInsn(199, returnValue);
                    initializer.add(visitor);
                    visitor.visitVarInsn(58, 1);
                    visitor.visitVarInsn(25, 0);
                    visitor.visitVarInsn(25, 1);
                    visitor.visitFieldInsn(181, generatedType.getInternalName(), fieldName, fieldType.getDescriptor());
                    visitor.visitLabel(returnValue);
                    visitor.visitVarInsn(25, 1);
                }
            });
        }

        private void addGetter(String methodName, org.objectweb.asm.Type returnType, String methodDescriptor, String signature, MethodCodeBody body) {
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, methodName, methodDescriptor, signature, EMPTY_STRINGS);
            methodVisitor.visitCode();
            body.add(methodVisitor);
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addDynamicMethods() {
            if (!this.mixInDsl) {
                return;
            }
            this.addGetter("getProperty", OBJECT_TYPE, RETURN_OBJECT_FROM_STRING, null, new MethodCodeBody(){

                @Override
                public void add(MethodVisitor methodVisitor) {
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitMethodInsn(182, generatedType.getInternalName(), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT, false);
                    methodVisitor.visitVarInsn(25, 1);
                    String getPropertyDesc = RETURN_OBJECT_FROM_STRING;
                    methodVisitor.visitMethodInsn(185, DYNAMIC_OBJECT_TYPE.getInternalName(), "getProperty", getPropertyDesc, true);
                }
            });
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "hasProperty", RETURN_BOOLEAN_FROM_STRING, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT, false);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(185, DYNAMIC_OBJECT_TYPE.getInternalName(), "hasProperty", RETURN_BOOLEAN_FROM_STRING, true);
            methodVisitor.visitInsn(172);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            this.addSetter("setProperty", RETURN_VOID_FROM_STRING_OBJECT, new MethodCodeBody(){

                @Override
                public void add(MethodVisitor methodVisitor) {
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitMethodInsn(182, generatedType.getInternalName(), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT, false);
                    methodVisitor.visitVarInsn(25, 1);
                    methodVisitor.visitVarInsn(25, 2);
                    String setPropertyDesc = RETURN_VOID_FROM_STRING_OBJECT;
                    methodVisitor.visitMethodInsn(185, DYNAMIC_OBJECT_TYPE.getInternalName(), "setProperty", setPropertyDesc, true);
                }
            });
            this.addGetter("invokeMethod", OBJECT_TYPE, RETURN_OBJECT_FROM_STRING_OBJECT, null, new MethodCodeBody(){

                @Override
                public void add(MethodVisitor methodVisitor) {
                    String invokeMethodDesc = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE, OBJECT_ARRAY_TYPE});
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitMethodInsn(182, generatedType.getInternalName(), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT, false);
                    methodVisitor.visitVarInsn(25, 1);
                    methodVisitor.visitVarInsn(25, 2);
                    methodVisitor.visitTypeInsn(193, OBJECT_ARRAY_TYPE.getDescriptor());
                    Label end = new Label();
                    Label notArray = new Label();
                    methodVisitor.visitJumpInsn(153, notArray);
                    methodVisitor.visitVarInsn(25, 2);
                    methodVisitor.visitTypeInsn(192, OBJECT_ARRAY_TYPE.getDescriptor());
                    methodVisitor.visitJumpInsn(167, end);
                    methodVisitor.visitLabel(notArray);
                    methodVisitor.visitInsn(4);
                    methodVisitor.visitTypeInsn(189, OBJECT_TYPE.getInternalName());
                    methodVisitor.visitInsn(89);
                    methodVisitor.visitInsn(3);
                    methodVisitor.visitVarInsn(25, 2);
                    methodVisitor.visitInsn(83);
                    methodVisitor.visitLabel(end);
                    methodVisitor.visitMethodInsn(185, DYNAMIC_OBJECT_TYPE.getInternalName(), "invokeMethod", invokeMethodDesc, true);
                }
            });
        }

        @Override
        public void applyServiceInjectionToProperty(AbstractClassGenerator.PropertyMetadata property) {
            String fieldName = this.propFieldName(property);
            this.visitor.visitField(2, fieldName, org.objectweb.asm.Type.getDescriptor(property.getType()), null, null);
        }

        private void generateServicesField() {
            this.visitor.visitField(4098, SERVICES_FIELD, SERVICE_LOOKUP_TYPE.getDescriptor(), null, null);
        }

        private void generateGetServices() {
            MethodVisitor mv = this.visitor.visitMethod(4098, SERVICES_METHOD, RETURN_SERVICE_LOOKUP, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.generatedType.getInternalName(), SERVICES_FIELD, SERVICE_LOOKUP_TYPE.getDescriptor());
            mv.visitInsn(89);
            Label label = new Label();
            mv.visitJumpInsn(198, label);
            mv.visitInsn(176);
            mv.visitLabel(label);
            mv.visitMethodInsn(184, ASM_BACKED_CLASS_GENERATOR_TYPE.getInternalName(), "getServicesForNext", RETURN_SERVICE_LOOKUP, false);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property, AbstractClassGenerator.MethodMetadata getter) {
            this.applyServiceInjectionToGetter(property, null, getter);
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property, final Class<? extends Annotation> annotation, AbstractClassGenerator.MethodMetadata getter) {
            final String getterName = getter.getName();
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
            final org.objectweb.asm.Type serviceType = org.objectweb.asm.Type.getType(property.getType());
            final Type genericServiceType = property.getGenericType();
            String propFieldName = this.propFieldName(property);
            String signature = AsmClassGeneratorUtils.getterSignature(getter.getGenericReturnType());
            this.addLazyGetter(getterName, returnType, methodDescriptor, signature, propFieldName, serviceType, new MethodCodeBody(){

                @Override
                public void add(MethodVisitor methodVisitor) {
                    this.putServiceRegistryOnStack(methodVisitor);
                    if (genericServiceType instanceof Class) {
                        methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)((Class)genericServiceType)));
                    } else {
                        String constantFieldName = this.getConstantNameForGenericReturnType(genericServiceType, getterName);
                        methodVisitor.visitFieldInsn(178, generatedType.getInternalName(), constantFieldName, JAVA_REFLECT_TYPE_DESCRIPTOR);
                    }
                    if (annotation == null) {
                        methodVisitor.visitMethodInsn(185, SERVICE_LOOKUP_TYPE.getInternalName(), "get", RETURN_OBJECT_FROM_TYPE, true);
                    } else {
                        methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)annotation));
                        methodVisitor.visitMethodInsn(185, SERVICE_LOOKUP_TYPE.getInternalName(), "get", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{JAVA_LANG_REFLECT_TYPE, CLASS_TYPE}), true);
                    }
                    methodVisitor.visitTypeInsn(192, serviceType.getInternalName());
                }
            });
        }

        private void putServiceRegistryOnStack(MethodVisitor methodVisitor) {
            if (this.requiresServicesMethod) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), SERVICES_METHOD, RETURN_SERVICE_LOOKUP, false);
            } else {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getServices", RETURN_SERVICE_REGISTRY, false);
            }
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property, Class<? extends Annotation> annotation, Method setter) {
            this.applyServiceInjectionToSetter(property, setter);
        }

        private String getConstantNameForGenericReturnType(Type genericReturnType, String getterName) {
            ReturnTypeEntry entry = this.genericReturnTypeConstantsIndex.get(genericReturnType);
            if (entry == null) {
                String fieldName = "_GENERIC_RETURN_TYPE_" + this.genericReturnTypeConstantsIndex.size();
                entry = new ReturnTypeEntry(fieldName, getterName);
                this.genericReturnTypeConstantsIndex.put(genericReturnType, entry);
            }
            return entry.fieldName;
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            this.addSetterForProperty(property, setter);
        }

        @Override
        public void applyManagedStateToProperty(AbstractClassGenerator.PropertyMetadata property) {
            String fieldName = this.propFieldName(property);
            this.visitor.visitField(2, fieldName, org.objectweb.asm.Type.getDescriptor(property.getType()), null, null);
        }

        @Override
        public void applyReadOnlyManagedStateToGetter(AbstractClassGenerator.PropertyMetadata property, Method getter) {
            org.objectweb.asm.Type propType = org.objectweb.asm.Type.getType(property.getType());
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            this.addLazyGetter(getter.getName(), returnType, org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), null, this.propFieldName(property), propType, methodVisitor -> {
                this.putServiceRegistryOnStack(methodVisitor);
                methodVisitor.visitLdcInsn((Object)OBJECT_FACTORY_TYPE);
                methodVisitor.visitMethodInsn(185, SERVICE_LOOKUP_TYPE.getInternalName(), "get", RETURN_OBJECT_FROM_TYPE, true);
                methodVisitor.visitTypeInsn(192, OBJECT_FACTORY_TYPE.getInternalName());
                if (property.getType().equals(ConfigurableFileCollection.class)) {
                    methodVisitor.visitMethodInsn(185, OBJECT_FACTORY_TYPE.getInternalName(), "fileCollection", RETURN_CONFIGURABLE_FILE_COLLECTION, true);
                } else if (property.getType().equals(RegularFileProperty.class)) {
                    methodVisitor.visitMethodInsn(185, OBJECT_FACTORY_TYPE.getInternalName(), "fileProperty", RETURN_REGULAR_FILE_PROPERTY, true);
                } else if (property.getType().equals(DirectoryProperty.class)) {
                    methodVisitor.visitMethodInsn(185, OBJECT_FACTORY_TYPE.getInternalName(), "directoryProperty", RETURN_DIRECTORY_PROPERTY, true);
                } else if (property.getType().equals(Property.class)) {
                    Class elementType = (Class)((ParameterizedType)property.getGenericType()).getActualTypeArguments()[0];
                    methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)elementType));
                    methodVisitor.visitMethodInsn(185, OBJECT_FACTORY_TYPE.getInternalName(), "property", RETURN_PROPERTY_FROM_CLASS, true);
                } else if (property.getType().equals(ListProperty.class)) {
                    Class elementType = (Class)((ParameterizedType)property.getGenericType()).getActualTypeArguments()[0];
                    methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)elementType));
                    methodVisitor.visitMethodInsn(185, OBJECT_FACTORY_TYPE.getInternalName(), "listProperty", RETURN_LIST_PROPERTY_FROM_CLASS, true);
                } else if (property.getType().equals(SetProperty.class)) {
                    Class elementType = (Class)((ParameterizedType)property.getGenericType()).getActualTypeArguments()[0];
                    methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)elementType));
                    methodVisitor.visitMethodInsn(185, OBJECT_FACTORY_TYPE.getInternalName(), "setProperty", RETURN_SET_PROPERTY_FROM_CLASS, true);
                } else if (property.getType().equals(MapProperty.class)) {
                    Class keyType = (Class)((ParameterizedType)property.getGenericType()).getActualTypeArguments()[0];
                    Class elementType = (Class)((ParameterizedType)property.getGenericType()).getActualTypeArguments()[1];
                    methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)keyType));
                    methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)elementType));
                    methodVisitor.visitMethodInsn(185, OBJECT_FACTORY_TYPE.getInternalName(), "mapProperty", RETURN_MAP_PROPERTY_FROM_CLASS_CLASS, true);
                } else {
                    throw new IllegalArgumentException();
                }
            });
        }

        @Override
        public void applyManagedStateToGetter(AbstractClassGenerator.PropertyMetadata property, Method getter) {
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
            String fieldName = this.propFieldName(property);
            this.addGetter(getter.getName(), returnType, methodDescriptor, null, methodVisitor -> {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), fieldName, returnType.getDescriptor());
            });
        }

        @Override
        public void applyManagedStateToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            this.addSetterForProperty(property, setter);
        }

        private void addSetterForProperty(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)setter);
            org.objectweb.asm.Type fieldType = org.objectweb.asm.Type.getType(property.getType());
            String propFieldName = this.propFieldName(property);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, setter.getName(), methodDescriptor, AsmClassGeneratorUtils.signature(setter), EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(fieldType.getOpcode(21), 1);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), propFieldName, fieldType.getDescriptor());
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void generatePublicTypeMethod() {
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "publicType", RETURN_CLASS, null, EMPTY_STRINGS);
            methodVisitor.visitLdcInsn((Object)this.superclassType);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = this.visitor.visitMethod(9, "generatedFrom", RETURN_CLASS, null, EMPTY_STRINGS);
            methodVisitor.visitLdcInsn((Object)this.superclassType);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addManagedMethods(List<AbstractClassGenerator.PropertyMetadata> mutableProperties, List<AbstractClassGenerator.PropertyMetadata> readOnlyProperties) {
            AbstractClassGenerator.PropertyMetadata property;
            String propFieldName;
            AbstractClassGenerator.PropertyMetadata propertyMetaData;
            int i;
            this.visitor.visitField(4122, FACTORY_FIELD, org.objectweb.asm.Type.getType(Managed.Factory.class).getDescriptor(), null, null);
            MethodVisitor methodVisitor = this.visitor.visitMethod(4097, "<init>", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_ARRAY_TYPE}), null, EMPTY_STRINGS);
            methodVisitor.visitVarInsn(25, 0);
            if (this.type.isInterface()) {
                methodVisitor.visitMethodInsn(183, OBJECT_TYPE.getInternalName(), "<init>", RETURN_VOID, false);
            } else {
                methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), "<init>", RETURN_VOID, false);
            }
            for (i = 0; i < mutableProperties.size(); ++i) {
                propertyMetaData = mutableProperties.get(i);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitLdcInsn((Object)i);
                methodVisitor.visitInsn(50);
                this.unboxOrCast(methodVisitor, propertyMetaData.getType(), org.objectweb.asm.Type.getType(propertyMetaData.getType()));
                propFieldName = this.propFieldName(propertyMetaData);
                methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), propFieldName, org.objectweb.asm.Type.getType(propertyMetaData.getType()).getDescriptor());
            }
            for (i = 0; i < readOnlyProperties.size(); ++i) {
                propertyMetaData = readOnlyProperties.get(i);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitLdcInsn((Object)(i + mutableProperties.size()));
                methodVisitor.visitInsn(50);
                this.unboxOrCast(methodVisitor, propertyMetaData.getType(), org.objectweb.asm.Type.getType(propertyMetaData.getType()));
                propFieldName = this.propFieldName(propertyMetaData);
                methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), propFieldName, org.objectweb.asm.Type.getType(propertyMetaData.getType()).getDescriptor());
            }
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = this.visitor.visitMethod(1, "immutable", RETURN_BOOLEAN, null, EMPTY_STRINGS);
            methodVisitor.visitLdcInsn((Object)(mutableProperties.isEmpty() && readOnlyProperties.isEmpty() ? 1 : 0));
            methodVisitor.visitInsn(172);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = this.visitor.visitMethod(1, "unpackState", RETURN_OBJECT, null, EMPTY_STRINGS);
            methodVisitor.visitLdcInsn((Object)(mutableProperties.size() + readOnlyProperties.size()));
            methodVisitor.visitTypeInsn(189, OBJECT_TYPE.getInternalName());
            for (i = 0; i < mutableProperties.size(); ++i) {
                property = mutableProperties.get(i);
                propFieldName = this.propFieldName(property);
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)i);
                methodVisitor.visitVarInsn(25, 0);
                org.objectweb.asm.Type propertyType = org.objectweb.asm.Type.getType(property.getType());
                methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), propFieldName, propertyType.getDescriptor());
                this.maybeBox(methodVisitor, property.getType(), propertyType);
                methodVisitor.visitInsn(83);
            }
            for (i = 0; i < readOnlyProperties.size(); ++i) {
                property = readOnlyProperties.get(i);
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)(i + mutableProperties.size()));
                methodVisitor.visitVarInsn(25, 0);
                AbstractClassGenerator.MethodMetadata getter = property.getMainGetter();
                methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), getter.getName(), org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(getter.getReturnType()), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), false);
                this.maybeBox(methodVisitor, property.getType(), org.objectweb.asm.Type.getType(property.getType()));
                methodVisitor.visitInsn(83);
            }
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = this.visitor.visitMethod(33, "managedFactory", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Managed.Factory.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), null, EMPTY_STRINGS);
            methodVisitor.visitFieldInsn(178, this.generatedType.getInternalName(), FACTORY_FIELD, org.objectweb.asm.Type.getType(Managed.Factory.class).getDescriptor());
            methodVisitor.visitInsn(89);
            Label label = new Label();
            methodVisitor.visitJumpInsn(198, label);
            methodVisitor.visitInsn(176);
            methodVisitor.visitLabel(label);
            methodVisitor.visitTypeInsn(187, org.objectweb.asm.Type.getType(ManagedTypeFactory.class).getInternalName());
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, OBJECT_TYPE.getInternalName(), "getClass", RETURN_CLASS, false);
            methodVisitor.visitMethodInsn(183, org.objectweb.asm.Type.getType(ManagedTypeFactory.class).getInternalName(), "<init>", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CLASS_TYPE}), false);
            methodVisitor.visitInsn(89);
            methodVisitor.visitFieldInsn(179, this.generatedType.getInternalName(), FACTORY_FIELD, org.objectweb.asm.Type.getType(Managed.Factory.class).getDescriptor());
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void applyConventionMappingToProperty(AbstractClassGenerator.PropertyMetadata property) {
            if (!this.conventionAware) {
                return;
            }
            String flagName = this.propFieldName(property);
            this.visitor.visitField(2, flagName, org.objectweb.asm.Type.BOOLEAN_TYPE.getDescriptor(), null, null);
        }

        private String propFieldName(AbstractClassGenerator.PropertyMetadata property) {
            return "__" + property.getName() + "__";
        }

        @Override
        public void applyConventionMappingToGetter(AbstractClassGenerator.PropertyMetadata property, Method getter) {
            if (!this.conventionAware) {
                return;
            }
            String flagName = this.propFieldName(property);
            String getterName = getter.getName();
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, getterName, methodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            if (this.hasMappingField) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), MAPPING_FIELD, CONVENTION_MAPPING_FIELD_DESCRIPTOR);
                Label useConvention = new Label();
                methodVisitor.visitJumpInsn(199, useConvention);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), getterName, methodDescriptor, this.type.isInterface());
                methodVisitor.visitInsn(returnType.getOpcode(172));
                methodVisitor.visitLabel(useConvention);
            }
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(185, CONVENTION_AWARE_TYPE.getInternalName(), "getConventionMapping", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)CONVENTION_MAPPING_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), true);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), getterName, methodDescriptor, this.type.isInterface());
            this.maybeBox(methodVisitor, getter.getReturnType(), returnType);
            methodVisitor.visitLdcInsn((Object)property.getName());
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), flagName, org.objectweb.asm.Type.BOOLEAN_TYPE.getDescriptor());
            methodVisitor.visitMethodInsn(185, CONVENTION_MAPPING_TYPE.getInternalName(), "getConventionValue", RETURN_OBJECT_FROM_STRING_OBJECT_BOOLEAN, true);
            this.unboxOrCast(methodVisitor, getter.getReturnType(), returnType);
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void unboxOrCast(MethodVisitor methodVisitor, Class<?> targetClass, org.objectweb.asm.Type targetType) {
            if (targetClass.isPrimitive()) {
                org.objectweb.asm.Type boxedType = org.objectweb.asm.Type.getType((Class)JavaReflectionUtil.getWrapperTypeForPrimitiveType(targetClass));
                methodVisitor.visitTypeInsn(192, boxedType.getInternalName());
                String valueMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)targetType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
                methodVisitor.visitMethodInsn(182, boxedType.getInternalName(), targetClass.getName() + "Value", valueMethodDescriptor, false);
            } else {
                methodVisitor.visitTypeInsn(192, targetClass.isArray() ? "[" + targetType.getElementType().getDescriptor() : targetType.getInternalName());
            }
        }

        private void maybeBox(MethodVisitor methodVisitor, Class<?> valueClass, org.objectweb.asm.Type valueType) {
            if (valueClass.isPrimitive()) {
                org.objectweb.asm.Type boxedType = org.objectweb.asm.Type.getType((Class)JavaReflectionUtil.getWrapperTypeForPrimitiveType(valueClass));
                String valueOfMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)boxedType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{valueType});
                methodVisitor.visitMethodInsn(184, boxedType.getInternalName(), "valueOf", valueOfMethodDescriptor, false);
            }
        }

        @Override
        public void applyConventionMappingToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            if (!this.conventionAware) {
                return;
            }
            org.objectweb.asm.Type paramType = org.objectweb.asm.Type.getType(setter.getParameterTypes()[0]);
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(setter.getReturnType());
            String setterDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, setter.getName(), setterDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(paramType.getOpcode(21), 1);
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), setter.getName(), setterDescriptor, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitLdcInsn((Object)true);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), this.propFieldName(property), org.objectweb.asm.Type.BOOLEAN_TYPE.getDescriptor());
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addSetMethod(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            if (!this.mixInDsl) {
                return;
            }
            org.objectweb.asm.Type paramType = org.objectweb.asm.Type.getType(setter.getParameterTypes()[0]);
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(setter.getReturnType());
            String setterDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            String setMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, property.getName(), setMethodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(paramType.getOpcode(21), 1);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), setter.getName(), setterDescriptor, false);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void applyConventionMappingToSetMethod(AbstractClassGenerator.PropertyMetadata property, Method method) {
            if (!this.mixInDsl || !this.conventionAware) {
                return;
            }
            org.objectweb.asm.Type paramType = org.objectweb.asm.Type.getType(method.getParameterTypes()[0]);
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(method.getReturnType());
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, method.getName(), methodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(paramType.getOpcode(21), 1);
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), method.getName(), methodDescriptor, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitLdcInsn((Object)true);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), this.propFieldName(property), org.objectweb.asm.Type.BOOLEAN_TYPE.getDescriptor());
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addActionMethod(Method method) {
            if (!this.mixInDsl) {
                return;
            }
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(method.getReturnType());
            org.objectweb.asm.Type[] originalParameterTypes = (org.objectweb.asm.Type[])CollectionUtils.collectArray((Object[])method.getParameterTypes(), org.objectweb.asm.Type.class, (Transformer)new Transformer<org.objectweb.asm.Type, Class>(){

                public org.objectweb.asm.Type transform(Class clazz) {
                    return org.objectweb.asm.Type.getType((Class)clazz);
                }
            });
            int numParams = originalParameterTypes.length;
            org.objectweb.asm.Type[] closurisedParameterTypes = new org.objectweb.asm.Type[numParams];
            System.arraycopy(originalParameterTypes, 0, closurisedParameterTypes, 0, numParams);
            closurisedParameterTypes[numParams - 1] = CLOSURE_TYPE;
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])closurisedParameterTypes);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, method.getName(), methodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            for (int stackVar = 1; stackVar < numParams; ++stackVar) {
                methodVisitor.visitVarInsn(closurisedParameterTypes[stackVar - 1].getOpcode(21), stackVar);
            }
            methodVisitor.visitVarInsn(25, numParams);
            methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)ACTION_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CLOSURE_TYPE});
            methodVisitor.visitMethodInsn(184, CONFIGURE_UTIL_TYPE.getInternalName(), "configureUsing", methodDescriptor, false);
            methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(method.getReturnType()), (org.objectweb.asm.Type[])originalParameterTypes);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), method.getName(), methodDescriptor, false);
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void generateServiceRegistrySupportMethods() {
            this.generateServicesField();
            this.generateGetServices();
        }

        private void includeNotInheritedAnnotations() {
            for (Annotation annotation : this.type.getDeclaredAnnotations()) {
                if (annotation.annotationType().getAnnotation(Inherited.class) != null) continue;
                Retention retention = annotation.annotationType().getAnnotation(Retention.class);
                boolean visible = retention != null && retention.value() == RetentionPolicy.RUNTIME;
                AnnotationVisitor annotationVisitor = this.visitor.visitAnnotation(org.objectweb.asm.Type.getType(annotation.annotationType()).getDescriptor(), visible);
                this.visitAnnotationValues(annotation, annotationVisitor);
                annotationVisitor.visitEnd();
            }
        }

        private void visitAnnotationValues(Annotation annotation, AnnotationVisitor annotationVisitor) {
            for (Method method : annotation.annotationType().getDeclaredMethods()) {
                String name = method.getName();
                Class<?> returnType = method.getReturnType();
                if (returnType.isEnum()) {
                    annotationVisitor.visitEnum(name, org.objectweb.asm.Type.getType(returnType).getDescriptor(), this.getAnnotationParameterValue(annotation, method).toString());
                    continue;
                }
                if (returnType.isArray() && !PRIMITIVE_TYPES.contains(returnType.getComponentType())) {
                    AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
                    Object[] elements = (Object[])this.getAnnotationParameterValue(annotation, method);
                    this.visitArrayElements(arrayVisitor, returnType.getComponentType(), elements);
                    arrayVisitor.visitEnd();
                    continue;
                }
                if (returnType.equals(Class.class)) {
                    Class clazz = (Class)this.getAnnotationParameterValue(annotation, method);
                    annotationVisitor.visit(name, (Object)org.objectweb.asm.Type.getType((Class)clazz));
                    continue;
                }
                if (returnType.isAnnotation()) {
                    Annotation nestedAnnotation = (Annotation)this.getAnnotationParameterValue(annotation, method);
                    AnnotationVisitor nestedAnnotationVisitor = annotationVisitor.visitAnnotation(name, org.objectweb.asm.Type.getType(returnType).getDescriptor());
                    this.visitAnnotationValues(nestedAnnotation, nestedAnnotationVisitor);
                    nestedAnnotationVisitor.visitEnd();
                    continue;
                }
                annotationVisitor.visit(name, this.getAnnotationParameterValue(annotation, method));
            }
        }

        private void visitArrayElements(AnnotationVisitor arrayVisitor, Class arrayElementType, Object[] arrayElements) {
            if (arrayElementType.isEnum()) {
                String enumDescriptor = org.objectweb.asm.Type.getType((Class)arrayElementType).getDescriptor();
                for (Object value : arrayElements) {
                    arrayVisitor.visitEnum(null, enumDescriptor, value.toString());
                }
            } else if (arrayElementType.equals(Class.class)) {
                for (Object value : arrayElements) {
                    Class clazz = (Class)value;
                    arrayVisitor.visit(null, (Object)org.objectweb.asm.Type.getType((Class)clazz));
                }
            } else if (arrayElementType.isAnnotation()) {
                for (Object annotation : arrayElements) {
                    AnnotationVisitor nestedAnnotationVisitor = arrayVisitor.visitAnnotation(null, org.objectweb.asm.Type.getType((Class)arrayElementType).getDescriptor());
                    this.visitAnnotationValues((Annotation)annotation, nestedAnnotationVisitor);
                    nestedAnnotationVisitor.visitEnd();
                }
            } else {
                for (Object value : arrayElements) {
                    arrayVisitor.visit(null, value);
                }
            }
        }

        private Object getAnnotationParameterValue(Annotation annotation, Method method) {
            try {
                return method.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        @Override
        public Class<?> generate() {
            this.writeGenericReturnTypeFields();
            this.visitor.visitEnd();
            return this.classGenerator.define();
        }

        private void writeGenericReturnTypeFields() {
            if (!this.genericReturnTypeConstantsIndex.isEmpty()) {
                MethodVisitor mv = this.visitor.visitMethod(8, "<clinit>", "()V", null, null);
                mv.visitCode();
                for (Map.Entry<Type, ReturnTypeEntry> entry : this.genericReturnTypeConstantsIndex.entrySet()) {
                    ReturnTypeEntry returnType = entry.getValue();
                    this.visitor.visitField(4122, returnType.fieldName, JAVA_REFLECT_TYPE_DESCRIPTOR, null, null);
                    this.writeGenericReturnTypeFieldInitializer(mv, returnType);
                }
                mv.visitInsn(177);
                mv.visitMaxs(1, 1);
                mv.visitEnd();
            }
        }

        private void writeGenericReturnTypeFieldInitializer(MethodVisitor mv, ReturnTypeEntry returnType) {
            mv.visitLdcInsn((Object)this.generatedType);
            mv.visitLdcInsn((Object)returnType.getterName);
            mv.visitInsn(3);
            mv.visitTypeInsn(189, CLASS_TYPE.getInternalName());
            mv.visitMethodInsn(182, CLASS_TYPE.getInternalName(), "getDeclaredMethod", GET_DECLARED_METHOD_DESCRIPTOR, false);
            mv.visitMethodInsn(182, METHOD_TYPE.getInternalName(), "getGenericReturnType", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)JAVA_LANG_REFLECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), false);
            mv.visitFieldInsn(179, this.generatedType.getInternalName(), returnType.fieldName, JAVA_REFLECT_TYPE_DESCRIPTOR);
        }

        private static final class ReturnTypeEntry {
            private final String fieldName;
            private final String getterName;

            private ReturnTypeEntry(String fieldName, String getterName) {
                this.fieldName = fieldName;
                this.getterName = getterName;
            }
        }
    }

    private static class ClassInspectionVisitorImpl
    implements AbstractClassGenerator.ClassInspectionVisitor {
        private final Class<?> type;
        private final boolean decorate;
        private final String suffix;
        private boolean extensible;
        private boolean serviceInjection;
        private boolean conventionAware;
        private boolean managed;
        private boolean providesOwnDynamicObjectImplementation;
        private boolean providesOwnServicesImplementation;

        public ClassInspectionVisitorImpl(Class<?> type, boolean decorate, String suffix) {
            this.type = type;
            this.decorate = decorate;
            this.suffix = suffix;
        }

        @Override
        public void mixInServiceInjection() {
            this.serviceInjection = true;
        }

        @Override
        public void mixInExtensible() {
            if (this.decorate) {
                this.extensible = true;
            }
        }

        @Override
        public void mixInConventionAware() {
            if (this.decorate) {
                this.conventionAware = true;
            }
        }

        @Override
        public void mixInManaged() {
            this.managed = true;
        }

        @Override
        public void providesOwnServicesImplementation() {
            this.providesOwnServicesImplementation = true;
        }

        @Override
        public void providesOwnDynamicObjectImplementation() {
            this.providesOwnDynamicObjectImplementation = true;
        }

        @Override
        public AbstractClassGenerator.ClassGenerationVisitor builder() {
            if (!(this.decorate || this.serviceInjection || Modifier.isAbstract(this.type.getModifiers()))) {
                return new NoOpBuilder(this.type);
            }
            int modifiers = this.type.getModifiers();
            if (Modifier.isPrivate(modifiers)) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node(this.type);
                formatter.append((CharSequence)" is private.");
                throw new ClassGenerationException(formatter.toString());
            }
            if (Modifier.isFinal(modifiers)) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node(this.type);
                formatter.append((CharSequence)" is final.");
                throw new ClassGenerationException(formatter.toString());
            }
            boolean requiresServicesMethod = (this.extensible || this.serviceInjection) && !this.providesOwnServicesImplementation;
            ClassBuilderImpl builder = new ClassBuilderImpl(this.type, this.decorate, this.suffix, this.extensible, this.conventionAware, this.managed, this.providesOwnDynamicObjectImplementation, requiresServicesMethod);
            builder.startClass();
            return builder;
        }
    }
}

