/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health.gc;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gradle.api.specs.Spec;
import org.gradle.internal.time.Time;
import org.gradle.launcher.daemon.server.health.gc.DefaultSlidingWindow;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionCheck;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionEvent;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectorMonitoringStrategy;
import org.gradle.launcher.daemon.server.health.gc.SlidingWindow;
import org.gradle.util.CollectionUtils;

public class GarbageCollectionMonitor {
    private static final int POLL_INTERVAL_SECONDS = 1;
    private static final int POLL_DELAY_SECONDS = 1;
    private static final int EVENT_WINDOW = 20;
    private final SlidingWindow<GarbageCollectionEvent> heapEvents;
    private final SlidingWindow<GarbageCollectionEvent> nonHeapEvents;
    private final GarbageCollectorMonitoringStrategy gcStrategy;
    private final ScheduledExecutorService pollingExecutor;

    public GarbageCollectionMonitor(GarbageCollectorMonitoringStrategy gcStrategy, ScheduledExecutorService pollingExecutor) {
        this.pollingExecutor = pollingExecutor;
        this.gcStrategy = gcStrategy;
        this.heapEvents = new DefaultSlidingWindow<GarbageCollectionEvent>(20);
        this.nonHeapEvents = new DefaultSlidingWindow<GarbageCollectionEvent>(20);
        if (gcStrategy != GarbageCollectorMonitoringStrategy.UNKNOWN) {
            this.pollForValues();
        }
    }

    private void pollForValues() {
        GarbageCollectorMXBean garbageCollectorMXBean = CollectionUtils.findFirst(ManagementFactory.getGarbageCollectorMXBeans(), new Spec<GarbageCollectorMXBean>(){

            @Override
            public boolean isSatisfiedBy(GarbageCollectorMXBean element) {
                return element.getName().equals(GarbageCollectionMonitor.this.gcStrategy.getGarbageCollectorName());
            }
        });
        this.pollingExecutor.scheduleAtFixedRate(new GarbageCollectionCheck(Time.clock(), garbageCollectorMXBean, this.gcStrategy.getHeapPoolName(), this.heapEvents, this.gcStrategy.getNonHeapPoolName(), this.nonHeapEvents), 1L, 1L, TimeUnit.SECONDS);
    }

    public GarbageCollectionStats getHeapStats() {
        return GarbageCollectionStats.forHeap(this.heapEvents.snapshot());
    }

    public GarbageCollectionStats getNonHeapStats() {
        return GarbageCollectionStats.forNonHeap(this.nonHeapEvents.snapshot());
    }
}

