/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.PropertyFileCollection;
import org.gradle.api.internal.tasks.properties.DefaultInputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.tasks.FileNormalizer;

public class GetInputFilesVisitor
extends PropertyVisitor.Adapter {
    private final List<InputFilePropertySpec> specs = Lists.newArrayList();
    private final FileCollectionFactory fileCollectionFactory;
    private final String ownerDisplayName;
    private boolean hasSourceFiles;
    private ImmutableSortedSet<InputFilePropertySpec> fileProperties;

    public GetInputFilesVisitor(String ownerDisplayName, FileCollectionFactory fileCollectionFactory) {
        this.ownerDisplayName = ownerDisplayName;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    @Override
    public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
        FileCollection actualValue = FileParameterUtils.resolveInputFileValue(this.fileCollectionFactory, filePropertyType, value);
        this.specs.add(new DefaultInputFilePropertySpec(propertyName, FileParameterUtils.normalizerOrDefault(fileNormalizer), (FileCollection)new PropertyFileCollection(this.ownerDisplayName, propertyName, "input", actualValue), skipWhenEmpty));
        if (skipWhenEmpty) {
            this.hasSourceFiles = true;
        }
    }

    public ImmutableSortedSet<InputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            this.fileProperties = FileParameterUtils.collectFileProperties("input", this.specs.iterator());
        }
        return this.fileProperties;
    }

    public boolean hasSourceFiles() {
        return this.hasSourceFiles;
    }
}

