/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.internal.JavaPluginsHelper;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;

public class JavaLibraryPlugin
implements Plugin<Project> {
    private final ObjectFactory objectFactory;

    @Inject
    public JavaLibraryPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        ConfigurationContainer configurations = project.getConfigurations();
        this.addApiToMainSourceSet(project, sourceSets, configurations);
    }

    private void addApiToMainSourceSet(Project project, SourceSetContainer sourceSets, ConfigurationContainer configurations) {
        SourceSet sourceSet = (SourceSet)sourceSets.getByName("main");
        Configuration apiConfiguration = (Configuration)configurations.maybeCreate(sourceSet.getApiConfigurationName());
        apiConfiguration.setVisible(false);
        apiConfiguration.setDescription("API dependencies for " + sourceSet + ".");
        apiConfiguration.setCanBeResolved(false);
        apiConfiguration.setCanBeConsumed(false);
        Configuration apiElementsConfiguration = configurations.getByName(sourceSet.getApiElementsConfigurationName());
        apiElementsConfiguration.extendsFrom(new Configuration[]{apiConfiguration});
        TaskProvider javaCompile = project.getTasks().named("compileJava", JavaCompile.class);
        JavaPluginsHelper.registerClassesDirVariant((Provider<? extends AbstractCompile>)javaCompile, this.objectFactory, apiElementsConfiguration);
        Configuration implementationConfiguration = configurations.getByName(sourceSet.getImplementationConfigurationName());
        implementationConfiguration.extendsFrom(new Configuration[]{apiConfiguration});
        Configuration compileConfiguration = configurations.getByName(sourceSet.getCompileConfigurationName());
        apiConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
    }
}

