/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.project.ProjectInternal;

public class ReportingExtension {
    public static final String NAME = "reporting";
    public static final String DEFAULT_REPORTS_DIR_NAME = "reports";
    private final ProjectInternal project;
    private final DirectoryProperty baseDirectory;

    public ReportingExtension(Project project) {
        this.project = (ProjectInternal)project;
        this.baseDirectory = project.getObjects().directoryProperty();
        this.baseDirectory.set(project.getLayout().getBuildDirectory().dir(DEFAULT_REPORTS_DIR_NAME));
    }

    public File getBaseDir() {
        return (File)this.baseDirectory.getAsFile().get();
    }

    public void setBaseDir(File baseDir) {
        this.baseDirectory.set(baseDir);
    }

    public void setBaseDir(final Object baseDir) {
        this.baseDirectory.set(this.project.provider((Callable)new Callable<Directory>(){

            @Override
            public Directory call() throws Exception {
                DirectoryProperty result = ReportingExtension.this.project.getObjects().directoryProperty();
                result.set(ReportingExtension.this.project.file(baseDir));
                return (Directory)result.get();
            }
        }));
    }

    @Incubating
    public DirectoryProperty getBaseDirectory() {
        return this.baseDirectory;
    }

    public File file(String path) {
        return ((FileLookup)this.project.getServices().get(FileLookup.class)).getFileResolver(this.getBaseDir()).resolve((Object)path);
    }

    public String getApiDocTitle() {
        Object version = this.project.getVersion();
        if ("unspecified".equals(version)) {
            return this.project.getName() + " API";
        }
        return this.project.getName() + " " + version + " API";
    }
}

