/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.internal.GradleInternal;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.initialization.ConfigureBuildBuildOperationType;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class NotifyingBuildConfigurer
implements BuildConfigurer {
    private static final ConfigureBuildBuildOperationType.Result CONFIGURE_BUILD_RESULT = new ConfigureBuildBuildOperationType.Result(){};
    private final BuildConfigurer delegate;
    private final BuildOperationExecutor buildOperationExecutor;

    public NotifyingBuildConfigurer(BuildConfigurer delegate, BuildOperationExecutor buildOperationExecutor) {
        this.delegate = delegate;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void configure(GradleInternal gradle) {
        this.buildOperationExecutor.run((RunnableBuildOperation)new ConfigureBuild(gradle));
    }

    private class ConfigureBuild
    implements RunnableBuildOperation {
        private final GradleInternal gradle;

        public ConfigureBuild(GradleInternal gradle) {
            this.gradle = gradle;
        }

        public void run(BuildOperationContext context) {
            NotifyingBuildConfigurer.this.delegate.configure(this.gradle);
            context.setResult((Object)CONFIGURE_BUILD_RESULT);
        }

        public BuildOperationDescriptor.Builder description() {
            BuildOperationDescriptor.Builder builder = BuildOperationDescriptor.displayName((String)this.gradle.contextualize("Configure build"));
            if (this.gradle.getParent() == null) {
                builder.operationType(BuildOperationCategory.CONFIGURE_ROOT_BUILD);
            } else {
                builder.operationType(BuildOperationCategory.CONFIGURE_BUILD);
            }
            builder.totalProgress(this.gradle.getSettings().getProjectRegistry().size());
            return builder.details((Object)new ConfigureBuildBuildOperationType.Details(){

                @Override
                public String getBuildPath() {
                    return ConfigureBuild.this.gradle.getIdentityPath().toString();
                }
            });
        }
    }
}

