/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.IncrementalJsCacheKt;
import org.jetbrains.kotlin.incremental.InlineFunctionsMap;
import org.jetbrains.kotlin.incremental.PackageMetadataMap;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.TranslationResultMap;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.DirtyClassesFqNameMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.SourceToFqNameMap;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0016\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&J\u0016\u0010*\u001a\u00020$2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040,H\u0016J\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020/0.J\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00100.J\u0018\u00101\u001a\u00020$2\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0002H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00040\rj\b\u0012\u0004\u0012\u00020\u0004`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache;", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "Lorg/jetbrains/kotlin/name/FqName;", "cachesDir", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "getDirtyOutputClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "dirtySources", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "value", "", "header", "getHeader", "()[B", "setHeader", "([B)V", "headerFile", "getHeaderFile", "()Ljava/io/File;", "inlineFunctions", "Lorg/jetbrains/kotlin/incremental/InlineFunctionsMap;", "packageMetadata", "Lorg/jetbrains/kotlin/incremental/PackageMetadataMap;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "getSourceToClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "translationResults", "Lorg/jetbrains/kotlin/incremental/TranslationResultMap;", "clearCacheForRemovedClasses", "", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "compareAndUpdate", "incrementalResults", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumerImpl;", "markDirty", "removedAndCompiledSources", "", "nonDirtyPackageParts", "", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "", "registerOutputForFile", "srcFile", "name", "Companion", "kotlin-build-common"})
public class IncrementalJsCache
extends AbstractIncrementalCache<FqName> {
    @NotNull
    private final SourceToFqNameMap sourceToClassesMap;
    @NotNull
    private final DirtyClassesFqNameMap dirtyOutputClassesMap;
    private final TranslationResultMap translationResults;
    private final InlineFunctionsMap inlineFunctions;
    private final PackageMetadataMap packageMetadata;
    private final HashSet<File> dirtySources;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public SourceToFqNameMap getSourceToClassesMap$kotlin_build_common() {
        return this.sourceToClassesMap;
    }

    @NotNull
    public DirtyClassesFqNameMap getDirtyOutputClassesMap$kotlin_build_common() {
        return this.dirtyOutputClassesMap;
    }

    private final File getHeaderFile() {
        return new File(this.getCachesDir(), "header.meta");
    }

    @NotNull
    public final byte[] getHeader() {
        return FilesKt.readBytes((File)this.getHeaderFile());
    }

    public final void setHeader(@NotNull byte[] value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.getCachesDir().mkdirs();
        FilesKt.writeBytes((File)this.getHeaderFile(), (byte[])value);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void markDirty(@NotNull Collection<? extends File> removedAndCompiledSources) {
        Intrinsics.checkParameterIsNotNull(removedAndCompiledSources, (String)"removedAndCompiledSources");
        Iterable $this$forEach$iv = removedAndCompiledSources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Object v1;
            void $this$mapTo$iv$iv;
            File sourceFile = (File)element$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.getSourceToClassesMap$kotlin_build_common().get(sourceFile);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FqName fqName2 = (FqName)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Object object = FqNamesUtilKt.parentOrNull((FqName)it);
                if (object == null || (object = ((FqName)object).asString()) == null) {
                    object = "";
                }
                Object object2 = object;
                collection.add(object2);
            }
            Iterable $this$minBy$iv = (List)destination$iv$iv;
            boolean $i$f$minBy = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    String it = (String)minElem$iv;
                    boolean bl3 = false;
                    int minValue$iv = it.length();
                    do {
                        Object e$iv = iterator$iv.next();
                        String it2 = (String)e$iv;
                        $i$a$-minBy-IncrementalJsCache$markDirty$1$2 = false;
                        int v$iv = it2.length();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            if ((String)v1 == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            String it = string;
            boolean bl6 = false;
            String string2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
            this.packageMetadata.remove(string2);
        }
        super.markDirty(removedAndCompiledSources);
        this.dirtySources.addAll(removedAndCompiledSources);
    }

    /*
     * WARNING - void declaration
     */
    public final void compareAndUpdate(@NotNull IncrementalResultsConsumerImpl incrementalResults, @NotNull ChangesCollector changesCollector) {
        Object srcFile;
        Map.Entry<Object, Object> entry;
        Map.Entry<Object, Object> entry2;
        Map<File, TranslationResultValue> translatedFiles;
        Intrinsics.checkParameterIsNotNull((Object)incrementalResults, (String)"incrementalResults");
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        Map<File, TranslationResultValue> map2 = translatedFiles = incrementalResults.getPackageParts();
        boolean bl = false;
        Iterator<Map.Entry<Object, Object>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void binaryAst;
            void binaryMetadata;
            boolean bl2;
            Object it;
            Map<ClassId, ProtoData> map3;
            byte[] inlineData;
            block8: {
                block7: {
                    entry = entry2 = iterator2.next();
                    boolean bl3 = false;
                    srcFile = entry.getKey();
                    entry = entry2;
                    bl3 = false;
                    TranslationResultValue data = entry.getValue();
                    this.dirtySources.remove(srcFile);
                    TranslationResultValue translationResultValue = data;
                    entry = (Map.Entry<Object, Object>)translationResultValue.component1();
                    byte[] byArray = translationResultValue.component2();
                    inlineData = translationResultValue.component3();
                    map3 = this.translationResults.get((File)srcFile);
                    if (map3 == null) break block7;
                    byte[] byArray2 = ((TranslationResultValue)((Object)map3)).getMetadata();
                    map3 = (Map<ClassId, ProtoData>)byArray2;
                    if (byArray2 == null) break block7;
                    Map<ClassId, ProtoData> map4 = map3;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    it = map4;
                    bl2 = false;
                    map3 = IncrementalJsCacheKt.getProtoData((File)srcFile, (byte[])it);
                    if (map3 != null) break block8;
                }
                map3 = MapsKt.emptyMap();
            }
            Map<ClassId, ProtoData> oldProtoMap = map3;
            Map<ClassId, ProtoData> newProtoMap = IncrementalJsCacheKt.getProtoData((File)srcFile, (byte[])binaryMetadata);
            it = newProtoMap;
            bl2 = false;
            Iterator iterator3 = it.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry entry3;
                Map.Entry entry4 = entry3 = iterator3.next();
                boolean bl6 = false;
                ClassId classId = (ClassId)entry4.getKey();
                entry4 = entry3;
                bl6 = false;
                ProtoData protoData = (ProtoData)entry4.getValue();
                FqName fqName2 = classId.asSingleFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.asSingleFqName()");
                this.registerOutputForFile((File)srcFile, fqName2);
                if (!(protoData instanceof ClassProtoData)) continue;
                this.addToClassStorage(((ClassProtoData)protoData).getProto(), ((ClassProtoData)protoData).getNameResolver(), (File)srcFile);
            }
            for (ClassId classId : SetsKt.plus(oldProtoMap.keySet(), (Iterable)newProtoMap.keySet())) {
                ChangesCollector.collectProtoChanges$default(changesCollector, oldProtoMap.get(classId), newProtoMap.get(classId), false, 4, null);
            }
            this.translationResults.put((File)srcFile, (byte[])binaryMetadata, (byte[])binaryAst, inlineData);
        }
        srcFile = incrementalResults.getInlineFunctions();
        boolean data = false;
        iterator2 = srcFile.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = entry2 = iterator2.next();
            boolean bl7 = false;
            srcFile = entry.getKey();
            entry = entry2;
            bl7 = false;
            Map inlineDeclarations = (Map)((Object)entry.getValue());
            this.inlineFunctions.process((File)srcFile, inlineDeclarations, changesCollector);
        }
        srcFile = incrementalResults.getPackageMetadata();
        boolean inlineDeclarations = false;
        iterator2 = srcFile.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = entry2 = iterator2.next();
            boolean bl8 = false;
            String packageName = (String)entry.getKey();
            entry = entry2;
            bl8 = false;
            byte[] metadata = (byte[])entry.getValue();
            this.packageMetadata.put(packageName, metadata);
        }
    }

    private final void registerOutputForFile(File srcFile, FqName name) {
        this.getSourceToClassesMap$kotlin_build_common().add(srcFile, name);
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(name);
    }

    @Override
    public void clearCacheForRemovedClasses(@NotNull ChangesCollector changesCollector) {
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        Iterable $this$forEach$iv = this.dirtySources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.translationResults.remove(it, changesCollector);
            this.inlineFunctions.remove(it);
        }
        this.removeAllFromClassStorage(this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses(), changesCollector);
        this.dirtySources.clear();
        this.getDirtyOutputClassesMap$kotlin_build_common().clean();
    }

    @NotNull
    public final Map<File, TranslationResultValue> nonDirtyPackageParts() {
        boolean bl = false;
        HashMap<File, TranslationResultValue> hashMap = new HashMap<File, TranslationResultValue>();
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap<File, TranslationResultValue> $this$apply = hashMap;
        boolean bl4 = false;
        for (File file2 : this.translationResults.keys()) {
            if (this.dirtySources.contains(file2)) continue;
            TranslationResultValue translationResultValue = this.translationResults.get(file2);
            if (translationResultValue == null) {
                Intrinsics.throwNpe();
            }
            $this$apply.put(file2, translationResultValue);
        }
        return hashMap;
    }

    @NotNull
    public final Map<String, byte[]> packageMetadata() {
        boolean bl = false;
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap<String, byte[]> $this$apply = hashMap;
        boolean bl4 = false;
        for (String fqNameString : this.packageMetadata.keys()) {
            byte[] byArray = this.packageMetadata.get(fqNameString);
            if (byArray == null) {
                Intrinsics.throwNpe();
            }
            $this$apply.put(fqNameString, byArray);
        }
        return hashMap;
    }

    public IncrementalJsCache(@NotNull File cachesDir, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkParameterIsNotNull((Object)cachesDir, (String)"cachesDir");
        Intrinsics.checkParameterIsNotNull((Object)pathConverter, (String)"pathConverter");
        super(cachesDir, pathConverter);
        this.sourceToClassesMap = (SourceToFqNameMap)this.registerMap((BasicMap)new SourceToFqNameMap(this.getStorageFile(AbstractIncrementalCache.Companion.getSOURCE_TO_CLASSES()), pathConverter));
        this.dirtyOutputClassesMap = (DirtyClassesFqNameMap)this.registerMap((BasicMap)new DirtyClassesFqNameMap(this.getStorageFile(AbstractIncrementalCache.Companion.getDIRTY_OUTPUT_CLASSES())));
        this.translationResults = (TranslationResultMap)this.registerMap((BasicMap)new TranslationResultMap(this.getStorageFile("translation-result"), pathConverter));
        this.inlineFunctions = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile("inline-functions"), pathConverter));
        this.packageMetadata = (PackageMetadataMap)this.registerMap((BasicMap)new PackageMetadataMap(this.getStorageFile("packages-meta")));
        IncrementalJsCache incrementalJsCache = this;
        boolean bl = false;
        HashSet hashSet = new HashSet();
        incrementalJsCache.dirtySources = hashSet;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache$Companion;", "", "()V", "HEADER_FILE_NAME", "", "INLINE_FUNCTIONS", "PACKAGE_META_FILE", "TRANSLATION_RESULT_MAP", "hasHeaderFile", "", "cachesDir", "Ljava/io/File;", "kotlin-build-common"})
    public static final class Companion {
        public final boolean hasHeaderFile(@NotNull File cachesDir) {
            Intrinsics.checkParameterIsNotNull((Object)cachesDir, (String)"cachesDir");
            return new File(cachesDir, "header.meta").exists();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

