/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.classrealm.ClassRealmManager;
import org.apache.maven.model.Build;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.ExtensionRealmCache;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.ExtensionDescriptor;
import org.apache.maven.project.ExtensionDescriptorBuilder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectRealmCache;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.filter.ExclusionsDependencyFilter;
import org.sonatype.aether.util.graph.PreorderNodeListGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ProjectBuildingHelper.class)
public class DefaultProjectBuildingHelper
implements ProjectBuildingHelper {
    @Requirement
    private Logger logger;
    @Requirement
    private PlexusContainer container;
    @Requirement
    private ClassRealmManager classRealmManager;
    @Requirement
    private PluginArtifactsCache pluginArtifactsCache;
    @Requirement
    private ExtensionRealmCache extensionRealmCache;
    @Requirement
    private ProjectRealmCache projectRealmCache;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private PluginVersionResolver pluginVersionResolver;
    @Requirement
    private PluginDependenciesResolver pluginDependenciesResolver;
    private ExtensionDescriptorBuilder extensionDescriptorBuilder = new ExtensionDescriptorBuilder();

    @Override
    public List<ArtifactRepository> createArtifactRepositories(List<Repository> pomRepositories, List<ArtifactRepository> externalRepositories, ProjectBuildingRequest request) throws InvalidRepositoryException {
        List<ArtifactRepository> recessiveRepositories;
        List<ArtifactRepository> dominantRepositories;
        ArrayList<ArtifactRepository> internalRepositories = new ArrayList<ArtifactRepository>();
        for (Repository repository : pomRepositories) {
            internalRepositories.add(this.repositorySystem.buildArtifactRepository(repository));
        }
        this.repositorySystem.injectMirror(request.getRepositorySession(), internalRepositories);
        this.repositorySystem.injectProxy(request.getRepositorySession(), internalRepositories);
        this.repositorySystem.injectAuthentication(request.getRepositorySession(), internalRepositories);
        if (ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT.equals((Object)request.getRepositoryMerging())) {
            dominantRepositories = externalRepositories;
            recessiveRepositories = internalRepositories;
        } else {
            dominantRepositories = internalRepositories;
            recessiveRepositories = externalRepositories;
        }
        List<ArtifactRepository> artifactRepositories = new ArrayList<ArtifactRepository>();
        HashSet<String> repoIds = new HashSet<String>();
        if (dominantRepositories != null) {
            for (ArtifactRepository repository : dominantRepositories) {
                repoIds.add(repository.getId());
                artifactRepositories.add(repository);
            }
        }
        if (recessiveRepositories != null) {
            for (ArtifactRepository repository : recessiveRepositories) {
                if (!repoIds.add(repository.getId())) continue;
                artifactRepositories.add(repository);
            }
        }
        artifactRepositories = this.repositorySystem.getEffectiveRepositories(artifactRepositories);
        return artifactRepositories;
    }

    @Override
    public synchronized ProjectRealmCache.CacheRecord createProjectRealm(MavenProject project, Model model, ProjectBuildingRequest request) throws PluginResolutionException, PluginVersionResolutionException {
        ProjectRealmCache.CacheRecord record;
        ClassRealm projectRealm = null;
        ArrayList<Plugin> extensionPlugins = new ArrayList<Plugin>();
        Build build = model.getBuild();
        if (build != null) {
            for (Extension extension : build.getExtensions()) {
                Plugin plugin = new Plugin();
                plugin.setGroupId(extension.getGroupId());
                plugin.setArtifactId(extension.getArtifactId());
                plugin.setVersion(extension.getVersion());
                extensionPlugins.add(plugin);
            }
            for (Plugin plugin : build.getPlugins()) {
                if (!plugin.isExtensions()) continue;
                extensionPlugins.add(plugin);
            }
        }
        if (extensionPlugins.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Extension realms for project " + model.getId() + ": (none)");
            }
            return new ProjectRealmCache.CacheRecord(null, null);
        }
        ArrayList<ClassRealm> extensionRealms = new ArrayList<ClassRealm>();
        HashMap<ClassRealm, List<String>> exportedPackages = new HashMap<ClassRealm, List<String>>();
        HashMap<ClassRealm, List<String>> exportedArtifacts = new HashMap<ClassRealm, List<String>>();
        ArrayList<Artifact> publicArtifacts = new ArrayList<Artifact>();
        for (Plugin plugin : extensionPlugins) {
            ClassRealm extensionRealm;
            List<Artifact> artifacts;
            PluginArtifactsCache.Key cacheKey;
            PluginArtifactsCache.CacheRecord recordArtifacts;
            if (plugin.getVersion() == null) {
                DefaultPluginVersionRequest versionRequest = new DefaultPluginVersionRequest(plugin, request.getRepositorySession(), project.getRemotePluginRepositories());
                plugin.setVersion(this.pluginVersionResolver.resolve(versionRequest).getVersion());
            }
            if ((recordArtifacts = this.pluginArtifactsCache.get(cacheKey = this.pluginArtifactsCache.createKey(plugin, null, project.getRemotePluginRepositories(), request.getRepositorySession()))) != null) {
                artifacts = recordArtifacts.artifacts;
            } else {
                try {
                    artifacts = this.resolveExtensionArtifacts(plugin, project.getRemotePluginRepositories(), request);
                    recordArtifacts = this.pluginArtifactsCache.put(cacheKey, artifacts);
                }
                catch (PluginResolutionException e) {
                    this.pluginArtifactsCache.put(cacheKey, e);
                    this.pluginArtifactsCache.register(project, recordArtifacts);
                    throw e;
                }
            }
            this.pluginArtifactsCache.register(project, recordArtifacts);
            ExtensionDescriptor extensionDescriptor = null;
            ExtensionRealmCache.CacheRecord recordRealm = this.extensionRealmCache.get(artifacts);
            if (recordRealm != null) {
                extensionRealm = recordRealm.realm;
                extensionDescriptor = recordRealm.desciptor;
            } else {
                extensionRealm = this.classRealmManager.createExtensionRealm(plugin, artifacts);
                try {
                    this.container.discoverComponents(extensionRealm);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to discover components in extension realm " + extensionRealm.getId(), e);
                }
                Artifact extensionArtifact = artifacts.get(0);
                try {
                    extensionDescriptor = this.extensionDescriptorBuilder.build(extensionArtifact.getFile());
                }
                catch (IOException e) {
                    String message = "Invalid extension descriptor for " + plugin.getId() + ": " + e.getMessage();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.error(message, (Throwable)e);
                    }
                    this.logger.error(message);
                }
                recordRealm = this.extensionRealmCache.put(artifacts, extensionRealm, extensionDescriptor);
            }
            this.extensionRealmCache.register(project, recordRealm);
            extensionRealms.add(extensionRealm);
            if (extensionDescriptor != null) {
                exportedPackages.put(extensionRealm, extensionDescriptor.getExportedPackages());
                exportedArtifacts.put(extensionRealm, extensionDescriptor.getExportedArtifacts());
            }
            if (plugin.isExtensions() || artifacts.size() != 2 || artifacts.get(0).getFile() == null || !"plexus-utils".equals(artifacts.get(1).getArtifactId())) continue;
            publicArtifacts.add(artifacts.get(0));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Extension realms for project " + model.getId() + ": " + extensionRealms);
        }
        if ((record = this.projectRealmCache.get(extensionRealms)) == null) {
            projectRealm = this.classRealmManager.createProjectRealm(model, publicArtifacts);
            LinkedHashSet exclusions = new LinkedHashSet();
            for (ClassRealm extensionRealm : extensionRealms) {
                List<String> exports;
                List excludes = (List)exportedArtifacts.get(extensionRealm);
                if (excludes != null) {
                    exclusions.addAll(excludes);
                }
                if ((exports = (List<String>)exportedPackages.get(extensionRealm)) == null || exports.isEmpty()) {
                    exports = Arrays.asList(extensionRealm.getId());
                }
                for (String export : exports) {
                    projectRealm.importFrom((ClassLoader)extensionRealm, export);
                }
            }
            ExclusionsDependencyFilter extensionArtifactFilter = null;
            if (!exclusions.isEmpty()) {
                extensionArtifactFilter = new ExclusionsDependencyFilter(exclusions);
            }
            record = this.projectRealmCache.put(extensionRealms, projectRealm, (DependencyFilter)extensionArtifactFilter);
        }
        this.projectRealmCache.register(project, record);
        return record;
    }

    private List<Artifact> resolveExtensionArtifacts(Plugin extensionPlugin, List<RemoteRepository> repositories, ProjectBuildingRequest request) throws PluginResolutionException {
        DependencyNode root = this.pluginDependenciesResolver.resolve(extensionPlugin, null, null, repositories, request.getRepositorySession());
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        root.accept((DependencyVisitor)nlg);
        return nlg.getArtifacts(false);
    }

    @Override
    public void selectProjectRealm(MavenProject project) {
        ClassRealm projectRealm = project.getClassRealm();
        if (projectRealm == null) {
            projectRealm = this.classRealmManager.getCoreRealm();
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
    }
}

