/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScopeIdentifier;
import org.gradle.api.internal.initialization.DefaultClassLoaderScope;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.initialization.ClassLoaderScopeId;
import org.gradle.initialization.ClassLoaderScopeRegistryListener;

public abstract class AbstractClassLoaderScope
implements ClassLoaderScope {
    protected final ClassLoaderScopeIdentifier id;
    protected final ClassLoaderCache classLoaderCache;
    protected final ClassLoaderScopeRegistryListener listener;

    protected AbstractClassLoaderScope(ClassLoaderScopeIdentifier id, ClassLoaderCache classLoaderCache, ClassLoaderScopeRegistryListener listener) {
        this.id = id;
        this.classLoaderCache = classLoaderCache;
        this.listener = listener;
    }

    public ClassLoaderScopeId getId() {
        return this.id;
    }

    public String getPath() {
        return this.id.getPath();
    }

    @Override
    public ClassLoaderScope createChild(String name) {
        if (name == null) {
            throw new IllegalArgumentException("'name' cannot be null");
        }
        ClassLoaderScopeIdentifier childId = this.id.child(name);
        this.childScopeCreated(childId);
        return new DefaultClassLoaderScope(childId, this, this.classLoaderCache, this.listener);
    }

    protected void childScopeCreated(ClassLoaderScopeId childId) {
        this.listener.childScopeCreated(this.id, childId);
    }
}

