/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileType;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.recomp.AbstractRecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileChangeProcessor;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.file.Deleter;
import org.gradle.work.FileChange;

public class JavaRecompilationSpecProvider
extends AbstractRecompilationSpecProvider {
    private final boolean incremental;
    private final Iterable<FileChange> sourceFileChanges;

    public JavaRecompilationSpecProvider(Deleter deleter, FileOperations fileOperations, FileTree sourceTree, boolean incremental, Iterable<FileChange> sourceFileChanges) {
        super(deleter, fileOperations, sourceTree);
        this.incremental = incremental;
        this.sourceFileChanges = sourceFileChanges;
    }

    @Override
    public boolean isIncremental() {
        return this.incremental;
    }

    @Override
    public RecompilationSpec provideRecompilationSpec(CurrentCompilation current, PreviousCompilation previous) {
        RecompilationSpec spec = new RecompilationSpec();
        this.processClasspathChanges(current, previous, spec);
        this.processOtherChanges(current, previous, spec);
        spec.getClassesToProcess().addAll(previous.getTypesToReprocess());
        return spec;
    }

    @Override
    public boolean initializeCompilation(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        if (!recompilationSpec.isBuildNeeded()) {
            spec.setSourceFiles((Iterable)ImmutableSet.of());
            spec.setClasses(Collections.emptySet());
            return false;
        }
        Factory patternSetFactory = this.fileOperations.getFileResolver().getPatternSetFactory();
        PatternSet classesToDelete = (PatternSet)patternSetFactory.create();
        PatternSet sourceToCompile = (PatternSet)patternSetFactory.create();
        this.prepareJavaPatterns(recompilationSpec.getClassesToCompile(), classesToDelete, sourceToCompile);
        spec.setSourceFiles(this.narrowDownSourcesToCompile(this.sourceTree, sourceToCompile));
        this.includePreviousCompilationOutputOnClasspath(spec);
        this.addClassesToProcess(spec, recompilationSpec);
        boolean cleanedAnyOutput = this.deleteStaleFilesIn(classesToDelete, spec.getDestinationDir());
        cleanedAnyOutput |= this.deleteStaleFilesIn(classesToDelete, spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory());
        cleanedAnyOutput |= this.deleteStaleFilesIn(classesToDelete, spec.getCompileOptions().getHeaderOutputDirectory());
        Map<GeneratedResource.Location, PatternSet> resourcesToDelete = JavaRecompilationSpecProvider.prepareResourcePatterns(recompilationSpec.getResourcesToGenerate(), (Factory<PatternSet>)patternSetFactory);
        cleanedAnyOutput |= this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.CLASS_OUTPUT), spec.getDestinationDir());
        cleanedAnyOutput |= this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.SOURCE_OUTPUT), (File)MoreObjects.firstNonNull((Object)spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory(), (Object)spec.getDestinationDir()));
        return cleanedAnyOutput |= this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.NATIVE_HEADER_OUTPUT), spec.getCompileOptions().getHeaderOutputDirectory());
    }

    @Override
    public WorkResult decorateResult(RecompilationSpec recompilationSpec, WorkResult workResult) {
        return workResult;
    }

    private Iterable<File> narrowDownSourcesToCompile(FileTree sourceTree, PatternSet sourceToCompile) {
        return sourceTree.matching((PatternFilterable)sourceToCompile);
    }

    private static Map<GeneratedResource.Location, PatternSet> prepareResourcePatterns(Collection<GeneratedResource> staleResources, Factory<PatternSet> patternSetFactory) {
        EnumMap<GeneratedResource.Location, PatternSet> resourcesByLocation = new EnumMap<GeneratedResource.Location, PatternSet>(GeneratedResource.Location.class);
        for (GeneratedResource.Location location : GeneratedResource.Location.values()) {
            resourcesByLocation.put(location, (PatternSet)patternSetFactory.create());
        }
        for (GeneratedResource resource : staleResources) {
            ((PatternSet)resourcesByLocation.get((Object)resource.getLocation())).include(new String[]{resource.getPath()});
        }
        return resourcesByLocation;
    }

    private void processOtherChanges(CurrentCompilation current, PreviousCompilation previous, RecompilationSpec spec) {
        if (spec.isFullRebuildNeeded()) {
            return;
        }
        boolean emptyAnnotationProcessorPath = current.getAnnotationProcessorPath().isEmpty();
        SourceFileChangeProcessor javaChangeProcessor = new SourceFileChangeProcessor(previous);
        for (FileChange fileChange : this.sourceFileChanges) {
            if (spec.isFullRebuildNeeded()) {
                return;
            }
            if (fileChange.getFileType() != FileType.FILE) continue;
            File file = fileChange.getFile();
            if (FileUtils.hasExtension((File)file, (String)".java")) {
                String className = JavaRecompilationSpecProvider.getClassNameForRelativePath(fileChange.getNormalizedPath());
                javaChangeProcessor.processChange(file, Collections.singletonList(className), spec);
                continue;
            }
            if (emptyAnnotationProcessorPath) continue;
            spec.setFullRebuildCause(this.rebuildClauseForChangedNonSourceFile("resource", fileChange), null);
            return;
        }
    }

    private static String getClassNameForRelativePath(String relativePath) {
        return relativePath.replace('/', '.').replaceAll("\\.java$", "");
    }

    private void prepareJavaPatterns(Collection<String> staleClasses, PatternSet filesToDelete, PatternSet sourceToCompile) {
        for (String staleClass : staleClasses) {
            String path = staleClass.replaceAll("\\.", "/");
            filesToDelete.include(new String[]{path.concat(".class")});
            filesToDelete.include(new String[]{path.concat(".java")});
            filesToDelete.include(new String[]{path.concat(".h")});
            filesToDelete.include(new String[]{path.concat("$*.class")});
            filesToDelete.include(new String[]{path.concat("$*.java")});
            filesToDelete.include(new String[]{path.concat("$*.h")});
            sourceToCompile.include(new String[]{path.concat(".java")});
            sourceToCompile.include(new String[]{path.concat("$*.java")});
        }
    }
}

