/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.ArrayList;
import java.util.Collections;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.build.event.BuildEventListenerFactory;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.build.event.OperationResultPostProcessor;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.provider.runner.BuildOperationParentTracker;
import org.gradle.tooling.internal.provider.runner.ClientForwardingBuildOperationListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingProjectConfigurationOperationListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingTaskOperationListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingTestOperationListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingTestOutputOperationListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingTransformOperationListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingWorkItemOperationListener;
import org.gradle.tooling.internal.provider.runner.CompositeOperationResultPostProcessor;
import org.gradle.tooling.internal.provider.runner.OperationDependenciesResolver;
import org.gradle.tooling.internal.provider.runner.PluginApplicationTracker;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;
import org.gradle.tooling.internal.provider.runner.TaskOriginTracker;
import org.gradle.tooling.internal.provider.runner.TestIgnoringBuildOperationListener;

public class ToolingApiBuildEventListenerFactory
implements BuildEventListenerFactory {
    private final OperationResultPostProcessor operationResultPostProcessor;
    private final BuildOperationIdFactory idFactory;
    private static final BuildOperationListener NO_OP = new BuildOperationListener(){

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        }

        public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        }
    };

    ToolingApiBuildEventListenerFactory(BuildOperationIdFactory idFactory, CompositeOperationResultPostProcessor compositeOperationResultPostProcessor) {
        this.idFactory = idFactory;
        this.operationResultPostProcessor = compositeOperationResultPostProcessor;
    }

    public Iterable<Object> createListeners(BuildEventSubscriptions subscriptions, BuildEventConsumer consumer) {
        Object buildListener;
        if (!subscriptions.isAnyOperationTypeRequested()) {
            return Collections.emptyList();
        }
        BuildOperationParentTracker parentTracker = new BuildOperationParentTracker();
        ProgressEventConsumer progressEventConsumer = new ProgressEventConsumer(consumer, parentTracker);
        ArrayList<Object> listeners = new ArrayList<Object>();
        listeners.add(parentTracker);
        if (subscriptions.isRequested(OperationType.TEST)) {
            buildListener = new ClientForwardingTestOperationListener(progressEventConsumer, subscriptions);
            if (subscriptions.isRequested(OperationType.TEST_OUTPUT)) {
                buildListener = new ClientForwardingTestOutputOperationListener((BuildOperationListener)buildListener, progressEventConsumer, this.idFactory);
            }
            listeners.add(buildListener);
        }
        if (subscriptions.isAnyRequested(new OperationType[]{OperationType.GENERIC, OperationType.WORK_ITEM, OperationType.TASK, OperationType.PROJECT_CONFIGURATION, OperationType.TRANSFORM})) {
            buildListener = NO_OP;
            if (subscriptions.isRequested(OperationType.GENERIC)) {
                buildListener = new TestIgnoringBuildOperationListener(new ClientForwardingBuildOperationListener(progressEventConsumer));
            }
            if (subscriptions.isAnyRequested(new OperationType[]{OperationType.GENERIC, OperationType.WORK_ITEM})) {
                buildListener = new ClientForwardingWorkItemOperationListener(progressEventConsumer, subscriptions, (BuildOperationListener)buildListener);
            }
            OperationDependenciesResolver operationDependenciesResolver = new OperationDependenciesResolver();
            if (subscriptions.isAnyRequested(new OperationType[]{OperationType.GENERIC, OperationType.WORK_ITEM, OperationType.TRANSFORM})) {
                ClientForwardingTransformOperationListener transformOperationListener = new ClientForwardingTransformOperationListener(progressEventConsumer, subscriptions, (BuildOperationListener)buildListener, operationDependenciesResolver);
                operationDependenciesResolver.addLookup(transformOperationListener);
                buildListener = transformOperationListener;
            }
            PluginApplicationTracker pluginApplicationTracker = new PluginApplicationTracker(parentTracker);
            if (subscriptions.isAnyRequested(new OperationType[]{OperationType.PROJECT_CONFIGURATION, OperationType.TASK})) {
                listeners.add(pluginApplicationTracker);
            }
            if (subscriptions.isAnyRequested(new OperationType[]{OperationType.GENERIC, OperationType.WORK_ITEM, OperationType.TRANSFORM, OperationType.TASK})) {
                TaskOriginTracker taskOriginTracker = new TaskOriginTracker(pluginApplicationTracker);
                if (subscriptions.isAnyRequested(new OperationType[]{OperationType.TASK})) {
                    listeners.add(taskOriginTracker);
                }
                ClientForwardingTaskOperationListener taskOperationListener = new ClientForwardingTaskOperationListener(progressEventConsumer, subscriptions, (BuildOperationListener)buildListener, this.operationResultPostProcessor, taskOriginTracker, operationDependenciesResolver);
                operationDependenciesResolver.addLookup(taskOperationListener);
                buildListener = taskOperationListener;
            }
            listeners.add(new ClientForwardingProjectConfigurationOperationListener(progressEventConsumer, subscriptions, (BuildOperationListener)buildListener, parentTracker, pluginApplicationTracker));
        }
        return listeners;
    }
}

