/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.snapshots;

import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshot;", "", "file", "Ljava/io/File;", "length", "", "hash", "", "(Ljava/io/File;J[B)V", "getFile", "()Ljava/io/File;", "getHash", "()[B", "getLength", "()J", "equals", "", "other", "hashCode", "", "toString", "", "incremental-compilation-impl"})
public final class FileSnapshot {
    @NotNull
    private final File file;
    private final long length;
    @NotNull
    private final byte[] hash;

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(other.getClass(), this.getClass()) ^ true) {
            return false;
        }
        FileSnapshot cfr_ignored_0 = (FileSnapshot)other;
        if (Intrinsics.areEqual((Object)this.file, (Object)((FileSnapshot)other).file) ^ true) {
            return false;
        }
        if (this.length != ((FileSnapshot)other).length) {
            return false;
        }
        return Arrays.equals(this.hash, ((FileSnapshot)other).hash);
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = 31 * result2 + Long.hashCode(this.length);
        result2 = 31 * result2 + Arrays.hashCode(this.hash);
        return result2;
    }

    @NotNull
    public String toString() {
        return "FileSnapshot(file=" + this.file + ", length=" + this.length + ", hash=" + Arrays.toString(this.hash) + ')';
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final long getLength() {
        return this.length;
    }

    @NotNull
    public final byte[] getHash() {
        return this.hash;
    }

    public FileSnapshot(@NotNull File file2, long length, @NotNull byte[] hash) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        this.file = file2;
        this.length = length;
        this.hash = hash;
        boolean bl = !this.file.isDirectory();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }
}

