/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTables;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010!\u001a\u00020\u0006*\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamerImpl;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "newNameTables", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;)V", "getNameForClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getNameForMemberField", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getNameForStaticFunction", "getNameForValueDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "toJsName", "", "backend.js"})
public final class IrNamerImpl
implements IrNamer {
    private final NameTables newNameTables;

    private final JsName toJsName(@NotNull String $this$toJsName) {
        return new JsName($this$toJsName);
    }

    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return this.toJsName(this.newNameTables.getNameForStaticDeclaration(declaration2));
    }

    @Override
    @Nullable
    public JsName getNameForLoop(@NotNull IrLoop loop2) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        String string2 = this.newNameTables.getNameForLoop(loop2);
        return string2 != null ? this.toJsName(string2) : null;
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor) {
        Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
        return this.getNameForStaticDeclaration(IrUtilsKt.getParentAsClass(constructor));
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        boolean bl = function2.getDispatchReceiverParameter() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return this.toJsName(this.newNameTables.getNameForMemberFunction(function2));
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        boolean bl = !field.isStatic();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return this.toJsName(this.newNameTables.getNameForMemberField(field));
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        return field.isStatic() ? this.getNameForStaticDeclaration(field) : this.getNameForMemberField(field);
    }

    @Override
    @NotNull
    public JsName getNameForValueDeclaration(@NotNull IrValueDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return this.getNameForStaticDeclaration(declaration2);
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass2) {
        Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
        return this.getNameForStaticDeclaration(klass2);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        return this.getNameForStaticDeclaration(function2);
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        String string2 = AnnotationUtilsKt.getJsNameOrKotlinName(property).asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"property.getJsNameOrKotlinName().asString()");
        return this.toJsName(string2);
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass2) {
        JsNameRef jsNameRef;
        Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
        IrDeclarationParent parent2 = klass2.getParent();
        if (klass2.isCompanion()) {
            IrDeclarationParent irDeclarationParent = parent2;
            if (irDeclarationParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            }
            return this.getRefForExternalClass((IrClass)irDeclarationParent);
        }
        String string2 = AnnotationUtilsKt.getJsNameOrKotlinName(klass2).getIdentifier();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"klass.getJsNameOrKotlinName().identifier");
        String currentClassName = string2;
        IrDeclarationParent irDeclarationParent = parent2;
        if (irDeclarationParent instanceof IrClass) {
            jsNameRef = new JsNameRef(currentClassName, (JsExpression)this.getRefForExternalClass((IrClass)parent2));
        } else if (irDeclarationParent instanceof IrPackageFragment) {
            jsNameRef = new JsNameRef(currentClassName);
        } else {
            String string3 = "Unsupported external class parent " + parent2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return jsNameRef;
    }

    public IrNamerImpl(@NotNull NameTables newNameTables) {
        Intrinsics.checkParameterIsNotNull((Object)newNameTables, (String)"newNameTables");
        this.newNameTables = newNameTables;
    }
}

