/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AntFileCollectionBuilder;
import org.gradle.api.internal.file.AntFileCollectionMatchingTaskBuilder;
import org.gradle.api.internal.file.AntFileSetBuilder;
import org.gradle.api.internal.file.DefaultFileSystemLocation;
import org.gradle.api.internal.file.FileCollectionBackFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.FileBackedDirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.provider.AbstractProviderWithValue;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSets;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.MutableBoolean;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public abstract class AbstractFileCollection
implements FileCollectionInternal {
    protected final Factory<PatternSet> patternSetFactory;

    protected AbstractFileCollection(Factory<PatternSet> patternSetFactory) {
        this.patternSetFactory = patternSetFactory;
    }

    public AbstractFileCollection() {
        this.patternSetFactory = PatternSets.getNonCachingPatternSetFactory();
    }

    public abstract String getDisplayName();

    public String toString() {
        return this.getDisplayName();
    }

    public final TaskDependency getBuildDependencies() {
        return new AbstractTaskDependency(){

            public String toString() {
                return "Dependencies of " + AbstractFileCollection.this.getDisplayName();
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add((Object)AbstractFileCollection.this);
            }
        };
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
    }

    public File getSingleFile() throws IllegalStateException {
        Iterator<File> iterator = this.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains no files.", this.getDisplayName()));
        }
        File singleFile = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains more than one file.", this.getDisplayName()));
        }
        return singleFile;
    }

    public Iterator<File> iterator() {
        return this.getFiles().iterator();
    }

    public String getAsPath() {
        return GUtil.asPath((Iterable)((Object)this));
    }

    public boolean contains(File file) {
        return this.getFiles().contains(file);
    }

    public FileCollection plus(FileCollection collection) {
        return new UnionFileCollection(this, collection);
    }

    public Provider<Set<FileSystemLocation>> getElements() {
        return new ElementsProvider(this);
    }

    public FileCollection minus(final FileCollection collection) {
        return new AbstractFileCollection(this.patternSetFactory){

            @Override
            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                AbstractFileCollection.this.visitDependencies(context);
            }

            public Set<File> getFiles() {
                LinkedHashSet<File> files = new LinkedHashSet<File>(AbstractFileCollection.this.getFiles());
                files.removeAll(collection.getFiles());
                return files;
            }

            @Override
            public boolean contains(File file) {
                return AbstractFileCollection.this.contains(file) && !collection.contains(file);
            }
        };
    }

    public void addToAntBuilder(Object builder, String nodeName, FileCollection.AntType type) {
        if (type == FileCollection.AntType.ResourceCollection) {
            this.addAsResourceCollection(builder, nodeName);
        } else if (type == FileCollection.AntType.FileSet) {
            this.addAsFileSet(builder, nodeName);
        } else {
            this.addAsMatchingTask(builder, nodeName);
        }
    }

    protected void addAsMatchingTask(Object builder, String nodeName) {
        new AntFileCollectionMatchingTaskBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsFileSet(Object builder, String nodeName) {
        new AntFileSetBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsResourceCollection(Object builder, String nodeName) {
        new AntFileCollectionBuilder(this).addToAntBuilder(builder, nodeName);
    }

    protected Collection<DirectoryTree> getAsFileTrees() {
        final ArrayList<DirectoryTree> fileTrees = new ArrayList<DirectoryTree>();
        this.visitStructure(new FileCollectionStructureVisitor(){

            @Override
            public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                for (File file : contents) {
                    if (!file.isFile()) continue;
                    fileTrees.add(new FileBackedDirectoryFileTree(file));
                }
            }

            @Override
            public void visitFileTree(final File root, final PatternSet patterns, FileTreeInternal fileTree) {
                if (root.isFile()) {
                    fileTrees.add(new FileBackedDirectoryFileTree(root));
                } else if (root.isDirectory()) {
                    fileTrees.add(new DirectoryTree(){

                        public File getDir() {
                            return root;
                        }

                        public PatternSet getPatterns() {
                            return patterns;
                        }
                    });
                }
            }

            @Override
            public void visitGenericFileTree(FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                if (AbstractFileCollection.this.visitAll(sourceTree)) {
                    fileTrees.add(sourceTree.getMirror());
                }
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                this.visitGenericFileTree(fileTree, sourceTree);
            }
        });
        return fileTrees;
    }

    protected boolean visitAll(FileSystemMirroringFileTree tree) {
        final MutableBoolean hasContent = new MutableBoolean();
        tree.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                dirDetails.getFile();
                hasContent.set(true);
            }

            public void visitFile(FileVisitDetails fileDetails) {
                fileDetails.getFile();
                hasContent.set(true);
            }
        });
        return hasContent.get();
    }

    public Object addToAntBuilder(Object node, String childNodeName) {
        this.addToAntBuilder(node, childNodeName, FileCollection.AntType.ResourceCollection);
        return this;
    }

    public boolean isEmpty() {
        return this.getFiles().isEmpty();
    }

    public FileTree getAsFileTree() {
        return new FileCollectionBackFileTree(this.patternSetFactory, this);
    }

    public FileCollection filter(Closure filterClosure) {
        return this.filter((Spec<? super File>)Specs.convertClosureToSpec((Closure)filterClosure));
    }

    public FileCollection filter(final Spec<? super File> filterSpec) {
        final Predicate predicate = arg_0 -> filterSpec.isSatisfiedBy(arg_0);
        return new AbstractFileCollection(this.patternSetFactory){

            @Override
            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                AbstractFileCollection.this.visitDependencies(context);
            }

            public Set<File> getFiles() {
                return (Set)CollectionUtils.filter((Iterable)((Object)AbstractFileCollection.this), new LinkedHashSet(), (Spec)filterSpec);
            }

            @Override
            public boolean contains(File file) {
                return AbstractFileCollection.this.contains(file) && predicate.apply((Object)file);
            }

            @Override
            public Iterator<File> iterator() {
                return Iterators.filter(AbstractFileCollection.this.iterator(), (Predicate)predicate);
            }
        };
    }

    @Override
    public void visitStructure(FileCollectionStructureVisitor visitor) {
        if (visitor.prepareForVisit(OTHER) != FileCollectionStructureVisitor.VisitType.NoContents) {
            visitor.visitCollection(OTHER, (Iterable<File>)((Object)this));
        }
    }

    private static class ElementsProvider
    extends AbstractProviderWithValue<Set<FileSystemLocation>> {
        private final AbstractFileCollection collection;

        public ElementsProvider(AbstractFileCollection collection) {
            this.collection = collection;
        }

        public Class<Set<FileSystemLocation>> getType() {
            return (Class)Cast.uncheckedCast(Set.class);
        }

        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            context.add((Object)this.collection);
            return true;
        }

        public boolean isValueProducedByTask() {
            return !this.collection.getBuildDependencies().getDependencies(null).isEmpty();
        }

        public Set<FileSystemLocation> get() {
            Set files = this.collection.getFiles();
            ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)files.size());
            for (File file : files) {
                builder.add((Object)new DefaultFileSystemLocation(file));
            }
            return builder.build();
        }
    }
}

