/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.classpath.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.api.internal.changedetection.state.RuntimeClasspathResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipHasher;
import org.gradle.internal.Factory;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.CompleteDirectorySnapshot;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathSegmentsTracker;
import org.gradle.internal.snapshot.RelativePathStringTracker;

public class ClasspathFingerprintingStrategy
extends AbstractFingerprintingStrategy {
    private final NonJarFingerprintingStrategy nonZipFingerprintingStrategy;
    private final ResourceFilter classpathResourceFilter;
    private final ResourceSnapshotterCacheService cacheService;
    private final ResourceHasher classpathResourceHasher;
    private final ZipHasher zipHasher;
    private final StringInterner stringInterner;
    private final HashCode zipHasherConfigurationHash;

    private ClasspathFingerprintingStrategy(String identifier, NonJarFingerprintingStrategy nonZipFingerprintingStrategy, ResourceHasher classpathResourceHasher, ResourceFilter classpathResourceFilter, ResourceSnapshotterCacheService cacheService, StringInterner stringInterner) {
        super(identifier);
        this.nonZipFingerprintingStrategy = nonZipFingerprintingStrategy;
        this.classpathResourceFilter = classpathResourceFilter;
        this.classpathResourceHasher = classpathResourceHasher;
        this.cacheService = cacheService;
        this.stringInterner = stringInterner;
        this.zipHasher = new ZipHasher(classpathResourceHasher, classpathResourceFilter);
        Hasher hasher = Hashing.newHasher();
        this.zipHasher.appendConfigurationToHasher(hasher);
        this.zipHasherConfigurationHash = hasher.hash();
    }

    public static ClasspathFingerprintingStrategy runtimeClasspath(ResourceFilter classpathResourceFilter, RuntimeClasspathResourceHasher runtimeClasspathResourceHasher, ResourceSnapshotterCacheService cacheService, StringInterner stringInterner) {
        return new ClasspathFingerprintingStrategy("CLASSPATH", NonJarFingerprintingStrategy.USE_FILE_HASH, runtimeClasspathResourceHasher, classpathResourceFilter, cacheService, stringInterner);
    }

    public static ClasspathFingerprintingStrategy compileClasspath(ResourceHasher classpathResourceHasher, ResourceSnapshotterCacheService cacheService, StringInterner stringInterner) {
        return new ClasspathFingerprintingStrategy("COMPILE_CLASSPATH", NonJarFingerprintingStrategy.IGNORE, classpathResourceHasher, ResourceFilter.FILTER_NOTHING, cacheService, stringInterner);
    }

    public String normalizePath(CompleteFileSystemLocationSnapshot snapshot) {
        return "";
    }

    public Map<String, FileSystemLocationFingerprint> collectFingerprints(Iterable<? extends FileSystemSnapshot> roots) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet<String> processedEntries = new HashSet<String>();
        for (FileSystemSnapshot fileSystemSnapshot : roots) {
            ClasspathFingerprintVisitor fingerprintVisitor = new ClasspathFingerprintVisitor(processedEntries, (ImmutableMap.Builder<String, FileSystemLocationFingerprint>)builder);
            fileSystemSnapshot.accept((FileSystemSnapshotVisitor)new ClasspathContentFingerprintingVisitor(fingerprintVisitor));
        }
        return builder.build();
    }

    @Nullable
    private HashCode fingerprintRootFile(RegularFileSnapshot fileSnapshot) {
        if (ZipHasher.isZipFile(fileSnapshot.getName())) {
            return this.fingerprintZipContents(fileSnapshot);
        }
        return this.nonZipFingerprintingStrategy.determineNonJarFingerprint(fileSnapshot.getHash());
    }

    @Nullable
    private HashCode fingerprintZipContents(RegularFileSnapshot fileSnapshot) {
        return this.cacheService.hashFile(fileSnapshot, this.zipHasher, this.zipHasherConfigurationHash);
    }

    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.KEEP_ORDER;
    }

    private class ClasspathFingerprintVisitor {
        private final RelativePathStringTracker relativePathStringTracker;
        private final HashSet<String> processedEntries;
        private final ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder;

        public ClasspathFingerprintVisitor(HashSet<String> processedEntries, ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder) {
            this.processedEntries = processedEntries;
            this.builder = builder;
            this.relativePathStringTracker = new RelativePathStringTracker();
        }

        public boolean preVisitDirectory(CompleteFileSystemLocationSnapshot directorySnapshot) {
            this.relativePathStringTracker.enter(directorySnapshot);
            return true;
        }

        public void visit(CompleteFileSystemLocationSnapshot fileSnapshot, HashCode normalizedContentHash) {
            String absolutePath = fileSnapshot.getAbsolutePath();
            if (this.processedEntries.add(absolutePath)) {
                IgnoredPathFileSystemLocationFingerprint fingerprint = this.relativePathStringTracker.isRoot() ? IgnoredPathFileSystemLocationFingerprint.create((FileType)fileSnapshot.getType(), (HashCode)normalizedContentHash) : this.createFileFingerprint(fileSnapshot, normalizedContentHash);
                this.builder.put((Object)absolutePath, (Object)fingerprint);
            }
        }

        private FileSystemLocationFingerprint createFileFingerprint(CompleteFileSystemLocationSnapshot snapshot, HashCode content) {
            this.relativePathStringTracker.enter(snapshot);
            DefaultFileSystemLocationFingerprint fingerprint = new DefaultFileSystemLocationFingerprint(ClasspathFingerprintingStrategy.this.stringInterner.intern(this.relativePathStringTracker.getRelativePathString()), FileType.RegularFile, content);
            this.relativePathStringTracker.leave();
            return fingerprint;
        }

        public void postVisitDirectory() {
            this.relativePathStringTracker.leave();
        }
    }

    private class ClasspathContentFingerprintingVisitor
    implements FileSystemSnapshotVisitor {
        private final ClasspathFingerprintVisitor delegate;
        private final RelativePathSegmentsTracker relativePathSegmentsTracker = new RelativePathSegmentsTracker();
        private final Factory<String[]> relativePathFactory = new Factory<String[]>(){

            public String[] create() {
                return (String[])Iterables.toArray((Iterable)ClasspathContentFingerprintingVisitor.this.relativePathSegmentsTracker.getRelativePath(), String.class);
            }
        };

        public ClasspathContentFingerprintingVisitor(ClasspathFingerprintVisitor delegate) {
            this.delegate = delegate;
        }

        public boolean preVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            this.relativePathSegmentsTracker.enter((CompleteFileSystemLocationSnapshot)directorySnapshot);
            return this.delegate.preVisitDirectory((CompleteFileSystemLocationSnapshot)directorySnapshot);
        }

        public void visitFile(CompleteFileSystemLocationSnapshot fileSnapshot) {
            if (fileSnapshot instanceof RegularFileSnapshot) {
                HashCode normalizedContent = this.fingerprintFile((RegularFileSnapshot)fileSnapshot);
                if (normalizedContent != null) {
                    this.delegate.visit(fileSnapshot, normalizedContent);
                }
            } else if (!this.relativePathSegmentsTracker.isRoot()) {
                throw new GradleException(String.format("Couldn't read file content: '%s'.", fileSnapshot.getAbsolutePath()));
            }
        }

        @Nullable
        private HashCode fingerprintFile(RegularFileSnapshot fileSnapshot) {
            return this.relativePathSegmentsTracker.isRoot() ? ClasspathFingerprintingStrategy.this.fingerprintRootFile(fileSnapshot) : this.fingerprintTreeFile(fileSnapshot);
        }

        @Nullable
        private HashCode fingerprintTreeFile(RegularFileSnapshot fileSnapshot) {
            this.relativePathSegmentsTracker.enter((CompleteFileSystemLocationSnapshot)fileSnapshot);
            boolean shouldBeIgnored = ClasspathFingerprintingStrategy.this.classpathResourceFilter.shouldBeIgnored(this.relativePathFactory);
            this.relativePathSegmentsTracker.leave();
            if (shouldBeIgnored) {
                return null;
            }
            return ClasspathFingerprintingStrategy.this.classpathResourceHasher.hash(fileSnapshot);
        }

        public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            this.relativePathSegmentsTracker.leave();
            this.delegate.postVisitDirectory();
        }
    }

    public static enum NonJarFingerprintingStrategy {
        IGNORE{

            @Override
            @Nullable
            public HashCode determineNonJarFingerprint(HashCode original) {
                return null;
            }
        }
        ,
        USE_FILE_HASH{

            @Override
            public HashCode determineNonJarFingerprint(HashCode original) {
                return original;
            }
        };


        @Nullable
        public abstract HashCode determineNonJarFingerprint(HashCode var1);
    }
}

