/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.internal.jni.OsxFileEventFunctions;
import org.gradle.internal.vfs.AbstractEventDrivenFileWatcherRegistry;
import org.gradle.internal.vfs.SnapshotHierarchy;
import org.gradle.internal.vfs.watch.FileWatcherRegistry;
import org.gradle.internal.vfs.watch.FileWatcherRegistryFactory;
import org.gradle.internal.vfs.watch.WatchRootUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DarwinFileWatcherRegistry
extends AbstractEventDrivenFileWatcherRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DarwinFileWatcherRegistry.class);

    public DarwinFileWatcherRegistry(Set<Path> watchRoots, FileWatcherRegistry.ChangeHandler handler) {
        super(watchRoots, callback -> ((OsxFileEventFunctions)Native.get(OsxFileEventFunctions.class)).startWatcher(20L, TimeUnit.MICROSECONDS, callback), handler);
    }

    public static class Factory
    implements FileWatcherRegistryFactory {
        public FileWatcherRegistry startWatching(SnapshotHierarchy snapshotHierarchy, Predicate<String> watchFilter, Collection<File> mustWatchDirectories, FileWatcherRegistry.ChangeHandler handler) {
            ImmutableSet mustWatchDirectoryPrefixes = ImmutableSet.copyOf(mustWatchDirectories.stream().map(path -> path.getAbsolutePath() + File.separator)::iterator);
            Set directories = WatchRootUtil.resolveDirectoriesToWatch((SnapshotHierarchy)snapshotHierarchy, arg_0 -> Factory.lambda$startWatching$1(watchFilter, (Set)mustWatchDirectoryPrefixes, arg_0), mustWatchDirectories);
            Set watchRoots = WatchRootUtil.resolveRootsToWatch((Set)directories);
            LOGGER.warn("Watching {} directory hierarchies to track changes between builds in {} directories", (Object)watchRoots.size(), (Object)directories.size());
            return new DarwinFileWatcherRegistry(watchRoots, handler);
        }

        private static boolean startsWithAnyPrefix(String path, Set<String> prefixes) {
            for (String prefix : prefixes) {
                if (!path.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ boolean lambda$startWatching$1(Predicate watchFilter, Set mustWatchDirectoryPrefixes, String path) {
            return watchFilter.test(path) || Factory.startsWithAnyPrefix(path, mustWatchDirectoryPrefixes);
        }
    }
}

