/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.gradle.StartParameter;
import org.gradle.api.internal.tasks.execution.statistics.TaskExecutionStatisticsEventAdapter;
import org.gradle.api.logging.Logging;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.internal.buildevents.BuildLogger;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.buildevents.TaskExecutionStatisticsReporter;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.time.Clock;

public class BuildOutcomeReportingBuildActionRunner
implements BuildActionRunner {
    private final BuildActionRunner delegate;
    private final StyledTextOutputFactory styledTextOutputFactory;

    public BuildOutcomeReportingBuildActionRunner(BuildActionRunner delegate, StyledTextOutputFactory styledTextOutputFactory) {
        this.delegate = delegate;
        this.styledTextOutputFactory = styledTextOutputFactory;
    }

    public BuildActionRunner.Result run(BuildAction action, BuildController buildController) {
        StartParameter startParameter = buildController.getGradle().getStartParameter();
        ServiceRegistry services = buildController.getGradle().getServices();
        BuildStartedTime buildStartedTime = services.get(BuildStartedTime.class);
        BuildRequestMetaData buildRequestMetaData = services.get(BuildRequestMetaData.class);
        Clock clock = services.get(Clock.class);
        ListenerManager listenerManager = services.get(ListenerManager.class);
        TaskExecutionStatisticsEventAdapter taskStatisticsCollector = new TaskExecutionStatisticsEventAdapter();
        listenerManager.addListener((Object)taskStatisticsCollector);
        BuildLogger buildLogger = new BuildLogger(Logging.getLogger(BuildLogger.class), this.styledTextOutputFactory, startParameter, buildRequestMetaData, buildStartedTime, clock);
        buildController.getGradle().useLogger((Object)buildLogger);
        BuildActionRunner.Result result = this.delegate.run(action, buildController);
        Throwable failure = DeprecationLogger.getDeprecationFailure();
        if (failure != null) {
            result = this.computeUpdatedResult(result, failure);
        }
        buildLogger.logResult(result.getBuildFailure());
        new TaskExecutionStatisticsReporter(this.styledTextOutputFactory).buildFinished(taskStatisticsCollector.getStatistics());
        return result;
    }

    private BuildActionRunner.Result computeUpdatedResult(BuildActionRunner.Result previousResult, Throwable deprecationFailure) {
        if (previousResult.getBuildFailure() != null) {
            ArrayList newFailures;
            Throwable buildFailure = previousResult.getBuildFailure();
            if (buildFailure instanceof MultipleBuildFailures) {
                MultipleBuildFailures multipleBuildFailures = (MultipleBuildFailures)buildFailure;
                newFailures = Lists.newArrayListWithExpectedSize((int)(multipleBuildFailures.getCauses().size() + 1));
                newFailures.addAll(multipleBuildFailures.getCauses());
            } else {
                newFailures = Lists.newArrayListWithExpectedSize((int)2);
                newFailures.add(buildFailure);
            }
            newFailures.add(deprecationFailure);
            previousResult = BuildActionRunner.Result.failed((Throwable)new MultipleBuildFailures((Collection)newFailures));
        } else {
            previousResult = BuildActionRunner.Result.failed((Throwable)deprecationFailure);
        }
        return previousResult;
    }
}

